/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.fruchterman;

import java.util.ArrayList;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeData;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.plugin.ForceVectorNodeLayoutData;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.NbBundle;

public class FruchtermanReingold
extends AbstractLayout
implements Layout {
    private static final float SPEED_DIVISOR = 800.0f;
    private static final float AREA_MULTIPLICATOR = 10000.0f;
    protected HierarchicalGraph graph;
    private float area;
    private double gravity;
    private double speed;

    public FruchtermanReingold(LayoutBuilder layoutBuilder) {
        super(layoutBuilder);
    }

    public void resetPropertiesValues() {
        this.speed = 1.0;
        this.area = 10000.0f;
        this.gravity = 10.0;
    }

    public void initAlgo() {
        this.graph = this.graphModel.getHierarchicalGraphVisible();
        for (Node n : this.graph.getNodes()) {
            n.getNodeData().setLayoutData(new ForceVectorNodeLayoutData());
        }
    }

    public void goAlgo() {
        ForceVectorNodeLayoutData layoutData;
        this.graph = this.graphModel.getHierarchicalGraphVisible();
        this.graph.readLock();
        Node[] nodes = this.graph.getNodes().toArray();
        Edge[] edges = this.graph.getEdgesAndMetaEdges().toArray();
        for (Node n : nodes) {
            if (n.getNodeData().getLayoutData() == null || !(n.getNodeData().getLayoutData() instanceof ForceVectorNodeLayoutData)) {
                n.getNodeData().setLayoutData(new ForceVectorNodeLayoutData());
            }
            ForceVectorNodeLayoutData layoutData2 = (ForceVectorNodeLayoutData)n.getNodeData().getLayoutData();
            layoutData2.dx = 0.0f;
            layoutData2.dy = 0.0f;
        }
        float maxDisplace = (float)(Math.sqrt(10000.0f * this.area) / 10.0);
        float k = (float)Math.sqrt(10000.0f * this.area / (1.0f + (float)nodes.length));
        for (Node node : nodes) {
            for (Node N2 : nodes) {
                float yDist;
                float xDist;
                float dist;
                if (node == N2 || !((dist = (float)Math.sqrt((xDist = node.getNodeData().x() - N2.getNodeData().x()) * xDist + (yDist = node.getNodeData().y() - N2.getNodeData().y()) * yDist)) > 0.0f)) continue;
                float repulsiveF = k * k / dist;
                ForceVectorNodeLayoutData layoutData3 = (ForceVectorNodeLayoutData)node.getNodeData().getLayoutData();
                layoutData3.dx += xDist / dist * repulsiveF;
                layoutData3.dy += yDist / dist * repulsiveF;
            }
        }
        for (Edge edge : edges) {
            Node Nf = edge.getSource();
            Node Nt = edge.getTarget();
            float xDist = Nf.getNodeData().x() - Nt.getNodeData().x();
            float yDist = Nf.getNodeData().y() - Nt.getNodeData().y();
            float dist = (float)Math.sqrt(xDist * xDist + yDist * yDist);
            float attractiveF = dist * dist / k;
            if (!(dist > 0.0f)) continue;
            ForceVectorNodeLayoutData sourceLayoutData = (ForceVectorNodeLayoutData)Nf.getNodeData().getLayoutData();
            ForceVectorNodeLayoutData targetLayoutData = (ForceVectorNodeLayoutData)Nt.getNodeData().getLayoutData();
            sourceLayoutData.dx -= xDist / dist * attractiveF;
            sourceLayoutData.dy -= yDist / dist * attractiveF;
            targetLayoutData.dx += xDist / dist * attractiveF;
            targetLayoutData.dy += yDist / dist * attractiveF;
        }
        for (Node node : nodes) {
            NodeData nodeData = node.getNodeData();
            ForceVectorNodeLayoutData layoutData4 = (ForceVectorNodeLayoutData)nodeData.getLayoutData();
            float d = (float)Math.sqrt(nodeData.x() * nodeData.x() + nodeData.y() * nodeData.y());
            float gf = 0.01f * k * (float)this.gravity * d;
            layoutData4.dx -= gf * nodeData.x() / d;
            layoutData4.dy -= gf * nodeData.y() / d;
        }
        for (Node node : nodes) {
            layoutData = (ForceVectorNodeLayoutData)node.getNodeData().getLayoutData();
            layoutData.dx = (float)((double)layoutData.dx * (this.speed / 800.0));
            layoutData.dy = (float)((double)layoutData.dy * (this.speed / 800.0));
        }
        for (Node node : nodes) {
            layoutData = (ForceVectorNodeLayoutData)node.getNodeData().getLayoutData();
            float xDist = layoutData.dx;
            float yDist = layoutData.dy;
            float dist = (float)Math.sqrt(layoutData.dx * layoutData.dx + layoutData.dy * layoutData.dy);
            if (!(dist > 0.0f) || node.getNodeData().isFixed()) continue;
            float limitedDist = Math.min(maxDisplace * ((float)this.speed / 800.0f), dist);
            node.getNodeData().setX(node.getNodeData().x() + xDist / dist * limitedDist);
            node.getNodeData().setY(node.getNodeData().y() + yDist / dist * limitedDist);
        }
        this.graph.readUnlock();
    }

    public void endAlgo() {
        for (Node n : this.graph.getNodes()) {
            n.getNodeData().setLayoutData(null);
        }
    }

    public boolean canAlgo() {
        return true;
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        String FRUCHTERMAN_REINGOLD = "Fruchterman Reingold";
        try {
            properties.add(LayoutProperty.createProperty(this, Float.class, NbBundle.getMessage(FruchtermanReingold.class, (String)"fruchtermanReingold.area.name"), "Fruchterman Reingold", NbBundle.getMessage(FruchtermanReingold.class, (String)"fruchtermanReingold.area.desc"), "getArea", "setArea"));
            properties.add(LayoutProperty.createProperty(this, Double.class, NbBundle.getMessage(FruchtermanReingold.class, (String)"fruchtermanReingold.gravity.name"), "Fruchterman Reingold", NbBundle.getMessage(FruchtermanReingold.class, (String)"fruchtermanReingold.gravity.desc"), "getGravity", "setGravity"));
            properties.add(LayoutProperty.createProperty(this, Double.class, NbBundle.getMessage(FruchtermanReingold.class, (String)"fruchtermanReingold.speed.name"), "Fruchterman Reingold", NbBundle.getMessage(FruchtermanReingold.class, (String)"fruchtermanReingold.speed.desc"), "getSpeed", "setSpeed"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public Float getArea() {
        return Float.valueOf(this.area);
    }

    public void setArea(Float area) {
        this.area = area.floatValue();
    }

    public Double getGravity() {
        return this.gravity;
    }

    public void setGravity(Double gravity) {
        this.gravity = gravity;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }
}

