/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.labelAdjust;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.plugin.ForceVectorUtils;
import org.gephi.layout.plugin.labelAdjust.LabelAdjustLayoutData;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;

public class LabelAdjust
extends AbstractLayout
implements Layout {
    protected Graph graph;
    private double speed = 1.0;
    private final double RADIUS_SCALE = 2.0;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;

    public LabelAdjust(LayoutBuilder layoutBuilder) {
        super(layoutBuilder);
    }

    public void resetPropertiesValues() {
        this.speed = 1.0;
    }

    public void initAlgo() {
        this.setConverged(false);
    }

    public void goAlgo() {
        Node[] nodes;
        boolean somethingMoved = false;
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        for (Node n : nodes = this.graph.getNodes().toArray()) {
            if (n.getNodeData().getLayoutData() == null || !(n.getNodeData().getLayoutData() instanceof LabelAdjustLayoutData)) {
                n.getNodeData().setLayoutData(new LabelAdjustLayoutData());
            }
            LabelAdjustLayoutData layoutData = (LabelAdjustLayoutData)n.getNodeData().getLayoutData();
            layoutData.neighbours.clear();
            layoutData.dx = 0.0f;
            layoutData.dy = 0.0f;
        }
        this.xmin = Double.MAX_VALUE;
        this.xmax = Double.MIN_VALUE;
        this.ymin = Double.MAX_VALUE;
        this.ymax = Double.MIN_VALUE;
        ArrayList<Node> correctNodes = new ArrayList<Node>();
        for (Node n : nodes) {
            float x = n.getNodeData().x();
            float y = n.getNodeData().y();
            float w = n.getNodeData().getTextData().getWidth();
            float h = n.getNodeData().getTextData().getHeight();
            float radius = n.getNodeData().getRadius();
            if (!(w > 0.0f) || !(h > 0.0f)) continue;
            double nxmin = Math.min(x - w / 2.0f, x - radius);
            double nxmax = Math.max(x + w / 2.0f, x + radius);
            double nymin = Math.min(y - h / 2.0f, y - radius);
            double nymax = Math.max(y + h / 2.0f, y + radius);
            this.xmin = Math.min(this.xmin, nxmin);
            this.xmax = Math.max(this.xmax, nxmax);
            this.ymin = Math.min(this.ymin, nymin);
            this.ymax = Math.max(this.ymax, nymax);
            correctNodes.add(n);
        }
        if (correctNodes.isEmpty()) {
            this.graph.readUnlock();
            return;
        }
        double xwidth = this.xmax - this.xmin;
        double yheight = this.ymax - this.ymin;
        double xcenter = (this.xmin + this.xmax) / 2.0;
        double ycenter = (this.ymin + this.ymax) / 2.0;
        double ratio = 1.1;
        this.xmin = xcenter - ratio * xwidth / 2.0;
        this.xmax = xcenter + ratio * xwidth / 2.0;
        this.ymin = ycenter - ratio * yheight / 2.0;
        this.ymax = ycenter + ratio * yheight / 2.0;
        SpatialGrid grid = new SpatialGrid();
        for (Node n : correctNodes) {
            grid.add(n);
        }
        for (int row = 0; row < grid.countRows(); ++row) {
            for (int col = 0; col < grid.countColumns(); ++col) {
                for (Node n : grid.getContent(row, col)) {
                    LabelAdjustLayoutData lald = (LabelAdjustLayoutData)n.getNodeData().getLayoutData();
                    for (int row2 = Math.max(0, row - 1); row2 <= Math.min(row + 1, grid.countRows() - 1); ++row2) {
                        for (int col2 = Math.max(0, col - 1); col2 <= Math.min(col + 1, grid.countColumns() - 1); ++col2) {
                            for (Node n2 : grid.getContent(row2, col2)) {
                                if (n2 == n || lald.neighbours.contains(n2)) continue;
                                lald.neighbours.add(n2);
                            }
                        }
                    }
                }
            }
        }
        for (Node n1 : correctNodes) {
            LabelAdjustLayoutData lald = (LabelAdjustLayoutData)n1.getNodeData().getLayoutData();
            for (Node n2 : lald.neighbours) {
                double yDist;
                boolean sphereCollision;
                float n1x = n1.getNodeData().x();
                float n1y = n1.getNodeData().y();
                float n2x = n2.getNodeData().x();
                float n2y = n2.getNodeData().y();
                float n1w = n1.getNodeData().getTextData().getWidth();
                float n2w = n2.getNodeData().getTextData().getWidth();
                float n1h = n1.getNodeData().getTextData().getHeight();
                float n2h = n2.getNodeData().getTextData().getHeight();
                double xDist = Math.abs(n1x - n2x);
                boolean bl = sphereCollision = Math.sqrt(xDist * xDist + (yDist = (double)Math.abs(n1.getNodeData().y() - n2.getNodeData().y())) * yDist) < 2.0 * (double)(n1.getNodeData().getRadius() + n2.getNodeData().getRadius());
                if (sphereCollision) {
                    ForceVectorUtils.fcUniRepulsor(n1.getNodeData(), n2.getNodeData(), 0.1 * (double)n1.getNodeData().getRadius());
                    somethingMoved = true;
                }
                double n1xmin = (double)n1x - 0.5 * (double)n1w;
                double n2xmin = (double)n2x - 0.5 * (double)n2w;
                double n1ymin = (double)n1y - 0.5 * (double)n1h;
                double n2ymin = (double)n2y - 0.5 * (double)n2h;
                double n1xmax = (double)n1x + 0.5 * (double)n1w;
                double n2xmax = (double)n2x + 0.5 * (double)n2w;
                double n1ymax = (double)n1y + 0.5 * (double)n1h;
                double n2ymax = (double)n2y + 0.5 * (double)n2h;
                double upDifferential = n1ymax - n2ymin;
                double downDifferential = n2ymax - n1ymin;
                double labelCollisionXleft = n2xmax - n1xmin;
                double labelCollisionXright = n1xmax - n2xmin;
                LabelAdjustLayoutData layoutData = (LabelAdjustLayoutData)n2.getNodeData().getLayoutData();
                if (!(upDifferential > 0.0) || !(downDifferential > 0.0) || !(labelCollisionXleft > 0.0) || !(labelCollisionXright > 0.0)) continue;
                if (upDifferential > downDifferential) {
                    layoutData.dy = (float)((double)layoutData.dy - 0.01 * (double)n1h * (0.8 + 0.4 * Math.random()));
                    somethingMoved = true;
                } else {
                    layoutData.dy = (float)((double)layoutData.dy + 0.01 * (double)n1h * (0.8 + 0.4 * Math.random()));
                    somethingMoved = true;
                }
                if (labelCollisionXleft > labelCollisionXright) {
                    layoutData.dx = (float)((double)layoutData.dx + 0.01 * (double)(n1h / 2.0f) * (0.8 + 0.4 * Math.random()));
                    somethingMoved = true;
                    continue;
                }
                layoutData.dx = (float)((double)layoutData.dx - 0.01 * (double)(n1h / 2.0f) * (0.8 + 0.4 * Math.random()));
                somethingMoved = true;
            }
        }
        for (Node n : correctNodes) {
            LabelAdjustLayoutData layoutData = (LabelAdjustLayoutData)n.getNodeData().getLayoutData();
            if (n.getNodeData().isFixed()) continue;
            layoutData.dx = (float)((double)layoutData.dx * this.speed);
            layoutData.dy = (float)((double)layoutData.dy * this.speed);
            float x = n.getNodeData().x() + layoutData.dx;
            float y = n.getNodeData().y() + layoutData.dy;
            n.getNodeData().setX(x);
            n.getNodeData().setY(y);
        }
        if (!somethingMoved) {
            this.setConverged(true);
        }
        this.graph.readUnlock();
    }

    public void endAlgo() {
        for (Node n : this.graph.getNodes()) {
            n.getNodeData().setLayoutData(null);
        }
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        String LABELADJUST_CATEGORY = "LabelAdjust";
        try {
            properties.add(LayoutProperty.createProperty(this, Double.class, "speed", "LabelAdjust", "speed", "getSpeed", "setSpeed"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    private static class Cell {
        private final int row;
        private final int col;

        public Cell(int row, int col) {
            this.row = row;
            this.col = col;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Cell other = (Cell)obj;
            if (this.row != other.row) {
                return false;
            }
            return this.col == other.col;
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + this.row;
            hash = 11 * hash + this.col;
            return hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SpatialGrid {
        private final int COLUMNS_ROWS = 20;
        private Map<Cell, List<Node>> data = new HashMap<Cell, List<Node>>();

        public SpatialGrid() {
            for (int row = 0; row < 20; ++row) {
                for (int col = 0; col < 20; ++col) {
                    ArrayList localnodes = new ArrayList();
                    this.data.put(new Cell(row, col), localnodes);
                }
            }
        }

        public Iterable<Node> getContent(int row, int col) {
            return this.data.get(new Cell(row, col));
        }

        public int countColumns() {
            return 20;
        }

        public int countRows() {
            return 20;
        }

        public void add(Node node) {
            float x = node.getNodeData().x();
            float y = node.getNodeData().y();
            float w = node.getNodeData().getTextData().getWidth();
            float h = node.getNodeData().getTextData().getHeight();
            float radius = node.getNodeData().getRadius();
            double nxmin = Math.min(x - w / 2.0f, x - radius);
            double nxmax = Math.max(x + w / 2.0f, x + radius);
            double nymin = Math.min(y - h / 2.0f, y - radius);
            double nymax = Math.max(y + h / 2.0f, y + radius);
            int minXbox = (int)Math.floor(19.0 * (nxmin - LabelAdjust.this.xmin) / (LabelAdjust.this.xmax - LabelAdjust.this.xmin));
            int maxXbox = (int)Math.floor(19.0 * (nxmax - LabelAdjust.this.xmin) / (LabelAdjust.this.xmax - LabelAdjust.this.xmin));
            int minYbox = (int)Math.floor(19.0 * (nymin - LabelAdjust.this.ymin) / (LabelAdjust.this.ymax - LabelAdjust.this.ymin));
            int maxYbox = (int)Math.floor(19.0 * (nymax - LabelAdjust.this.ymin) / (LabelAdjust.this.ymax - LabelAdjust.this.ymin));
            for (int col = minXbox; col <= maxXbox; ++col) {
                for (int row = minYbox; row <= maxYbox; ++row) {
                    try {
                        this.data.get(new Cell(row, col)).add(node);
                        continue;
                    }
                    catch (Exception e) {
                        if (nxmin < LabelAdjust.this.xmin || nxmax > LabelAdjust.this.xmax) {
                            System.err.println("Xerr0r* - " + node.getId() + " - nxmin=" + nxmin + " this.xmin=" + LabelAdjust.this.xmin + " nxmax=" + nxmax + " this.xmax=" + LabelAdjust.this.xmax);
                        }
                        if (!(nymin < LabelAdjust.this.ymin) && !(nymax > LabelAdjust.this.ymax)) continue;
                        System.err.println("Yerr0r* - " + node.getId() + " - nymin=" + nymin + " this.ymin=" + LabelAdjust.this.ymin + " nymax=" + nymax + " this.ymax=" + LabelAdjust.this.ymax);
                    }
                }
            }
        }
    }
}

