/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.multilevel;

import org.gephi.graph.api.Edge;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.multilevel.MultiLevelLayout;

public class MaximalMatchingCoarsening
implements MultiLevelLayout.CoarseningStrategy {
    public void coarsen(HierarchicalGraph g) {
        HierarchicalGraph graph = g;
        int retract = 0;
        int count = 0;
        for (Edge e : graph.getEdgesAndMetaEdges().toArray()) {
            Node a = e.getSource();
            Node b = e.getTarget();
            ++count;
            if (graph.getParent(a) != graph.getParent(b) || graph.getLevel(a) != 0) continue;
            float x = (a.getNodeData().x() + b.getNodeData().x()) / 2.0f;
            float y = (a.getNodeData().y() + b.getNodeData().y()) / 2.0f;
            Node parent = graph.groupNodes(new Node[]{a, b});
            parent.getNodeData().setX(x);
            parent.getNodeData().setY(y);
            graph.retract(parent);
            ++retract;
        }
    }

    public void refine(HierarchicalGraph graph) {
        double r = 10.0;
        int count = 0;
        int refined = 0;
        for (Node node : graph.getTopNodes().toArray()) {
            ++count;
            if (graph.getChildrenCount(node) != 2) continue;
            ++refined;
            float x = node.getNodeData().x();
            float y = node.getNodeData().y();
            for (Node child : graph.getChildren(node)) {
                double t = Math.random();
                child.getNodeData().setX((float)((double)x + r * Math.cos(t)));
                child.getNodeData().setY((float)((double)y + r * Math.sin(t)));
            }
            graph.ungroupNodes(node);
        }
    }
}

