/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.multilevel;

import java.util.ArrayList;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.plugin.force.yifanHu.YifanHuLayout;
import org.gephi.layout.plugin.force.yifanHu.YifanHuProportional;
import org.gephi.layout.plugin.random.RandomLayout;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;

public class MultiLevelLayout
extends AbstractLayout
implements Layout {
    private HierarchicalGraph graph;
    private int level;
    private YifanHuLayout layout;
    private YifanHuProportional yifanHu;
    private CoarseningStrategy coarseningStrategy;
    private int minSize;
    private double minCoarseningRate;
    private float stepRatio;
    private float optimalDistance;
    private int quadTreeMaxLevel;
    private float barnesHutTheta;
    private int initedView;

    public MultiLevelLayout(LayoutBuilder layoutBuilder, CoarseningStrategy coarseningStrategy) {
        super(layoutBuilder);
        this.coarseningStrategy = coarseningStrategy;
        this.yifanHu = new YifanHuProportional();
    }

    public void initAlgo() {
        int graphSize;
        int newGraphSize;
        this.graph = this.graphModel.getHierarchicalGraphVisible();
        this.initedView = this.graph.getView().getViewId();
        this.setConverged(false);
        this.level = 0;
        do {
            graphSize = this.graph.getTopNodes().toArray().length;
            this.coarseningStrategy.coarsen(this.graph);
            ++this.level;
        } while ((newGraphSize = this.graph.getTopNodes().toArray().length) >= this.getMinSize() && !((double)newGraphSize > (double)graphSize * this.getMinCoarseningRate()));
        RandomLayout random = new RandomLayout(null, 1000.0);
        random.setGraphModel(this.graphModel);
        random.initAlgo();
        random.goAlgo();
        this.initYifanHu();
    }

    void initYifanHu() {
        this.layout = this.yifanHu.buildLayout();
        this.layout.setGraphModel(this.graphModel);
        this.layout.resetPropertiesValues();
        this.layout.setAdaptiveCooling(false);
        this.layout.setStepRatio(Float.valueOf(this.stepRatio));
        this.layout.setOptimalDistance(Float.valueOf(this.optimalDistance));
        this.layout.setBarnesHutTheta(Float.valueOf(this.barnesHutTheta));
        this.layout.setQuadTreeMaxLevel(this.quadTreeMaxLevel);
        this.layout.initAlgo();
    }

    public void goAlgo() {
        HierarchicalGraph newGraph = this.graphModel.getHierarchicalGraphVisible();
        if (newGraph.getView().getViewId() != this.initedView) {
            this.setConverged(true);
            this.layout.endAlgo();
            this.endAlgo();
            return;
        }
        this.graph = newGraph;
        if (this.layout.canAlgo()) {
            this.layout.goAlgo();
        } else {
            this.layout.endAlgo();
            if (this.level > 0) {
                this.coarseningStrategy.refine(this.graph);
                --this.level;
                this.initYifanHu();
            } else {
                this.setConverged(true);
                this.layout = null;
            }
        }
    }

    public void endAlgo() {
        while (this.level > 0) {
            this.coarseningStrategy.refine(this.graph);
            --this.level;
        }
    }

    public void resetPropertiesValues() {
        this.setMinSize(3);
        this.setMinCoarseningRate(0.75);
        this.setStepRatio(Float.valueOf(0.97f));
        this.setOptimalDistance(Float.valueOf(100.0f));
        this.setQuadTreeMaxLevel(10);
        this.setBarnesHutTheta(Float.valueOf(1.2f));
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        String MULTILEVEL_CATEGORY = "Multi-level";
        String YIFANHU_CATEGORY = "Yifan Hu's properties";
        String BARNESHUT_CATEGORY = "Barnes-Hut's properties";
        try {
            properties.add(LayoutProperty.createProperty(this, Integer.class, "Minimum level size", "Multi-level", "The minimum amount of nodes every level must have (bigger values mean less levels)", "getMinSize", "setMinSize"));
            properties.add(LayoutProperty.createProperty(this, Double.class, "Minimum coarsening rate", "Multi-level", "The minimum relative size between two levels (smaller values mean less levels)", "getMinCoarseningRate", "setMinCoarseningRate"));
            properties.add(LayoutProperty.createProperty(this, Float.class, "Step ratio", "Yifan Hu's properties", "The ratio used to update the step size across iterations.", "getStepRatio", "setStepRatio"));
            properties.add(LayoutProperty.createProperty(this, Float.class, "Optimal Distance", "Yifan Hu's properties", "The natural length of the springs. Bigger values mean nodes will be farther apart.", "getOptimalDistance", "setOptimalDistance"));
            properties.add(LayoutProperty.createProperty(this, Integer.class, "Quadtree Max Level", "Barnes-Hut's properties", "The maximun level to be used in the quadtree representation. Greater values mean more accuracy.", "getQuadTreeMaxLevel", "setQuadTreeMaxLevel"));
            properties.add(LayoutProperty.createProperty(this, Float.class, "Theta", "Barnes-Hut's properties", "The theta parameter for Barnes-Hut opening criteria. Smaller values mean more accuracy.", "getBarnesHutTheta", "setBarnesHutTheta"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public void setMinSize(Integer minSize) {
        this.minSize = minSize;
    }

    public Double getMinCoarseningRate() {
        return this.minCoarseningRate;
    }

    public void setMinCoarseningRate(Double minCoarseningRate) {
        this.minCoarseningRate = minCoarseningRate;
    }

    public Float getStepRatio() {
        return Float.valueOf(this.stepRatio);
    }

    public void setStepRatio(Float stepRatio) {
        this.stepRatio = stepRatio.floatValue();
    }

    public Float getOptimalDistance() {
        return Float.valueOf(this.optimalDistance);
    }

    public void setOptimalDistance(Float optimalDistance) {
        this.optimalDistance = optimalDistance.floatValue();
    }

    public Integer getQuadTreeMaxLevel() {
        return this.quadTreeMaxLevel;
    }

    public void setQuadTreeMaxLevel(Integer quadTreeMaxLevel) {
        this.quadTreeMaxLevel = quadTreeMaxLevel;
    }

    public Float getBarnesHutTheta() {
        return Float.valueOf(this.barnesHutTheta);
    }

    public void setBarnesHutTheta(Float barnesHutTheta) {
        this.barnesHutTheta = barnesHutTheta.floatValue();
    }

    public static interface CoarseningStrategy {
        public void coarsen(HierarchicalGraph var1);

        public void refine(HierarchicalGraph var1);
    }
}

