/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.random;

import java.util.ArrayList;
import java.util.Random;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;

public class RandomLayout
extends AbstractLayout
implements Layout {
    private Random random;
    private Graph graph;
    private boolean converged;
    private double size;

    public RandomLayout(LayoutBuilder layoutBuilder, double size) {
        super(layoutBuilder);
        this.size = size;
        this.random = new Random();
    }

    public void initAlgo() {
        this.converged = false;
        this.graph = this.graphModel.getGraphVisible();
    }

    public void goAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        for (Node n : this.graph.getNodes()) {
            n.getNodeData().setX((float)(-this.size / 2.0 + this.size * this.random.nextDouble()));
            n.getNodeData().setY((float)(-this.size / 2.0 + this.size * this.random.nextDouble()));
        }
        this.converged = true;
    }

    public boolean canAlgo() {
        return !this.converged;
    }

    public void endAlgo() {
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        try {
            properties.add(LayoutProperty.createProperty(this, Double.class, "Space size", null, "The size of the space to randomly distribute the nodes.", "getSize", "setSize"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public void resetPropertiesValues() {
    }

    public void setSize(Double size) {
        this.size = size;
    }

    public Double getSize() {
        return this.size;
    }
}

