/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.rotate;

import java.util.ArrayList;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;

public class RotateLayout
extends AbstractLayout
implements Layout {
    private double angle;
    private Graph graph;

    public RotateLayout(LayoutBuilder layoutBuilder, double angle) {
        super(layoutBuilder);
        this.angle = angle;
    }

    public void initAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        this.setConverged(false);
    }

    public void goAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        double sin = Math.sin(this.getAngle() * Math.PI / 180.0);
        double cos = Math.cos(this.getAngle() * Math.PI / 180.0);
        double px = 0.0;
        double py = 0.0;
        for (Node n : this.graph.getNodes()) {
            double dx = (double)n.getNodeData().x() - px;
            double dy = (double)n.getNodeData().y() - py;
            n.getNodeData().setX((float)(px + dx * cos - dy * sin));
            n.getNodeData().setY((float)(py + dy * cos + dx * sin));
        }
        this.setConverged(true);
    }

    public void endAlgo() {
    }

    public void resetPropertiesValues() {
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        try {
            properties.add(LayoutProperty.createProperty(this, Double.class, "Angle", null, "Clockwise rotation angle in degrees", "getAngle", "setAngle"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public Double getAngle() {
        return this.angle;
    }

    public void setAngle(Double angle) {
        this.angle = angle;
    }
}

