/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.scale;

import java.util.ArrayList;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;

public class ScaleLayout
extends AbstractLayout
implements Layout {
    private double scale;
    private Graph graph;

    public ScaleLayout(LayoutBuilder layoutBuilder, double scale) {
        super(layoutBuilder);
        this.scale = scale;
    }

    public void initAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        this.setConverged(false);
    }

    public void goAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        double xMean = 0.0;
        double yMean = 0.0;
        for (Node n : this.graph.getNodes()) {
            xMean += (double)n.getNodeData().x();
            yMean += (double)n.getNodeData().y();
        }
        xMean /= (double)this.graph.getNodeCount();
        yMean /= (double)this.graph.getNodeCount();
        for (Node n : this.graph.getNodes()) {
            double dx = ((double)n.getNodeData().x() - xMean) * this.getScale();
            double dy = ((double)n.getNodeData().y() - yMean) * this.getScale();
            n.getNodeData().setX((float)(xMean + dx));
            n.getNodeData().setY((float)(yMean + dy));
        }
        this.setConverged(true);
    }

    public void endAlgo() {
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        try {
            properties.add(LayoutProperty.createProperty(this, Double.class, "Scale factor", null, "Scale factor", "getScale", "setScale"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public void resetPropertiesValues() {
    }

    public Double getScale() {
        return this.scale;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }
}

