/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.partition.impl;

import java.util.ArrayList;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeEvent;
import org.gephi.data.attributes.api.AttributeListener;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeUtils;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphEvent;
import org.gephi.graph.api.GraphListener;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.partition.api.EdgePartition;
import org.gephi.partition.api.NodePartition;
import org.gephi.partition.api.Part;
import org.gephi.partition.api.Partition;
import org.gephi.partition.api.PartitionController;
import org.gephi.partition.api.PartitionModel;
import org.gephi.partition.impl.PartitionFactory;
import org.gephi.partition.impl.PartitionModelImpl;
import org.gephi.partition.spi.Transformer;
import org.gephi.partition.spi.TransformerBuilder;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.openide.util.Lookup;

public class PartitionControllerImpl
implements PartitionController,
AttributeListener {
    private PartitionModelImpl model;
    private boolean refreshPartitions = true;
    private GraphListener graphListener;

    public PartitionControllerImpl() {
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
                workspace.add(new PartitionModelImpl());
            }

            public void select(Workspace workspace) {
                PartitionControllerImpl.this.model = (PartitionModelImpl)workspace.getLookup().lookup(PartitionModelImpl.class);
                if (PartitionControllerImpl.this.model == null) {
                    PartitionControllerImpl.this.model = new PartitionModelImpl();
                    workspace.add(PartitionControllerImpl.this.model);
                }
                PartitionControllerImpl.this.refreshPartitions = true;
                GraphModel gm = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel(workspace);
                PartitionControllerImpl.this.trachViewChange(gm);
                AttributeModel attributeModel = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel(workspace);
                attributeModel.addAttributeListener(PartitionControllerImpl.this);
            }

            public void unselect(Workspace workspace) {
                GraphModel gm = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel(workspace);
                PartitionControllerImpl.this.untrackViewChange(gm);
                PartitionControllerImpl.this.model = null;
                AttributeModel attributeModel = (AttributeModel)workspace.getLookup().lookup(AttributeModel.class);
                attributeModel.removeAttributeListener(PartitionControllerImpl.this);
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                PartitionControllerImpl.this.untrackViewChange(null);
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            this.refreshPartitions = true;
            this.model = (PartitionModelImpl)pc.getCurrentWorkspace().getLookup().lookup(PartitionModelImpl.class);
            if (this.model == null) {
                this.model = new PartitionModelImpl();
                Workspace workspace = pc.getCurrentWorkspace();
                pc.getCurrentWorkspace().add(this.model);
                GraphModel gm = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel(workspace);
                this.trachViewChange(gm);
                AttributeModel attributeModel = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel(workspace);
                attributeModel.addAttributeListener(this);
            }
        }
    }

    private void trachViewChange(final GraphModel graphModel) {
        this.untrackViewChange(graphModel);
        if (this.model.getVisibleViewId() == -1) {
            this.model.setVisibleViewId(graphModel.getVisibleView().getViewId());
        }
        this.graphListener = new GraphListener(){

            public void graphChanged(GraphEvent event) {
                if (event.is(GraphEvent.EventType.VISIBLE_VIEW) && PartitionControllerImpl.this.model.getVisibleViewId() != graphModel.getVisibleView().getViewId()) {
                    PartitionControllerImpl.this.model.setVisibleViewId(graphModel.getVisibleView().getViewId());
                    PartitionControllerImpl.this.setSelectedPartition(null);
                }
            }
        };
        graphModel.addGraphListener(this.graphListener);
    }

    private void untrackViewChange(GraphModel graphModel) {
        if (this.graphListener != null && graphModel != null) {
            graphModel.removeGraphListener(this.graphListener);
        }
        this.graphListener = null;
    }

    public void attributesChanged(AttributeEvent event) {
        this.refreshPartitions = true;
    }

    public void setSelectedPartition(final Partition partition) {
        if (partition == this.model.getSelectedPartition()) {
            return;
        }
        this.model.setWaiting(true);
        if (this.model.getSelectedPartitioning() == 1) {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    if (partition != null) {
                        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
                        DynamicModel dynamicModel = PartitionControllerImpl.this.model.getDynamicModel();
                        TimeInterval timeInterval = dynamicModel != null ? dynamicModel.getVisibleInterval() : null;
                        Estimator estimator = AttributeUtils.getDefault().isDynamicNumberColumn(partition.getColumn()) ? PartitionControllerImpl.this.model.getNumberEstimator() : PartitionControllerImpl.this.model.getEstimator();
                        PartitionFactory.buildNodePartition((NodePartition)partition, graphModel.getGraphVisible(), timeInterval, estimator);
                    }
                    PartitionControllerImpl.this.model.setNodePartition(partition);
                    if (PartitionControllerImpl.this.model.getNodeTransformerBuilder() == null) {
                        TransformerBuilder[] builders = Lookup.getDefault().lookupAll(TransformerBuilder.class).toArray(new TransformerBuilder[0]);
                        for (int i = 0; i < builders.length; ++i) {
                            TransformerBuilder t = builders[i];
                            if (!(t instanceof TransformerBuilder.Node)) continue;
                            PartitionControllerImpl.this.model.setNodeBuilder(t);
                            break;
                        }
                    }
                    PartitionControllerImpl.this.model.setWaiting(false);
                }
            }, "Partition Model refresh");
            t.start();
        } else {
            Thread t = new Thread(new Runnable(){

                public void run() {
                    if (partition != null) {
                        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
                        DynamicModel dynamicModel = PartitionControllerImpl.this.model.getDynamicModel();
                        TimeInterval timeInterval = dynamicModel != null ? dynamicModel.getVisibleInterval() : null;
                        Estimator estimator = AttributeUtils.getDefault().isDynamicNumberColumn(partition.getColumn()) ? PartitionControllerImpl.this.model.getNumberEstimator() : PartitionControllerImpl.this.model.getEstimator();
                        PartitionFactory.buildEdgePartition((EdgePartition)partition, graphModel.getGraphVisible(), timeInterval, estimator);
                    }
                    PartitionControllerImpl.this.model.setEdgePartition(partition);
                    if (PartitionControllerImpl.this.model.getEdgeTransformerBuilder() == null) {
                        TransformerBuilder[] builders = Lookup.getDefault().lookupAll(TransformerBuilder.class).toArray(new TransformerBuilder[0]);
                        for (int i = 0; i < builders.length; ++i) {
                            TransformerBuilder t = builders[i];
                            if (!(t instanceof TransformerBuilder.Edge)) continue;
                            PartitionControllerImpl.this.model.setEdgeBuilder(t);
                            break;
                        }
                    }
                    PartitionControllerImpl.this.model.setWaiting(false);
                }
            }, "Partition Model refresh");
            t.start();
        }
    }

    public Partition buildPartition(AttributeColumn column, Graph graph) {
        TimeInterval timeInterval;
        DynamicModel dynamicModel = this.model.getDynamicModel();
        TimeInterval timeInterval2 = timeInterval = dynamicModel != null ? dynamicModel.getVisibleInterval() : null;
        if (AttributeUtils.getDefault().isNodeColumn(column)) {
            NodePartition partition = PartitionFactory.createNodePartition(column);
            Estimator estimator = AttributeUtils.getDefault().isDynamicNumberColumn(column) ? this.model.getNumberEstimator() : this.model.getEstimator();
            PartitionFactory.buildNodePartition(partition, graph, timeInterval, estimator);
            return partition;
        }
        EdgePartition partition = PartitionFactory.createEdgePartition(column);
        Estimator estimator = AttributeUtils.getDefault().isDynamicNumberColumn(column) ? this.model.getNumberEstimator() : this.model.getEstimator();
        PartitionFactory.buildEdgePartition(partition, graph, timeInterval, estimator);
        return partition;
    }

    public void setSelectedPartitioning(final int partitioning) {
        this.model.setWaiting(true);
        Thread t = new Thread(new Runnable(){

            public void run() {
                PartitionControllerImpl.this.model.setSelectedPartitioning(partitioning);
                PartitionControllerImpl.this.model.setWaiting(false);
            }
        }, "Partition Model refresh");
        t.start();
    }

    public void setSelectedTransformerBuilder(final TransformerBuilder builder) {
        this.model.setWaiting(true);
        Thread t = new Thread(new Runnable(){

            public void run() {
                if (PartitionControllerImpl.this.model.getSelectedPartitioning() == 1) {
                    PartitionControllerImpl.this.model.setNodeBuilder(builder);
                } else {
                    PartitionControllerImpl.this.model.setEdgeBuilder(builder);
                }
                PartitionControllerImpl.this.model.setWaiting(false);
            }
        }, "Partition Model refresh");
        t.start();
    }

    public void refreshPartitions() {
        if (this.refreshPartitions) {
            this.refreshPartitions = false;
            AttributeController ac = (AttributeController)Lookup.getDefault().lookup(AttributeController.class);
            GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
            ArrayList<NodePartition> nodePartitions = new ArrayList<NodePartition>();
            AttributeTable nodeTable = ac.getModel().getNodeTable();
            Graph graph = graphModel.getGraphVisible();
            for (AttributeColumn column : nodeTable.getColumns()) {
                Estimator estimator;
                if (PartitionFactory.isPartitionColumn(column) && PartitionFactory.isNodePartitionColumn(column, graph)) {
                    nodePartitions.add(PartitionFactory.createNodePartition(column));
                    continue;
                }
                if (!PartitionFactory.isDynamicPartitionColumn(column)) continue;
                DynamicModel dynamicModel = this.model.getDynamicModel();
                TimeInterval timeInterval = dynamicModel != null ? dynamicModel.getVisibleInterval() : null;
                Estimator estimator2 = estimator = AttributeUtils.getDefault().isDynamicNumberColumn(column) ? this.model.getNumberEstimator() : this.model.getEstimator();
                if (!PartitionFactory.isDynamicNodePartitionColumn(column, graph, timeInterval, estimator)) continue;
                nodePartitions.add(PartitionFactory.createNodePartition(column));
            }
            this.model.setNodePartitions(nodePartitions.toArray(new NodePartition[0]));
            ArrayList<EdgePartition> edgePartitions = new ArrayList<EdgePartition>();
            AttributeTable edgeClass = ac.getModel().getEdgeTable();
            for (AttributeColumn column : edgeClass.getColumns()) {
                Estimator estimator;
                if (PartitionFactory.isPartitionColumn(column) && PartitionFactory.isEdgePartitionColumn(column, graph)) {
                    edgePartitions.add(PartitionFactory.createEdgePartition(column));
                    continue;
                }
                if (!PartitionFactory.isDynamicPartitionColumn(column)) continue;
                DynamicModel dynamicModel = this.model.getDynamicModel();
                TimeInterval timeInterval = dynamicModel != null ? dynamicModel.getVisibleInterval() : null;
                Estimator estimator3 = estimator = AttributeUtils.getDefault().isDynamicNumberColumn(column) ? this.model.getNumberEstimator() : this.model.getEstimator();
                if (!PartitionFactory.isDynamicEdgePartitionColumn(column, graph, timeInterval, estimator)) continue;
                edgePartitions.add(PartitionFactory.createEdgePartition(column));
            }
            this.model.setEdgePartitions(edgePartitions.toArray(new EdgePartition[0]));
        }
    }

    public void transform(Partition partition, Transformer transformer) {
        if (transformer != null && partition != null) {
            transformer.transform(partition);
        }
    }

    public boolean isGroupable(Partition partition) {
        if (partition instanceof NodePartition && partition.getPartsCount() > 0) {
            NodePartition nodePartition = (NodePartition)partition;
            Node n0 = ((Node[])nodePartition.getParts()[0].getObjects())[0];
            GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
            HierarchicalGraph graph = graphModel.getHierarchicalGraphVisible();
            if (graph.contains(n0) && graph.getParent(n0) == null) {
                return true;
            }
        }
        return false;
    }

    public boolean isUngroupable(Partition partition) {
        if (partition instanceof NodePartition && partition.getPartsCount() > 0) {
            NodePartition nodePartition = (NodePartition)partition;
            Node n0 = ((Node[])nodePartition.getParts()[0].getObjects())[0];
            GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
            HierarchicalGraph graph = graphModel.getHierarchicalGraphVisible();
            if (graph.contains(n0) && graph.getParent(n0) != null) {
                return true;
            }
        }
        return false;
    }

    public void group(Partition partition) {
        NodePartition nodePartition = (NodePartition)partition;
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
        HierarchicalGraph graph = graphModel.getHierarchicalGraphVisible();
        for (Part p : nodePartition.getParts()) {
            Node[] nodes = (Node[])p.getObjects();
            ArrayList<Node> validNodes = new ArrayList<Node>();
            for (Node n : nodes) {
                if (!graph.contains(n)) continue;
                validNodes.add(n);
            }
            if (validNodes.isEmpty() || graph.getParent((Node)validNodes.get(0)) != null) continue;
            float centroidX = 0.0f;
            float centroidY = 0.0f;
            float sizes = 0.0f;
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            int len = 0;
            for (Node n : validNodes) {
                centroidX += n.getNodeData().x();
                centroidY += n.getNodeData().y();
                sizes += n.getNodeData().getSize();
                r += n.getNodeData().r();
                g += n.getNodeData().g();
                b += n.getNodeData().b();
                ++len;
            }
            Node metaNode = graph.groupNodes(validNodes.toArray(new Node[0]));
            metaNode.getNodeData().setX(centroidX / (float)len);
            metaNode.getNodeData().setY(centroidY / (float)len);
            metaNode.getNodeData().setLabel(p.getDisplayName());
            metaNode.getNodeData().setSize(sizes / (float)graph.getNodeCount() * 5.0f);
            metaNode.getNodeData().setColor(r / (float)len, g / (float)len, b / (float)len);
        }
    }

    public void ungroup(Partition partition) {
        NodePartition nodePartition = (NodePartition)partition;
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
        HierarchicalGraph graph = graphModel.getHierarchicalGraphVisible();
        for (Part p : nodePartition.getParts()) {
            Node metaNode;
            Node[] nodes = (Node[])p.getObjects();
            ArrayList<Node> validNodes = new ArrayList<Node>();
            for (Node n : nodes) {
                if (!graph.contains(n)) continue;
                validNodes.add(n);
            }
            if (validNodes.isEmpty() || (metaNode = graph.getParent((Node)validNodes.get(0))) == null) continue;
            graph.ungroupNodes(metaNode);
        }
    }

    public void showPie(boolean showPie) {
        this.model.setPie(showPie);
    }

    public PartitionModel getModel() {
        return this.model;
    }
}

