/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.partition.impl;

import com.google.common.collect.ArrayListMultimap;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeData;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeData;
import org.gephi.partition.api.EdgePartition;
import org.gephi.partition.api.NodePartition;
import org.gephi.partition.api.Part;
import org.gephi.partition.api.Partition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionFactory {
    public static boolean isPartitionColumn(AttributeColumn column) {
        return column.getType().equals((Object)AttributeType.STRING) || column.getType().equals((Object)AttributeType.BOOLEAN) || column.getType().equals((Object)AttributeType.INT) || column.getType().equals((Object)AttributeType.SHORT);
    }

    public static boolean isDynamicPartitionColumn(AttributeColumn column) {
        return column.getType().equals((Object)AttributeType.DYNAMIC_STRING) || column.getType().equals((Object)AttributeType.DYNAMIC_BOOLEAN) || column.getType().equals((Object)AttributeType.DYNAMIC_INT) || column.getType().equals((Object)AttributeType.DYNAMIC_SHORT);
    }

    public static boolean isNodePartitionColumn(AttributeColumn column, Graph graph) {
        HashSet<Object> values = new HashSet<Object>();
        int nonNullvalues = 0;
        for (Node n : graph.getNodes()) {
            Object value = n.getNodeData().getAttributes().getValue(column.getIndex());
            if (value != null) {
                ++nonNullvalues;
            }
            values.add(value);
        }
        return (float)values.size() < 0.9f * (float)nonNullvalues;
    }

    public static boolean isEdgePartitionColumn(AttributeColumn column, Graph graph) {
        HashSet<Object> values = new HashSet<Object>();
        int nonNullvalues = 0;
        for (Edge n : graph.getEdges()) {
            Object value = n.getEdgeData().getAttributes().getValue(column.getIndex());
            if (value != null) {
                ++nonNullvalues;
            }
            values.add(value);
        }
        return (float)values.size() < 0.9f * (float)nonNullvalues;
    }

    public static boolean isDynamicNodePartitionColumn(AttributeColumn column, Graph graph, TimeInterval timeInterval, Estimator estimator) {
        HashSet<Object> values = new HashSet<Object>();
        int nonNullvalues = 0;
        for (Node n : graph.getNodes()) {
            Object value = n.getNodeData().getAttributes().getValue(column.getIndex());
            if ((value = PartitionFactory.getDynamicValue(value, timeInterval, estimator)) != null) {
                ++nonNullvalues;
            }
            values.add(value);
        }
        return (float)values.size() < 0.9f * (float)nonNullvalues;
    }

    public static boolean isDynamicEdgePartitionColumn(AttributeColumn column, Graph graph, TimeInterval timeInterval, Estimator estimator) {
        HashSet<Object> values = new HashSet<Object>();
        int nonNullvalues = 0;
        for (Edge n : graph.getEdges()) {
            Object value = n.getEdgeData().getAttributes().getValue(column.getIndex());
            if ((value = PartitionFactory.getDynamicValue(value, timeInterval, estimator)) != null) {
                ++nonNullvalues;
            }
            values.add(value);
        }
        return (float)values.size() < 0.9f * (float)nonNullvalues;
    }

    private static Object getDynamicValue(Object object, TimeInterval timeInterval, Estimator estimator) {
        if (object != null && object instanceof DynamicType) {
            DynamicType dynamicType = (DynamicType)object;
            return dynamicType.getValue(timeInterval == null ? Double.NEGATIVE_INFINITY : timeInterval.getLow(), timeInterval == null ? Double.POSITIVE_INFINITY : timeInterval.getHigh(), estimator);
        }
        return object;
    }

    public static NodePartition createNodePartition(AttributeColumn column) {
        return new NodePartitionImpl(column);
    }

    public static EdgePartition createEdgePartition(AttributeColumn column) {
        return new EdgePartitionImpl(column);
    }

    public static boolean isPartitionBuilt(Partition partition) {
        return partition.getParts().length > 0;
    }

    public static void buildNodePartition(NodePartition partition, Graph graph) {
        PartitionFactory.buildNodePartition(partition, graph, null, null);
    }

    public static void buildNodePartition(NodePartition partition, Graph graph, TimeInterval timeInterval, Estimator estimator) {
        NodePartitionImpl partitionImpl = (NodePartitionImpl)partition;
        ArrayListMultimap multimap = ArrayListMultimap.create();
        for (Node n : graph.getNodes()) {
            Object value = n.getNodeData().getAttributes().getValue(partitionImpl.column.getIndex());
            value = PartitionFactory.getDynamicValue(value, timeInterval, estimator);
            multimap.put(value, (Object)n);
        }
        PartImpl[] parts = new PartImpl[multimap.keySet().size()];
        Map map = multimap.asMap();
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            PartImpl<Node> part;
            parts[i] = part = new PartImpl<Node>(partition, entry.getKey(), ((Collection)entry.getValue()).toArray(new Node[0]));
            ++i;
        }
        partitionImpl.setParts(parts);
    }

    public static void buildEdgePartition(EdgePartition partition, Graph graph) {
        PartitionFactory.buildEdgePartition(partition, graph, null, null);
    }

    public static void buildEdgePartition(EdgePartition partition, Graph graph, TimeInterval timeInterval, Estimator estimator) {
        EdgePartitionImpl partitionImpl = (EdgePartitionImpl)partition;
        ArrayListMultimap multimap = ArrayListMultimap.create();
        for (Edge n : graph.getEdges()) {
            Object value = n.getEdgeData().getAttributes().getValue(partitionImpl.column.getIndex());
            value = PartitionFactory.getDynamicValue(value, timeInterval, estimator);
            multimap.put(value, (Object)n);
        }
        PartImpl[] parts = new PartImpl[multimap.keySet().size()];
        Map map = multimap.asMap();
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            PartImpl<Edge> part;
            parts[i] = part = new PartImpl<Edge>(partition, entry.getKey(), ((Collection)entry.getValue()).toArray(new Edge[0]));
            ++i;
        }
        partitionImpl.setParts(parts);
    }

    public static List<Color> getSequenceColors(int num) {
        LinkedList<Color> colors = new LinkedList<Color>();
        Random random = new Random();
        float B = random.nextFloat() * 2.0f / 5.0f + 0.6f;
        float S = random.nextFloat() * 2.0f / 5.0f + 0.6f;
        for (int i = 1; i <= num; ++i) {
            float H = (float)i / (float)num;
            Color c = Color.getHSBColor(H, S, B);
            colors.add(c);
        }
        Collections.shuffle(colors);
        return colors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PartImpl<Element>
    implements Part<Element> {
        private static final String NULL = "null";
        private Partition<Element> partition;
        private Element[] objects;
        private Object value;
        private Color color;

        public PartImpl(Partition<Element> partition, Object value, Element[] objects) {
            this.partition = partition;
            this.value = value;
            this.objects = objects;
        }

        @Override
        public Element[] getObjects() {
            return this.objects;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public String getDisplayName() {
            return this.value != null ? this.value.toString() : NULL;
        }

        @Override
        public boolean isInPart(Element element) {
            return this.partition.getPart(element) == this;
        }

        @Override
        public void setColor(Color color) {
            this.color = color;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        @Override
        public float getPercentage() {
            return (float)this.objects.length / (float)this.partition.getElementsCount();
        }

        @Override
        public Partition getPartition() {
            return this.partition;
        }

        public String toString() {
            return this.getDisplayName();
        }

        public int compareTo(Object o) {
            int thisCount = this.objects.length;
            int theirCount = ((PartImpl)o).objects.length;
            return thisCount == theirCount ? 0 : (thisCount > theirCount ? 1 : -1);
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof PartImpl) {
                if (this.value == null && ((PartImpl)obj).value == null) {
                    return true;
                }
                if (((PartImpl)obj).value != null && this.value != null) {
                    return ((PartImpl)obj).value.equals(this.value);
                }
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 53 * hash + (this.value != null ? this.value.hashCode() : 0);
            return hash;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EdgePartitionImpl
    implements EdgePartition {
        private HashMap<EdgeData, Part<Edge>> edgeMap;
        private PartImpl<Edge>[] parts;
        private HashMap<Object, Part<Edge>> valueMap;
        private AttributeColumn column;

        public EdgePartitionImpl(AttributeColumn column) {
            this.column = column;
            this.edgeMap = new HashMap();
            this.valueMap = new HashMap();
            this.parts = new PartImpl[0];
        }

        @Override
        public int getPartsCount() {
            return this.parts.length;
        }

        @Override
        public Part<Edge>[] getParts() {
            return this.parts;
        }

        @Override
        public Part<Edge> getPartFromValue(Object value) {
            return this.valueMap.get(value);
        }

        public Map<EdgeData, Part<Edge>> getMap() {
            return this.edgeMap;
        }

        @Override
        public Part<Edge> getPart(Edge element) {
            return this.edgeMap.get(element.getEdgeData());
        }

        public void setParts(PartImpl<Edge>[] parts) {
            this.parts = parts;
            List<Color> colors = PartitionFactory.getSequenceColors(parts.length);
            int i = 0;
            for (PartImpl<Edge> p : parts) {
                for (Edge e : (Edge[])((PartImpl)p).objects) {
                    this.edgeMap.put(e.getEdgeData(), p);
                }
                p.setColor(colors.get(i));
                this.valueMap.put(p.getValue(), p);
                ++i;
            }
        }

        @Override
        public AttributeColumn getColumn() {
            return this.column;
        }

        @Override
        public String toString() {
            return this.column.getTitle();
        }

        @Override
        public int getElementsCount() {
            return this.edgeMap.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodePartitionImpl
    implements NodePartition {
        private HashMap<NodeData, Part<Node>> nodeMap;
        private HashMap<Object, Part<Node>> valueMap;
        private PartImpl<Node>[] parts;
        private AttributeColumn column;

        public NodePartitionImpl(AttributeColumn column) {
            this.column = column;
            this.nodeMap = new HashMap();
            this.valueMap = new HashMap();
            this.parts = new PartImpl[0];
        }

        @Override
        public int getPartsCount() {
            return this.parts.length;
        }

        @Override
        public Part<Node> getPartFromValue(Object value) {
            return this.valueMap.get(value);
        }

        @Override
        public Part<Node>[] getParts() {
            return this.parts;
        }

        public Map<NodeData, Part<Node>> getMap() {
            return this.nodeMap;
        }

        @Override
        public Part<Node> getPart(Node element) {
            return this.nodeMap.get(element.getNodeData());
        }

        public void setParts(PartImpl<Node>[] parts) {
            this.parts = parts;
            List<Color> colors = PartitionFactory.getSequenceColors(parts.length);
            int i = 0;
            for (PartImpl<Node> p : parts) {
                for (Node n : (Node[])((PartImpl)p).objects) {
                    this.nodeMap.put(n.getNodeData(), p);
                }
                p.setColor(colors.get(i));
                this.valueMap.put(p.getValue(), p);
                ++i;
            }
        }

        @Override
        public AttributeColumn getColumn() {
            return this.column;
        }

        @Override
        public String toString() {
            return this.column.getTitle();
        }

        @Override
        public int getElementsCount() {
            return this.nodeMap.size();
        }
    }
}

