/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.partition.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.dynamic.api.DynamicController;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.partition.api.EdgePartition;
import org.gephi.partition.api.NodePartition;
import org.gephi.partition.api.Partition;
import org.gephi.partition.api.PartitionModel;
import org.gephi.partition.spi.Transformer;
import org.gephi.partition.spi.TransformerBuilder;
import org.openide.util.Lookup;

public class PartitionModelImpl
implements PartitionModel {
    private final List<PropertyChangeListener> listeners;
    private int selectedPartitioning = 1;
    private Partition nodePartition;
    private Partition edgePartition;
    private TransformerBuilder nodeBuilder;
    private TransformerBuilder edgeBuilder;
    private final HashMap<Class, Transformer> transformersMap;
    private NodePartition[] nodePartitions = new NodePartition[0];
    private EdgePartition[] edgePartitions = new EdgePartition[0];
    private boolean waiting;
    private boolean pie;
    private int visibleViewId = -1;
    private DynamicModel dynamicModel;

    public PartitionModelImpl() {
        this.listeners = new ArrayList<PropertyChangeListener>();
        this.transformersMap = new HashMap();
    }

    public NodePartition[] getNodePartitions() {
        return this.nodePartitions;
    }

    public EdgePartition[] getEdgePartitions() {
        return this.edgePartitions;
    }

    public TransformerBuilder getNodeTransformerBuilder() {
        return this.nodeBuilder;
    }

    public Transformer getNodeTransformer() {
        if (this.nodeBuilder == null) {
            return null;
        }
        if (this.transformersMap.get(this.nodeBuilder.getClass()) != null) {
            return this.transformersMap.get(this.nodeBuilder.getClass());
        }
        Transformer t = this.nodeBuilder.getTransformer();
        this.transformersMap.put(this.nodeBuilder.getClass(), t);
        return t;
    }

    public TransformerBuilder getEdgeTransformerBuilder() {
        return this.edgeBuilder;
    }

    public Transformer getEdgeTransformer() {
        if (this.edgeBuilder == null) {
            return null;
        }
        if (this.transformersMap.get(this.edgeBuilder.getClass()) != null) {
            return this.transformersMap.get(this.edgeBuilder.getClass());
        }
        Transformer t = this.edgeBuilder.getTransformer();
        this.transformersMap.put(this.edgeBuilder.getClass(), t);
        return t;
    }

    public Partition getSelectedPartition() {
        if (this.selectedPartitioning == 1) {
            return this.nodePartition;
        }
        if (this.selectedPartitioning == 2) {
            return this.edgePartition;
        }
        return null;
    }

    public int getSelectedPartitioning() {
        return this.selectedPartitioning;
    }

    public Transformer getSelectedTransformer() {
        if (this.selectedPartitioning == 1) {
            return this.getNodeTransformer();
        }
        if (this.selectedPartitioning == 2) {
            return this.getEdgeTransformer();
        }
        return null;
    }

    public TransformerBuilder getSelectedTransformerBuilder() {
        if (this.selectedPartitioning == 1) {
            return this.nodeBuilder;
        }
        if (this.selectedPartitioning == 2) {
            return this.edgeBuilder;
        }
        return null;
    }

    public DynamicModel getDynamicModel() {
        DynamicController dynamicController;
        if (this.dynamicModel == null && (dynamicController = (DynamicController)Lookup.getDefault().lookup(DynamicController.class)) != null) {
            this.dynamicModel = dynamicController.getModel();
        }
        return this.dynamicModel;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public boolean isPie() {
        return this.pie;
    }

    public int getVisibleViewId() {
        return this.visibleViewId;
    }

    public Estimator getEstimator() {
        return this.dynamicModel.getEstimator();
    }

    public Estimator getNumberEstimator() {
        return this.dynamicModel.getNumberEstimator();
    }

    public void addPropertyChangeListener(PropertyChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.add(changeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void firePropertyChangeEvent(String key, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, key, oldValue, newValue);
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(evt);
        }
    }

    public void setNodeBuilder(TransformerBuilder nodeBuilder) {
        if (nodeBuilder != this.nodeBuilder) {
            TransformerBuilder oldValue = this.nodeBuilder;
            this.nodeBuilder = nodeBuilder;
            this.firePropertyChangeEvent("nodeBuilder", oldValue, nodeBuilder);
        }
    }

    public void setEdgeBuilder(TransformerBuilder edgeBuilder) {
        if (edgeBuilder != this.edgeBuilder) {
            TransformerBuilder oldValue = this.edgeBuilder;
            this.edgeBuilder = edgeBuilder;
            this.firePropertyChangeEvent("edgeBuilder", oldValue, edgeBuilder);
        }
    }

    public void setSelectedPartitioning(int selectedPartitioning) {
        if (selectedPartitioning != this.selectedPartitioning) {
            int oldValue = this.selectedPartitioning;
            this.selectedPartitioning = selectedPartitioning;
            this.firePropertyChangeEvent("selectedPartitioning", oldValue, selectedPartitioning);
        }
    }

    public void setNodePartition(Partition nodePartition) {
        if (nodePartition != this.nodePartition) {
            Partition oldValue = this.nodePartition;
            this.nodePartition = nodePartition;
            this.firePropertyChangeEvent("nodePartition", oldValue, nodePartition);
        }
    }

    public void setEdgePartition(Partition edgePartition) {
        if (edgePartition != this.edgePartition) {
            Partition oldValue = this.edgePartition;
            this.edgePartition = edgePartition;
            this.firePropertyChangeEvent("edgePartition", oldValue, edgePartition);
        }
    }

    public void setNodePartitions(NodePartition[] nodePartitions) {
        if (nodePartitions != this.nodePartitions) {
            NodePartition[] oldValue = this.nodePartitions;
            this.nodePartitions = nodePartitions;
            this.firePropertyChangeEvent("nodePartitions", oldValue, nodePartitions);
        }
    }

    public void setEdgePartitions(EdgePartition[] edgePartitions) {
        if (edgePartitions != this.edgePartitions) {
            EdgePartition[] oldValue = this.edgePartitions;
            this.edgePartitions = edgePartitions;
            this.firePropertyChangeEvent("edgePartitions", oldValue, edgePartitions);
        }
    }

    public void setWaiting(boolean waiting) {
        if (waiting != this.waiting) {
            boolean oldValue = this.waiting;
            this.waiting = waiting;
            this.firePropertyChangeEvent("waiting", oldValue, waiting);
        }
    }

    public void setPie(boolean pie) {
        if (pie != this.pie) {
            boolean oldValue = this.pie;
            this.pie = pie;
            this.firePropertyChangeEvent("pie", oldValue, pie);
        }
    }

    public void setVisibleViewId(int visibleViewId) {
        this.visibleViewId = visibleViewId;
    }
}

