/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.partition.plugin;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gephi.graph.api.Node;
import org.gephi.partition.api.NodePartition;
import org.gephi.partition.api.Part;
import org.gephi.partition.api.Partition;
import org.gephi.partition.spi.Transformer;
import org.gephi.utils.PaletteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeColorTransformer
implements Transformer {
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private Map<Object, Color> map = new HashMap<Object, Color>();

    public Map<Object, Color> getMap() {
        return this.map;
    }

    public void randomizeColors(Partition partition) {
        List<Color> colors = PaletteUtils.getSequenceColors(partition.getPartsCount());
        int i = 0;
        for (Part p : partition.getParts()) {
            this.getMap().put(p.getValue(), colors.get(i));
            ++i;
        }
    }

    @Override
    public void transform(Partition partition) {
        NodePartition nodePartition = (NodePartition)partition;
        for (Part part : nodePartition.getParts()) {
            Color color = this.map.get(part.getValue());
            if (color == null) {
                color = DEFAULT_COLOR;
            }
            part.setColor(color);
            float r = (float)color.getRed() / 255.0f;
            float g = (float)color.getGreen() / 255.0f;
            float b = (float)color.getBlue() / 255.0f;
            for (Node node : (Node[])part.getObjects()) {
                node.getNodeData().setColor(r, g, b);
            }
        }
    }
}

