/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import org.gephi.preview.PointImpl;
import org.gephi.preview.api.Color;
import org.gephi.preview.api.EdgeChildColorizerClient;
import org.gephi.preview.api.Point;
import org.gephi.preview.updaters.LabelShortenerClient;
import org.gephi.preview.util.HolderImpl;
import org.gephi.preview.util.Vector;

public abstract class AbstractEdgeLabel
implements LabelShortenerClient,
EdgeChildColorizerClient {
    protected final String originalValue;
    private final HolderImpl<Color> colorHolder = new HolderImpl();
    protected String value;
    protected PointImpl position;

    public AbstractEdgeLabel(String value) {
        this.originalValue = value;
    }

    public Point getPosition() {
        return this.position;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public String getValue() {
        return this.value;
    }

    public Color getColor() {
        return this.colorHolder.getComponent();
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setColor(Color color) {
        this.colorHolder.setComponent(color);
    }

    public void revertOriginalValue() {
        this.setValue(this.originalValue);
    }

    protected void putPositionAboveEdge(Vector edgeDirection, float edgeThickness) {
        Vector n = new Vector(edgeDirection.y, -edgeDirection.x);
        n.mult(edgeThickness / 2.0f);
        Vector positionVector = new Vector(this.position);
        positionVector.add(n);
        this.position = new PointImpl(positionVector);
    }
}

