/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gephi.preview.api.Colorizer;
import org.gephi.preview.api.ColorizerFactory;
import org.gephi.preview.updaters.CustomColorMode;
import org.gephi.preview.updaters.EdgeB1ColorMode;
import org.gephi.preview.updaters.EdgeB2ColorMode;
import org.gephi.preview.updaters.EdgeBothBColorMode;
import org.gephi.preview.updaters.EdgeOriginalColorMode;
import org.gephi.preview.updaters.NodeOriginalColorMode;
import org.gephi.preview.updaters.ParentColorMode;

public class ColorizerFactoryImpl
implements ColorizerFactory {
    private boolean matchColorMode(String s, String identifier) {
        String regexp = String.format("\\s*%s\\s*", identifier);
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher(s);
        return m.lookingAt();
    }

    public boolean matchCustomColorMode(String s) {
        return this.matchColorMode(s, CustomColorMode.getIdentifier());
    }

    public boolean matchNodeOriginalColorMode(String s) {
        return this.matchColorMode(s, NodeOriginalColorMode.getIdentifier());
    }

    public boolean matchParentColorMode(String s) {
        return this.matchColorMode(s, ParentColorMode.getIdentifier());
    }

    public boolean matchEdgeB1ColorMode(String s) {
        return this.matchColorMode(s, EdgeB1ColorMode.getIdentifier());
    }

    public boolean matchEdgeB2ColorMode(String s) {
        return this.matchColorMode(s, EdgeB2ColorMode.getIdentifier());
    }

    public boolean matchEdgeBothBColorMode(String s) {
        return this.matchColorMode(s, EdgeBothBColorMode.getIdentifier());
    }

    public boolean matchEdgeOriginalColorMode(String s) {
        return this.matchColorMode(s, EdgeOriginalColorMode.getIdentifier());
    }

    public boolean isCustomColorMode(Colorizer colorizer) {
        return this.matchCustomColorMode(((Object)colorizer).toString());
    }

    public boolean isNodeOriginalColorMode(Colorizer colorizer) {
        return this.matchNodeOriginalColorMode(((Object)colorizer).toString());
    }

    public boolean isParentColorMode(Colorizer colorizer) {
        return this.matchParentColorMode(((Object)colorizer).toString());
    }

    public boolean isEdgeB1ColorMode(Colorizer colorizer) {
        return this.matchEdgeB1ColorMode(((Object)colorizer).toString());
    }

    public boolean isEdgeB2ColorMode(Colorizer colorizer) {
        return this.matchEdgeB2ColorMode(((Object)colorizer).toString());
    }

    public boolean isEdgeBothBColorMode(Colorizer colorizer) {
        return this.matchEdgeBothBColorMode(((Object)colorizer).toString());
    }

    public boolean isEdgeOriginalColorMode(Colorizer colorizer) {
        return this.matchEdgeOriginalColorMode(((Object)colorizer).toString());
    }

    public Colorizer createCustomColorMode(int r, int g, int b) {
        return new CustomColorMode(r, g, b);
    }

    public Colorizer createCustomColorMode(Color color) {
        return this.createCustomColorMode(color.getRed(), color.getGreen(), color.getBlue());
    }

    public Colorizer createNodeOriginalColorMode() {
        return new NodeOriginalColorMode();
    }

    public Colorizer createParentColorMode() {
        return new ParentColorMode();
    }

    public Colorizer createEdgeB1ColorMode() {
        return new EdgeB1ColorMode();
    }

    public Colorizer createEdgeB2ColorMode() {
        return new EdgeB2ColorMode();
    }

    public Colorizer createEdgeBothBColorMode() {
        return new EdgeBothBColorMode();
    }

    public Colorizer createEdgeOriginalColorMode() {
        return new EdgeOriginalColorMode();
    }
}

