/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.awt.Font;
import java.util.ArrayList;
import org.gephi.graph.api.Edge;
import org.gephi.preview.EdgeArrowB1Out;
import org.gephi.preview.EdgeArrowB2In;
import org.gephi.preview.EdgeImpl;
import org.gephi.preview.EdgeMiniLabelB1;
import org.gephi.preview.EdgeMiniLabelB2;
import org.gephi.preview.GraphImpl;
import org.gephi.preview.NodeImpl;
import org.gephi.preview.api.DirectedEdge;
import org.gephi.preview.api.EdgeArrow;
import org.gephi.preview.api.EdgeMiniLabel;
import org.gephi.preview.supervisors.DirectedEdgeSupervisorImpl;
import org.gephi.preview.supervisors.EdgeSupervisorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectedEdgeImpl
extends EdgeImpl
implements DirectedEdge {
    protected final ArrayList<EdgeArrow> arrows = new ArrayList();
    protected final ArrayList<EdgeMiniLabel> miniLabels = new ArrayList();

    protected DirectedEdgeImpl(GraphImpl parent, Edge edge, float thickness, NodeImpl node1, NodeImpl node2, String label, float labelSize) {
        super(parent, edge, thickness, node1, node2, label, labelSize);
        this.arrows.add(new EdgeArrowB1Out(this));
        this.arrows.add(new EdgeArrowB2In(this));
        if (node2.hasLabel()) {
            this.miniLabels.add(new EdgeMiniLabelB1(this));
        }
        if (node1.hasLabel()) {
            this.miniLabels.add(new EdgeMiniLabelB2(this));
        }
    }

    public abstract DirectedEdgeSupervisorImpl getDirectedEdgeSupervisor();

    @Override
    public Iterable<EdgeArrow> getArrows() {
        return this.arrows;
    }

    @Override
    public Iterable<EdgeMiniLabel> getMiniLabels() {
        return this.miniLabels;
    }

    public Font getMiniLabelFont() {
        return this.getDirectedEdgeSupervisor().getMiniLabelFont();
    }

    @Override
    public Boolean showArrows() {
        DirectedEdgeSupervisorImpl supervisor = this.getDirectedEdgeSupervisor();
        float minlength = this.node1.getRadius().floatValue() + this.node2.getRadius().floatValue() + 2.0f * supervisor.getArrowAddedRadius().floatValue() + 2.0f * supervisor.getArrowSize().floatValue() + 30.0f;
        return supervisor.getShowArrowsFlag() != false && this.length >= minlength;
    }

    @Override
    public Boolean showMiniLabels() {
        DirectedEdgeSupervisorImpl supervisor = this.getDirectedEdgeSupervisor();
        int labelSize = supervisor.getShortenMiniLabelsFlag() != false ? supervisor.getMiniLabelMaxChar() : 10;
        float minlength = this.node1.getRadius().floatValue() + this.node2.getRadius().floatValue() + 1.3f * (float)labelSize * (float)supervisor.getMiniLabelFont().getSize() + 30.0f;
        return supervisor.getShowMiniLabelsFlag() != false && this.length >= minlength;
    }

    @Override
    protected EdgeSupervisorImpl getEdgeSupervisor() {
        return this.getDirectedEdgeSupervisor();
    }
}

