/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import org.gephi.preview.DirectedEdgeImpl;
import org.gephi.preview.NodeImpl;
import org.gephi.preview.PointImpl;
import org.gephi.preview.api.Color;
import org.gephi.preview.api.EdgeArrow;
import org.gephi.preview.api.EdgeChildColorizerClient;
import org.gephi.preview.api.EdgeColorizerClient;
import org.gephi.preview.api.Point;
import org.gephi.preview.api.supervisors.DirectedEdgeSupervisor;
import org.gephi.preview.api.util.Holder;
import org.gephi.preview.util.HolderImpl;
import org.gephi.preview.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EdgeArrowImpl
implements EdgeArrow,
EdgeChildColorizerClient {
    protected final DirectedEdgeImpl parent;
    private final HolderImpl<Color> colorHolder = new HolderImpl();
    protected PointImpl pt1;
    protected PointImpl pt2;
    protected PointImpl pt3;
    protected NodeImpl refNode;
    protected Vector direction;
    protected float addedRadius;
    protected static final float BASE_RATIO = 0.5f;

    public EdgeArrowImpl(DirectedEdgeImpl parent) {
        this.parent = parent;
    }

    public DirectedEdgeSupervisor getDirectedEdgeSupervisor() {
        return this.parent.getDirectedEdgeSupervisor();
    }

    public void genPosition() {
        this.genAddedRadius();
        this.genPt1();
        this.genPt2();
        this.genPt3();
    }

    @Override
    public final Point getPt1() {
        return this.pt1;
    }

    @Override
    public final Point getPt2() {
        return this.pt2;
    }

    @Override
    public final Point getPt3() {
        return this.pt3;
    }

    @Override
    public Color getColor() {
        return this.colorHolder.getComponent();
    }

    @Override
    public EdgeColorizerClient getParentEdge() {
        return this.parent;
    }

    @Override
    public Holder<Color> getParentColorHolder() {
        return this.parent.getColorHolder();
    }

    @Override
    public void setColor(Color color) {
        this.colorHolder.setComponent(color);
    }

    protected abstract void genAddedRadius();

    protected void genPt1() {
        Vector v = new Vector(this.direction);
        v.mult(this.addedRadius);
        v.add(new Vector(this.refNode.getPosition()));
        this.pt1 = new PointImpl(v);
    }

    protected void genPt2() {
        Vector v = new Vector(this.direction);
        v.mult(this.getDirectedEdgeSupervisor().getArrowSize().floatValue());
        v.add(new Vector(this.pt1));
        this.pt2 = new PointImpl(v);
    }

    protected void genPt3() {
        Vector v = new Vector(-this.direction.y, this.direction.x);
        v.mult(0.5f * this.getDirectedEdgeSupervisor().getArrowSize().floatValue());
        v.add(new Vector(this.pt1));
        this.pt3 = new PointImpl(v);
    }
}

