/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import org.gephi.graph.api.MetaEdge;
import org.gephi.preview.AbstractEdge;
import org.gephi.preview.CubicBezierCurveImpl;
import org.gephi.preview.EdgeLabelImpl;
import org.gephi.preview.GraphImpl;
import org.gephi.preview.NodeImpl;
import org.gephi.preview.PointImpl;
import org.gephi.preview.api.CubicBezierCurve;
import org.gephi.preview.api.Edge;
import org.gephi.preview.api.Point;
import org.gephi.preview.supervisors.EdgeSupervisorImpl;
import org.gephi.preview.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EdgeImpl
extends AbstractEdge
implements Edge {
    protected final NodeImpl node1;
    protected final NodeImpl node2;
    protected final Vector direction;
    protected final float length;
    protected final ArrayList<CubicBezierCurve> curves = new ArrayList();
    private final EdgeLabelImpl label;
    protected static final float BEZIER_CURVE_FACTOR = 0.2f;
    protected final Color originalColor;
    protected Boolean metaEdge;

    protected EdgeImpl(GraphImpl parent, org.gephi.graph.api.Edge edge, float thickness, NodeImpl node1, NodeImpl node2, String label, float labelSize) {
        super(parent, thickness);
        this.node1 = node1;
        this.node2 = node2;
        this.metaEdge = edge instanceof MetaEdge;
        this.direction = new Vector(this.node2.getPosition());
        this.direction.sub(new Vector(this.node1.getPosition()));
        this.length = this.direction.mag();
        this.direction.normalize();
        this.originalColor = edge.getEdgeData().r() != -1.0f ? new Color(edge.getEdgeData().r(), edge.getEdgeData().g(), edge.getEdgeData().b(), edge.getEdgeData().alpha()) : null;
        this.genCurves();
        this.label = null != label ? new EdgeLabelImpl(this, label, labelSize) : null;
    }

    protected void genCurves() {
        float factor = 0.2f * this.length;
        Vector n = new Vector(this.direction.y, -this.direction.x);
        n.mult(factor);
        Vector v1 = new Vector(this.direction);
        v1.mult(factor);
        v1.add(new Vector(this.node1.getPosition()));
        v1.add(n);
        Vector v2 = new Vector(this.direction);
        v2.mult(-factor);
        v2.add(new Vector(this.node2.getPosition()));
        v2.add(n);
        this.curves.add(new CubicBezierCurveImpl(this.node1.getPosition(), new PointImpl(v1), new PointImpl(v2), this.node2.getPosition()));
    }

    @Override
    public boolean hasLabel() {
        return null != this.label;
    }

    @Override
    public Iterable<CubicBezierCurve> getCurves() {
        return this.curves;
    }

    @Override
    public NodeImpl getNode1() {
        return this.node1;
    }

    @Override
    public NodeImpl getNode2() {
        return this.node2;
    }

    @Override
    public Color getOriginalColor() {
        return this.originalColor;
    }

    @Override
    public EdgeLabelImpl getLabel() {
        return this.label;
    }

    @Override
    public Float getScale() {
        return this.getEdgeSupervisor().getEdgeScale();
    }

    public Font getBaseLabelFont() {
        return this.getEdgeSupervisor().getBaseLabelFont();
    }

    public Vector getDirection() {
        return this.direction;
    }

    public Boolean getMetaEdge() {
        return this.metaEdge;
    }

    public void setMetaEdge(Boolean metaEdge) {
        this.metaEdge = metaEdge;
    }

    public Float getLength() {
        return Float.valueOf(this.length);
    }

    public Float getAngle() {
        Point p1 = this.node1.getPosition();
        Point p2 = this.node2.getPosition();
        return Float.valueOf((float)Math.atan2(p2.getY().floatValue() - p1.getY().floatValue(), p2.getX().floatValue() - p1.getX().floatValue()));
    }

    @Override
    public Boolean isCurved() {
        return this.getEdgeSupervisor().getCurvedFlag();
    }

    @Override
    public Boolean showLabel() {
        if (!this.hasLabel() || this.getLabel().getFont() == null) {
            return false;
        }
        EdgeSupervisorImpl supervisor = this.getEdgeSupervisor();
        int labelCharCount = supervisor.getShortenLabelsFlag() != false ? supervisor.getLabelMaxChar() : 10;
        float minlength = this.node1.getRadius().floatValue() + this.node2.getRadius().floatValue() + 0.65f * (float)labelCharCount * (float)this.label.getFont().getSize();
        return supervisor.getShowLabelsFlag() != false && this.length >= minlength;
    }

    protected abstract EdgeSupervisorImpl getEdgeSupervisor();
}

