/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.awt.Font;
import org.gephi.preview.AbstractEdgeLabel;
import org.gephi.preview.EdgeImpl;
import org.gephi.preview.PointImpl;
import org.gephi.preview.api.Color;
import org.gephi.preview.api.EdgeColorizerClient;
import org.gephi.preview.api.EdgeLabel;
import org.gephi.preview.api.util.Holder;
import org.gephi.preview.updaters.LabelFontAdjusterClient;
import org.gephi.preview.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeLabelImpl
extends AbstractEdgeLabel
implements EdgeLabel,
LabelFontAdjusterClient {
    private final EdgeImpl parent;
    private final float labelSizeFactor;
    private Font font;

    public EdgeLabelImpl(EdgeImpl parent, String value, float labelSize) {
        super(value);
        this.parent = parent;
        this.labelSizeFactor = labelSize;
        this.genPosition();
    }

    public void genPosition() {
        Vector positionVector = new Vector(this.parent.getNode1().getPosition());
        Vector semiLength = new Vector(this.parent.getDirection());
        semiLength.mult(this.parent.getLength().floatValue() / 2.0f);
        positionVector.add(semiLength);
        this.position = new PointImpl(positionVector);
        this.putPositionAboveEdge(this.parent.getDirection(), this.parent.getThickness().floatValue());
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public Font getBaseFont() {
        return this.parent.getBaseLabelFont();
    }

    @Override
    public float getSizeFactor() {
        return this.labelSizeFactor;
    }

    @Override
    public Float getAngle() {
        return this.parent.getAngle();
    }

    @Override
    public EdgeColorizerClient getParentEdge() {
        return this.parent;
    }

    @Override
    public Holder<Color> getParentColorHolder() {
        return this.parent.getColorHolder();
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }
}

