/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.util.ArrayList;
import org.gephi.preview.NodeImpl;
import org.gephi.preview.api.BidirectionalEdge;
import org.gephi.preview.api.Graph;
import org.gephi.preview.api.Node;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.SelfLoop;
import org.gephi.preview.api.UndirectedEdge;
import org.gephi.preview.api.UnidirectionalEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphImpl
implements Graph {
    public static final float WEIGHT_MINIMUM = 0.4f;
    public static final float WEIGHT_MAXIMUM = 8.0f;
    private final PreviewModel model;
    private final ArrayList<Node> nodes = new ArrayList();
    private final ArrayList<SelfLoop> selfLoops = new ArrayList();
    private final ArrayList<UnidirectionalEdge> uniEdges = new ArrayList();
    private final ArrayList<BidirectionalEdge> biEdges = new ArrayList();
    private final ArrayList<UndirectedEdge> undirectedEdges = new ArrayList();
    private float minWeight;
    private float maxWeight;
    private float minMetaWeight;
    private float maxMetaWeight;

    public GraphImpl(PreviewModel model) {
        this.model = model;
    }

    @Override
    public Iterable<Node> getNodes() {
        return this.nodes;
    }

    @Override
    public Iterable<SelfLoop> getSelfLoops() {
        return this.selfLoops;
    }

    @Override
    public Iterable<UnidirectionalEdge> getUnidirectionalEdges() {
        return this.uniEdges;
    }

    @Override
    public Iterable<BidirectionalEdge> getBidirectionalEdges() {
        return this.biEdges;
    }

    @Override
    public Iterable<UndirectedEdge> getUndirectedEdges() {
        return this.undirectedEdges;
    }

    @Override
    public int countNodes() {
        return this.nodes.size();
    }

    @Override
    public int countSelfLoops() {
        return this.selfLoops.size();
    }

    @Override
    public int countUnidirectionalEdges() {
        return this.uniEdges.size();
    }

    @Override
    public int countBidirectionalEdges() {
        return this.biEdges.size();
    }

    @Override
    public int countUndirectedEdges() {
        return this.undirectedEdges.size();
    }

    public void addNode(NodeImpl node) {
        this.nodes.add(node);
    }

    public void addSelfLoop(SelfLoop selfLoop) {
        this.selfLoops.add(selfLoop);
    }

    public void addUnidirectionalEdge(UnidirectionalEdge edge) {
        this.uniEdges.add(edge);
    }

    public void addBidirectionalEdge(BidirectionalEdge edge) {
        this.biEdges.add(edge);
    }

    public void addUndirectedEdge(UndirectedEdge edge) {
        this.undirectedEdges.add(edge);
    }

    @Override
    public Boolean showNodes() {
        return this.model.getNodeSupervisor().getShowNodes();
    }

    @Override
    public Boolean showEdges() {
        return this.model.getGlobalEdgeSupervisor().getShowFlag();
    }

    @Override
    public Boolean showSelfLoops() {
        return this.model.getSelfLoopSupervisor().getShowFlag();
    }

    public PreviewModel getModel() {
        return this.model;
    }

    public float getMaxWeight() {
        return this.maxWeight;
    }

    public void setMaxWeight(float maxWeight) {
        this.maxWeight = maxWeight;
    }

    public float getMinWeight() {
        return this.minWeight;
    }

    public void setMinWeight(float minWeight) {
        this.minWeight = minWeight;
    }

    public float getMinMetaWeight() {
        return this.minMetaWeight;
    }

    public void setMinMetaWeight(float minMetaWeight) {
        this.minMetaWeight = minMetaWeight;
    }

    public float getMaxMetaWeight() {
        return this.maxMetaWeight;
    }

    public void setMaxMetaWeight(float maxMetaWeight) {
        this.maxMetaWeight = maxMetaWeight;
    }
}

