/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.util.Iterator;
import org.gephi.preview.PointImpl;
import org.gephi.preview.api.Graph;
import org.gephi.preview.api.GraphSheet;
import org.gephi.preview.api.Node;
import org.gephi.preview.api.Point;
import org.gephi.preview.util.Vector;

public class GraphSheetImpl
implements GraphSheet {
    private final Graph graph;
    private final PointImpl originalTopLeft;
    private final PointImpl originalBottomRight;
    private PointImpl topLeft;
    private PointImpl bottomRight;
    private Float width;
    private Float height;
    private float margin = 0.0f;

    public GraphSheetImpl(Graph graph) {
        this.graph = graph;
        Iterator<Node> it = graph.getNodes().iterator();
        if (!it.hasNext()) {
            this.originalTopLeft = new PointImpl(Float.valueOf(0.0f), Float.valueOf(0.0f));
            this.originalBottomRight = new PointImpl(Float.valueOf(0.0f), Float.valueOf(0.0f));
            return;
        }
        Node node = it.next();
        Vector topLeftVector = new Vector(node.getTopLeftPosition());
        Vector bottomRightVector = new Vector(node.getBottomRightPosition());
        while (it.hasNext()) {
            node = it.next();
            if (node.getTopLeftPosition().getX().floatValue() < topLeftVector.x) {
                topLeftVector.x = node.getTopLeftPosition().getX().floatValue();
            }
            if (node.getTopLeftPosition().getY().floatValue() < topLeftVector.y) {
                topLeftVector.y = node.getTopLeftPosition().getY().floatValue();
            }
            if (node.getBottomRightPosition().getX().floatValue() > bottomRightVector.x) {
                bottomRightVector.x = node.getBottomRightPosition().getX().floatValue();
            }
            if (!(node.getBottomRightPosition().getY().floatValue() > bottomRightVector.y)) continue;
            bottomRightVector.y = node.getBottomRightPosition().getY().floatValue();
        }
        this.originalTopLeft = new PointImpl(topLeftVector);
        this.originalBottomRight = new PointImpl(bottomRightVector);
        this.updateDimensions();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Point getTopLeftPosition() {
        return this.topLeft;
    }

    public Point getBottomRightPosition() {
        return this.bottomRight;
    }

    public Float getWidth() {
        return this.width;
    }

    public Float getHeight() {
        return this.height;
    }

    public void setMargin(float value) {
        if (value != this.margin) {
            this.margin = value;
            this.updateDimensions();
        }
    }

    private void updateDimensions() {
        Vector topLeftVector = new Vector(this.originalTopLeft);
        topLeftVector.sub(this.margin, this.margin, 0.0f);
        this.topLeft = new PointImpl(topLeftVector);
        Vector bottomRightVector = new Vector(this.originalBottomRight);
        bottomRightVector.add(this.margin, this.margin, 0.0f);
        this.bottomRight = new PointImpl(bottomRightVector);
        Vector box = new Vector(bottomRightVector);
        box.sub(topLeftVector);
        this.width = Float.valueOf(box.x);
        this.height = Float.valueOf(box.y);
    }
}

