/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.awt.Font;
import org.gephi.preview.GraphImpl;
import org.gephi.preview.NodeLabelBorderImpl;
import org.gephi.preview.NodeLabelImpl;
import org.gephi.preview.PointImpl;
import org.gephi.preview.api.Color;
import org.gephi.preview.api.Node;
import org.gephi.preview.api.NodeColorizerClient;
import org.gephi.preview.api.Point;
import org.gephi.preview.api.util.Holder;
import org.gephi.preview.supervisors.NodeSupervisorImpl;
import org.gephi.preview.util.HolderImpl;
import org.gephi.preview.util.Vector;
import org.gephi.preview.util.color.SimpleColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeImpl
implements Node,
NodeColorizerClient {
    private final GraphImpl parent;
    private final Point position;
    private final Float radius;
    private final Color originalColor;
    private final HolderImpl<Color> colorHolder = new HolderImpl();
    private final PointImpl topLeftPosition;
    private final PointImpl bottomRightPosition;
    private final NodeLabelImpl label;
    private final NodeLabelBorderImpl labelBorder;

    public NodeImpl(GraphImpl parent, float x, float y, float radius, String label, float labelSize, float r, float g, float b) {
        this.parent = parent;
        this.position = new PointImpl(Float.valueOf(x), Float.valueOf(y));
        this.radius = Float.valueOf(radius);
        this.originalColor = new SimpleColor(r, g, b, 0.0f);
        if (label != null) {
            this.label = new NodeLabelImpl(this, label, labelSize);
            this.labelBorder = new NodeLabelBorderImpl(this);
        } else {
            this.label = null;
            this.labelBorder = null;
        }
        Vector topLeftVector = new Vector(this.position);
        topLeftVector.sub(radius, radius, 0.0f);
        this.topLeftPosition = new PointImpl(topLeftVector);
        Vector bottomRightVector = new Vector(this.position);
        bottomRightVector.add(radius, radius, 0.0f);
        this.bottomRightPosition = new PointImpl(bottomRightVector);
        this.getNodeSupervisor().addNode(this);
    }

    @Override
    public boolean hasLabel() {
        return null != this.label;
    }

    public NodeSupervisorImpl getNodeSupervisor() {
        return (NodeSupervisorImpl)this.parent.getModel().getNodeSupervisor();
    }

    public GraphImpl getParentGraph() {
        return this.parent;
    }

    @Override
    public Point getPosition() {
        return this.position;
    }

    @Override
    public Point getTopLeftPosition() {
        return this.topLeftPosition;
    }

    @Override
    public Point getBottomRightPosition() {
        return this.bottomRightPosition;
    }

    @Override
    public NodeLabelImpl getLabel() {
        return this.label;
    }

    public Font getBaseLabelFont() {
        return this.getNodeSupervisor().getBaseNodeLabelFont();
    }

    @Override
    public NodeLabelBorderImpl getLabelBorder() {
        return this.labelBorder;
    }

    @Override
    public Float getRadius() {
        return this.radius;
    }

    @Override
    public Float getDiameter() {
        return Float.valueOf(this.radius.floatValue() * 2.0f);
    }

    @Override
    public Color getOriginalColor() {
        return this.originalColor;
    }

    @Override
    public Color getColor() {
        return this.colorHolder.getComponent();
    }

    @Override
    public Holder<Color> getColorHolder() {
        return this.colorHolder;
    }

    @Override
    public void setColor(Color color) {
        this.colorHolder.setComponent(color);
    }

    @Override
    public Color getBorderColor() {
        return this.getNodeSupervisor().getNodeBorderColorizer().getColor();
    }

    @Override
    public Float getBorderWidth() {
        return this.getNodeSupervisor().getNodeBorderWidth();
    }

    @Override
    public Boolean showLabel() {
        return this.getNodeSupervisor().getShowNodeLabels();
    }

    @Override
    public Boolean showLabelBorders() {
        return this.getNodeSupervisor().getShowNodeLabelBorders();
    }
}

