/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gephi.preview.api.BidirectionalEdge;
import org.gephi.preview.api.Graph;
import org.gephi.preview.api.Node;
import org.gephi.preview.api.SelfLoop;
import org.gephi.preview.api.UndirectedEdge;
import org.gephi.preview.api.UnidirectionalEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialGraphImpl
implements Graph {
    private final float visibilityRatio;
    private final Set<Node> visibleNodes = new HashSet<Node>();
    private final Set<SelfLoop> visibleSelfLoops = new HashSet<SelfLoop>();
    private final Set<UnidirectionalEdge> visibleUnidirectionalEdges = new HashSet<UnidirectionalEdge>();
    private final Set<BidirectionalEdge> visibleBidirectionalEdges = new HashSet<BidirectionalEdge>();
    private final Set<UndirectedEdge> visibleUndirectedEdges = new HashSet<UndirectedEdge>();
    private final Graph originalGraph;

    public PartialGraphImpl(Graph originalGraph, float visibilityRatio) {
        this.originalGraph = originalGraph;
        this.visibilityRatio = visibilityRatio;
        this.updateVisibleGraphParts();
    }

    public float getVisibilityRatio() {
        return this.visibilityRatio;
    }

    public Graph getOriginalGraph() {
        return this.originalGraph;
    }

    @Override
    public Iterable<Node> getNodes() {
        return this.visibleNodes;
    }

    @Override
    public Iterable<SelfLoop> getSelfLoops() {
        return this.visibleSelfLoops;
    }

    @Override
    public Iterable<UnidirectionalEdge> getUnidirectionalEdges() {
        return this.visibleUnidirectionalEdges;
    }

    @Override
    public Iterable<BidirectionalEdge> getBidirectionalEdges() {
        return this.visibleBidirectionalEdges;
    }

    @Override
    public Iterable<UndirectedEdge> getUndirectedEdges() {
        return this.visibleUndirectedEdges;
    }

    @Override
    public int countNodes() {
        return this.visibleNodes.size();
    }

    @Override
    public int countSelfLoops() {
        return this.visibleSelfLoops.size();
    }

    @Override
    public int countUnidirectionalEdges() {
        return this.visibleUnidirectionalEdges.size();
    }

    @Override
    public int countBidirectionalEdges() {
        return this.visibleBidirectionalEdges.size();
    }

    @Override
    public int countUndirectedEdges() {
        return this.visibleUndirectedEdges.size();
    }

    @Override
    public Boolean showNodes() {
        return this.originalGraph.showNodes();
    }

    @Override
    public Boolean showEdges() {
        return this.originalGraph.showEdges();
    }

    @Override
    public Boolean showSelfLoops() {
        return this.originalGraph.showSelfLoops();
    }

    private void updateVisibleGraphParts() {
        this.updateVisibleNodes();
        this.updateVisibleSelfLoops();
        this.updateVisibleUnidirectionalEdges();
        this.updateVisibleBidirectionalEdges();
        this.updateVisibleUndirectedEdges();
    }

    private void updateVisibleNodes() {
        int visibleNodesCount = (int)((float)this.originalGraph.countNodes() * this.visibilityRatio);
        if (visibleNodesCount == 0) {
            visibleNodesCount = Math.min(10, this.originalGraph.countNodes());
        }
        Iterator<Node> nodeIt = this.originalGraph.getNodes().iterator();
        this.visibleNodes.clear();
        for (int i = 0; i < visibleNodesCount && nodeIt.hasNext(); ++i) {
            this.visibleNodes.add(nodeIt.next());
        }
    }

    private void updateVisibleSelfLoops() {
        this.visibleSelfLoops.clear();
        for (SelfLoop sl : this.originalGraph.getSelfLoops()) {
            if (!this.visibleNodes.contains(sl.getNode())) continue;
            this.visibleSelfLoops.add(sl);
        }
    }

    private void updateVisibleUnidirectionalEdges() {
        this.visibleUnidirectionalEdges.clear();
        for (UnidirectionalEdge ue : this.originalGraph.getUnidirectionalEdges()) {
            if (!this.visibleNodes.contains(ue.getNode1()) || !this.visibleNodes.contains(ue.getNode2())) continue;
            this.visibleUnidirectionalEdges.add(ue);
        }
    }

    private void updateVisibleBidirectionalEdges() {
        this.visibleBidirectionalEdges.clear();
        for (BidirectionalEdge be : this.originalGraph.getBidirectionalEdges()) {
            if (!this.visibleNodes.contains(be.getNode1()) || !this.visibleNodes.contains(be.getNode2())) continue;
            this.visibleBidirectionalEdges.add(be);
        }
    }

    private void updateVisibleUndirectedEdges() {
        this.visibleUndirectedEdges.clear();
        for (UndirectedEdge e : this.originalGraph.getUndirectedEdges()) {
            if (!this.visibleNodes.contains(e.getNode1()) || !this.visibleNodes.contains(e.getNode2())) continue;
            this.visibleUndirectedEdges.add(e);
        }
    }
}

