/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gephi.preview.api.PreviewPreset;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PresetUtils {
    private List<PreviewPreset> presets;

    public void savePreset(PreviewPreset preset) {
        int exist = -1;
        for (int i = 0; i < this.presets.size(); ++i) {
            PreviewPreset p = this.presets.get(i);
            if (!p.getName().equals(preset.getName())) continue;
            exist = i;
            break;
        }
        if (exist == -1) {
            this.addPreset(preset);
        } else {
            this.presets.set(exist, preset);
        }
        try {
            FileObject presetFile;
            FileObject folder = FileUtil.getConfigFile((String)"previewpresets");
            if (folder == null) {
                folder = FileUtil.getConfigRoot().createFolder("previewpresets");
            }
            if ((presetFile = folder.getFileObject(preset.getName(), "xml")) == null) {
                presetFile = folder.createData(preset.getName(), "xml");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.setXmlVersion("1.0");
            document.setXmlStandalone(true);
            this.writeXML(document, preset);
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(FileUtil.toFile((FileObject)presetFile));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PreviewPreset[] getPresets() {
        if (this.presets == null) {
            this.presets = new ArrayList<PreviewPreset>();
            this.loadPresets();
        }
        return this.presets.toArray(new PreviewPreset[0]);
    }

    private void loadPresets() {
        FileObject folder = FileUtil.getConfigFile((String)"previewpresets");
        if (folder != null) {
            for (FileObject child : folder.getChildren()) {
                if (!child.isValid() || !child.hasExt("xml")) continue;
                try {
                    InputStream stream = child.getInputStream();
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(stream);
                    PreviewPreset preset = this.readXML(document);
                    this.addPreset(preset);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void writeXML(Document doc, PreviewPreset preset) {
        Element presetE = doc.createElement("previewpreset");
        presetE.setAttribute("name", preset.getName());
        presetE.setAttribute("version", "0.7");
        for (Map.Entry<String, String> entry : preset.getProperties().entrySet()) {
            String propertyName = entry.getKey();
            String propertyValue = entry.getValue();
            Element propertyE = doc.createElement("previewproperty");
            propertyE.setAttribute("name", propertyName);
            propertyE.setTextContent(propertyValue);
            presetE.appendChild(propertyE);
        }
        doc.appendChild(presetE);
    }

    private PreviewPreset readXML(Document document) {
        Element presetE = document.getDocumentElement();
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        NodeList propertyList = presetE.getElementsByTagName("previewproperty");
        for (int i = 0; i < propertyList.getLength(); ++i) {
            Node n = propertyList.item(i);
            if (n.getNodeType() != 1) continue;
            Element propertyE = (Element)n;
            String name = propertyE.getAttribute("name");
            String value = propertyE.getTextContent();
            if (value.isEmpty()) continue;
            propertiesMap.put(name, value);
        }
        PreviewPreset preset = new PreviewPreset(presetE.getAttribute("name"), propertiesMap);
        return preset;
    }

    private void addPreset(PreviewPreset preset) {
        this.presets.add(preset);
    }
}

