/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.preview.GraphImpl;
import org.gephi.preview.GraphSheetImpl;
import org.gephi.preview.PartialGraphImpl;
import org.gephi.preview.PresetUtils;
import org.gephi.preview.PreviewGraphFactory;
import org.gephi.preview.PreviewModelImpl;
import org.gephi.preview.api.Graph;
import org.gephi.preview.api.GraphSheet;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewPreset;
import org.gephi.preview.presets.DefaultCurved;
import org.gephi.preview.presets.DefaultPreset;
import org.gephi.preview.presets.DefaultStraight;
import org.gephi.preview.presets.EdgesCustomColor;
import org.gephi.preview.presets.HighlightMutualEdges;
import org.gephi.preview.presets.SmallLabels;
import org.gephi.preview.presets.TagCloud;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.openide.util.Lookup;

public class PreviewControllerImpl
implements PreviewController {
    private final PreviewGraphFactory factory = new PreviewGraphFactory();
    private final PresetUtils presetUtils = new PresetUtils();
    private GraphImpl previewGraph = null;
    private PartialGraphImpl partialPreviewGraph = null;
    private GraphSheetImpl graphSheet = null;
    private GraphSheetImpl partialGraphSheet = null;
    private PreviewModelImpl model;

    public PreviewControllerImpl() {
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
                workspace.add(new PreviewModelImpl());
            }

            public void select(Workspace workspace) {
                PreviewControllerImpl.this.model = (PreviewModelImpl)workspace.getLookup().lookup(PreviewModel.class);
                if (PreviewControllerImpl.this.model == null) {
                    PreviewControllerImpl.this.model = new PreviewModelImpl();
                    workspace.add(PreviewControllerImpl.this.model);
                }
            }

            public void unselect(Workspace workspace) {
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                PreviewControllerImpl.this.graphSheet = null;
                PreviewControllerImpl.this.model = null;
                PreviewControllerImpl.this.partialGraphSheet = null;
                PreviewControllerImpl.this.previewGraph = null;
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            Workspace workspace = pc.getCurrentWorkspace();
            this.model = (PreviewModelImpl)workspace.getLookup().lookup(PreviewModel.class);
            if (this.model == null) {
                this.model = new PreviewModelImpl();
                workspace.add(this.model);
            }
        }
    }

    public Graph getGraph() {
        if (this.model != null) {
            if (this.model.isUpdateFlag()) {
                this.buildGraph();
            }
            return this.previewGraph;
        }
        return null;
    }

    public Graph getPartialGraph(float visibilityRatio) {
        if (this.model != null) {
            if (this.model.isUpdateFlag() || null == this.partialPreviewGraph || this.partialPreviewGraph.getVisibilityRatio() != visibilityRatio) {
                Graph graph = this.getGraph();
                if (graph == null) {
                    return null;
                }
                this.partialPreviewGraph = new PartialGraphImpl(graph, visibilityRatio);
                this.model.setVisibilityRatio(visibilityRatio);
            }
            return this.partialPreviewGraph;
        }
        return null;
    }

    public GraphSheet getGraphSheet() {
        if (this.model != null) {
            if (this.model.isUpdateFlag() || null == this.graphSheet || this.graphSheet.getGraph() != this.previewGraph) {
                Graph graph = this.getGraph();
                if (graph == null) {
                    return null;
                }
                this.graphSheet = new GraphSheetImpl(graph);
            }
            return this.graphSheet;
        }
        return null;
    }

    public GraphSheet getPartialGraphSheet(float visibilityRatio) {
        if (this.model != null) {
            Graph graph;
            if ((this.model.isUpdateFlag() || null == this.partialGraphSheet || ((PartialGraphImpl)this.partialGraphSheet.getGraph()).getVisibilityRatio() != visibilityRatio) && (graph = this.getPartialGraph(visibilityRatio)) != null) {
                this.partialGraphSheet = new GraphSheetImpl(graph);
            }
            return this.partialGraphSheet;
        }
        return null;
    }

    public void buildGraph() {
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
        this.model.clearSupervisors();
        graphModel.getGraph().readLock();
        if (graphModel.isUndirected()) {
            this.previewGraph = this.factory.createPreviewGraph((PreviewModel)this.model, graphModel.getHierarchicalUndirectedGraphVisible());
        } else if (graphModel.isDirected()) {
            this.previewGraph = this.factory.createPreviewGraph((PreviewModel)this.model, graphModel.getHierarchicalDirectedGraphVisible());
        } else if (graphModel.isMixed()) {
            this.previewGraph = this.factory.createPreviewGraph((PreviewModel)this.model, graphModel.getHierarchicalMixedGraphVisible());
        }
        graphModel.getGraph().readUnlockAll();
        this.model.setUpdateFlag(true);
    }

    public PreviewModel getModel() {
        return this.model;
    }

    public PreviewPreset[] getDefaultPresets() {
        ArrayList<PreviewPreset> presets = new ArrayList<PreviewPreset>();
        presets.add(new DefaultPreset());
        presets.add(new DefaultCurved());
        presets.add(new DefaultStraight());
        presets.add(new SmallLabels());
        presets.add(new HighlightMutualEdges());
        presets.add(new TagCloud());
        presets.add(new EdgesCustomColor());
        return presets.toArray(new PreviewPreset[0]);
    }

    public PreviewPreset[] getUserPresets() {
        Object[] presetsArray = this.presetUtils.getPresets();
        Arrays.sort(presetsArray);
        return presetsArray;
    }

    public void savePreset(String name) {
        if (this.model != null) {
            PreviewPreset preset = this.model.wrapPreset(name);
            this.presetUtils.savePreset(preset);
            this.model.setCurrentPreset(preset);
        }
    }

    public void setCurrentPreset(PreviewPreset preset) {
        if (this.model != null) {
            this.model.setCurrentPreset(preset);
            this.model.applyPreset(preset);
        }
    }

    public void setBackgroundColor(Color color) {
        if (this.model != null) {
            this.model.setBackgroundColor(color);
        }
    }
}

