/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.util.HashMap;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.dynamic.DynamicUtilities;
import org.gephi.dynamic.api.DynamicController;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeData;
import org.gephi.graph.api.HierarchicalDirectedGraph;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.HierarchicalMixedGraph;
import org.gephi.graph.api.HierarchicalUndirectedGraph;
import org.gephi.graph.api.MixedGraph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeData;
import org.gephi.graph.api.TextData;
import org.gephi.preview.BidirectionalEdgeImpl;
import org.gephi.preview.GraphImpl;
import org.gephi.preview.NodeImpl;
import org.gephi.preview.SelfLoopImpl;
import org.gephi.preview.UndirectedEdgeImpl;
import org.gephi.preview.UnidirectionalEdgeImpl;
import org.gephi.preview.api.PreviewModel;
import org.openide.util.Lookup;

public class PreviewGraphFactory {
    private final HashMap<Integer, NodeImpl> nodeMap = new HashMap();
    private TimeInterval timeInterval = new TimeInterval();

    public GraphImpl createPreviewGraph(PreviewModel model, HierarchicalUndirectedGraph sourceGraph) {
        GraphImpl previewGraph = new GraphImpl(model);
        for (Node sourceNode : sourceGraph.getNodes()) {
            this.createPreviewNode(previewGraph, sourceNode);
        }
        this.calculateMinMaxWeight(sourceGraph, previewGraph);
        for (Edge sourceEdge : sourceGraph.getEdgesAndMetaEdges()) {
            if (sourceEdge.isSelfLoop()) {
                this.createPreviewSelfLoop(previewGraph, sourceEdge);
                continue;
            }
            this.createPreviewUndirectedEdge(previewGraph, sourceEdge);
        }
        this.nodeMap.clear();
        return previewGraph;
    }

    public GraphImpl createPreviewGraph(PreviewModel model, HierarchicalDirectedGraph sourceGraph) {
        GraphImpl previewGraph = new GraphImpl(model);
        for (Node sourceNode : sourceGraph.getNodes()) {
            this.createPreviewNode(previewGraph, sourceNode);
        }
        this.calculateMinMaxWeight(sourceGraph, previewGraph);
        for (Edge sourceEdge : sourceGraph.getEdgesAndMetaEdges()) {
            if (sourceEdge.isSelfLoop()) {
                this.createPreviewSelfLoop(previewGraph, sourceEdge);
                continue;
            }
            if (this.isBidirectional(sourceGraph, sourceEdge)) {
                this.createPreviewBidirectionalEdge(previewGraph, sourceEdge);
                continue;
            }
            this.createPreviewUnidirectionalEdge(previewGraph, sourceEdge);
        }
        this.nodeMap.clear();
        return previewGraph;
    }

    public GraphImpl createPreviewGraph(PreviewModel model, HierarchicalMixedGraph sourceGraph) {
        GraphImpl previewGraph = new GraphImpl(model);
        for (Node sourceNode : sourceGraph.getNodes()) {
            this.createPreviewNode(previewGraph, sourceNode);
        }
        this.calculateMinMaxWeight(sourceGraph, previewGraph);
        for (Edge sourceEdge : sourceGraph.getEdgesAndMetaEdges()) {
            if (sourceEdge.isSelfLoop()) {
                this.createPreviewSelfLoop(previewGraph, sourceEdge);
                continue;
            }
            if (sourceEdge.isDirected()) {
                if (this.isBidirectional(sourceGraph, sourceEdge)) {
                    this.createPreviewBidirectionalEdge(previewGraph, sourceEdge);
                    continue;
                }
                this.createPreviewUnidirectionalEdge(previewGraph, sourceEdge);
                continue;
            }
            this.createPreviewUndirectedEdge(previewGraph, sourceEdge);
        }
        this.nodeMap.clear();
        return previewGraph;
    }

    private void calculateMinMaxWeight(HierarchicalGraph sourceGraph, GraphImpl previewGraph) {
        DynamicController dynamicController = (DynamicController)Lookup.getDefault().lookup(DynamicController.class);
        if (dynamicController != null) {
            this.timeInterval = DynamicUtilities.getVisibleInterval(dynamicController.getModel(sourceGraph.getGraphModel().getWorkspace()));
        }
        if (this.timeInterval == null) {
            this.timeInterval = new TimeInterval();
        }
        float minWeight = Float.POSITIVE_INFINITY;
        float maxWeight = Float.NEGATIVE_INFINITY;
        float minMetaWeight = Float.POSITIVE_INFINITY;
        float maxMetaWeight = Float.NEGATIVE_INFINITY;
        for (Edge sourceEdge : sourceGraph.getEdges()) {
            minWeight = Math.min(minWeight, sourceEdge.getWeight(this.timeInterval.getLow(), this.timeInterval.getHigh()));
            maxWeight = Math.max(maxWeight, sourceEdge.getWeight(this.timeInterval.getLow(), this.timeInterval.getHigh()));
        }
        for (Edge sourceEdge : sourceGraph.getMetaEdges()) {
            minMetaWeight = Math.min(minMetaWeight, sourceEdge.getWeight(this.timeInterval.getLow(), this.timeInterval.getHigh()));
            maxMetaWeight = Math.max(maxMetaWeight, sourceEdge.getWeight(this.timeInterval.getLow(), this.timeInterval.getHigh()));
        }
        previewGraph.setMinWeight(minWeight);
        previewGraph.setMaxWeight(maxWeight);
        previewGraph.setMinMetaWeight(minMetaWeight);
        previewGraph.setMaxMetaWeight(maxMetaWeight);
    }

    private NodeImpl createPreviewNode(GraphImpl previewGraph, Node sourceNode) {
        NodeData sourceNodeData = sourceNode.getNodeData();
        TextData sourceNodeTextData = sourceNodeData.getTextData();
        String label = sourceNodeData.getLabel();
        if (sourceNodeTextData != null && sourceNodeTextData.getText() != null && !sourceNodeTextData.getText().isEmpty() && sourceNodeTextData.isVisible()) {
            label = sourceNodeTextData.getText();
        } else if (sourceNodeTextData != null && !sourceNodeTextData.isVisible()) {
            label = null;
        }
        float labelSize = 1.0f;
        if (sourceNodeTextData != null) {
            labelSize = sourceNodeTextData.getSize();
        }
        if (previewGraph.getModel().getNodeSupervisor().getProportionalLabelSize().booleanValue()) {
            labelSize *= sourceNodeData.getRadius() / 10.0f;
        }
        NodeImpl previewNode = new NodeImpl(previewGraph, sourceNodeData.x(), -sourceNodeData.y(), sourceNodeData.getRadius(), label, labelSize, sourceNodeData.r(), sourceNodeData.g(), sourceNodeData.b());
        previewGraph.addNode(previewNode);
        this.nodeMap.put(sourceNode.getId(), previewNode);
        return previewNode;
    }

    private SelfLoopImpl createPreviewSelfLoop(GraphImpl previewGraph, Edge sourceEdge) {
        EdgeData sourceEdgeData = sourceEdge.getEdgeData();
        SelfLoopImpl previewSelfLoop = new SelfLoopImpl(previewGraph, sourceEdge, sourceEdge.getWeight(this.timeInterval.getLow(), this.timeInterval.getHigh()), this.nodeMap.get(sourceEdge.getSource().getId()));
        previewGraph.addSelfLoop(previewSelfLoop);
        return previewSelfLoop;
    }

    private UnidirectionalEdgeImpl createPreviewUnidirectionalEdge(GraphImpl previewGraph, Edge sourceEdge) {
        EdgeData sourceEdgeData = sourceEdge.getEdgeData();
        TextData sourceEdgeTextData = sourceEdgeData.getTextData();
        String label = sourceEdgeData.getLabel();
        if (sourceEdgeTextData != null && sourceEdgeTextData.getText() != null && !sourceEdgeTextData.getText().isEmpty() && sourceEdgeTextData.isVisible()) {
            label = sourceEdgeTextData.getText();
        } else if (sourceEdgeTextData != null && !sourceEdgeTextData.isVisible()) {
            label = null;
        }
        float labelSize = 1.0f;
        if (sourceEdgeTextData != null) {
            labelSize = sourceEdgeTextData.getSize();
        }
        UnidirectionalEdgeImpl previewEdge = new UnidirectionalEdgeImpl(previewGraph, sourceEdge, sourceEdge.getWeight(this.timeInterval.getLow(), this.timeInterval.getHigh()), this.nodeMap.get(sourceEdge.getSource().getId()), this.nodeMap.get(sourceEdge.getTarget().getId()), label, labelSize);
        previewGraph.addUnidirectionalEdge(previewEdge);
        return previewEdge;
    }

    private BidirectionalEdgeImpl createPreviewBidirectionalEdge(GraphImpl previewGraph, Edge sourceEdge) {
        EdgeData sourceEdgeData = sourceEdge.getEdgeData();
        TextData sourceEdgeTextData = sourceEdgeData.getTextData();
        String label = sourceEdgeData.getLabel();
        if (sourceEdgeTextData != null && sourceEdgeTextData.getText() != null && !sourceEdgeTextData.getText().isEmpty() && sourceEdgeTextData.isVisible()) {
            label = sourceEdgeTextData.getText();
        } else if (sourceEdgeTextData != null && !sourceEdgeTextData.isVisible()) {
            label = null;
        }
        float labelSize = 1.0f;
        if (sourceEdgeTextData != null) {
            labelSize = sourceEdgeTextData.getSize();
        }
        BidirectionalEdgeImpl previewEdge = new BidirectionalEdgeImpl(previewGraph, sourceEdge, sourceEdge.getWeight(this.timeInterval.getLow(), this.timeInterval.getHigh()), this.nodeMap.get(sourceEdge.getSource().getId()), this.nodeMap.get(sourceEdge.getTarget().getId()), label, labelSize);
        previewGraph.addBidirectionalEdge(previewEdge);
        return previewEdge;
    }

    private UndirectedEdgeImpl createPreviewUndirectedEdge(GraphImpl previewGraph, Edge sourceEdge) {
        EdgeData sourceEdgeData = sourceEdge.getEdgeData();
        TextData sourceEdgeTextData = sourceEdgeData.getTextData();
        String label = sourceEdgeData.getLabel();
        if (sourceEdgeTextData != null && sourceEdgeTextData.getText() != null && !sourceEdgeTextData.getText().isEmpty() && sourceEdgeTextData.isVisible()) {
            label = sourceEdgeTextData.getText();
        } else if (sourceEdgeTextData != null && !sourceEdgeTextData.isVisible()) {
            label = null;
        }
        float labelSize = 1.0f;
        if (sourceEdgeTextData != null) {
            labelSize = sourceEdgeTextData.getSize();
        }
        UndirectedEdgeImpl previewEdge = new UndirectedEdgeImpl(previewGraph, sourceEdge, sourceEdge.getWeight(this.timeInterval.getLow(), this.timeInterval.getHigh()), this.nodeMap.get(sourceEdge.getSource().getId()), this.nodeMap.get(sourceEdge.getTarget().getId()), label, labelSize);
        previewGraph.addUndirectedEdge(previewEdge);
        return previewEdge;
    }

    private boolean isBidirectional(DirectedGraph sourceGraph, Edge sourceEdge) {
        return sourceGraph.getEdge(sourceEdge.getTarget(), sourceEdge.getSource()) != null;
    }

    private boolean isBidirectional(MixedGraph sourceGraph, Edge sourceEdge) {
        return sourceGraph.getEdge(sourceEdge.getTarget(), sourceEdge.getSource()) != null;
    }
}

