/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.HashMap;
import java.util.Map;
import org.gephi.graph.api.GraphEvent;
import org.gephi.graph.api.GraphListener;
import org.gephi.graph.api.GraphModel;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewPreset;
import org.gephi.preview.api.SupervisorPropery;
import org.gephi.preview.api.supervisors.DirectedEdgeSupervisor;
import org.gephi.preview.api.supervisors.GlobalEdgeSupervisor;
import org.gephi.preview.api.supervisors.NodeSupervisor;
import org.gephi.preview.api.supervisors.SelfLoopSupervisor;
import org.gephi.preview.api.supervisors.Supervisor;
import org.gephi.preview.api.supervisors.UndirectedEdgeSupervisor;
import org.gephi.preview.presets.DefaultPreset;
import org.gephi.preview.supervisors.BidirectionalEdgeSupervisorImpl;
import org.gephi.preview.supervisors.GlobalEdgeSupervisorImpl;
import org.gephi.preview.supervisors.NodeSupervisorImpl;
import org.gephi.preview.supervisors.SelfLoopSupervisorImpl;
import org.gephi.preview.supervisors.UndirectedEdgeSupervisorImpl;
import org.gephi.preview.supervisors.UnidirectionalEdgeSupervisorImpl;
import org.gephi.project.api.Workspace;
import org.openide.nodes.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreviewModelImpl
implements PreviewModel,
GraphListener {
    private final NodeSupervisorImpl nodeSupervisor;
    private final GlobalEdgeSupervisorImpl globalEdgeSupervisor;
    private final SelfLoopSupervisorImpl selfLoopSupervisor;
    private final UnidirectionalEdgeSupervisorImpl uniEdgeSupervisor;
    private final BidirectionalEdgeSupervisorImpl biEdgeSupervisor;
    private final UndirectedEdgeSupervisorImpl undirectedEdgeSupervisor;
    private boolean updateFlag = true;
    private float visibilityRatio = 1.0f;
    private Color backgroundColor = Color.WHITE;
    private PreviewPreset currentPreset;

    public PreviewModelImpl() {
        this.nodeSupervisor = new NodeSupervisorImpl();
        this.globalEdgeSupervisor = new GlobalEdgeSupervisorImpl();
        this.selfLoopSupervisor = new SelfLoopSupervisorImpl();
        this.uniEdgeSupervisor = new UnidirectionalEdgeSupervisorImpl();
        this.biEdgeSupervisor = new BidirectionalEdgeSupervisorImpl();
        this.undirectedEdgeSupervisor = new UndirectedEdgeSupervisorImpl();
        this.currentPreset = new DefaultPreset();
        this.applyPreset(this.currentPreset);
    }

    public void select(Workspace workspace) {
        GraphModel graphModel = (GraphModel)workspace.getLookup().lookup(GraphModel.class);
        graphModel.addGraphListener(this);
    }

    public void unselect(Workspace workspace) {
        GraphModel graphModel = (GraphModel)workspace.getLookup().lookup(GraphModel.class);
        graphModel.removeGraphListener(this);
    }

    @Override
    public void graphChanged(GraphEvent event) {
        this.updateFlag = true;
    }

    public void clearSupervisors() {
        this.nodeSupervisor.clearSupervised();
        this.globalEdgeSupervisor.clearSupervised();
        this.selfLoopSupervisor.clearSupervised();
        this.uniEdgeSupervisor.clearSupervised();
        this.biEdgeSupervisor.clearSupervised();
    }

    @Override
    public NodeSupervisor getNodeSupervisor() {
        return this.nodeSupervisor;
    }

    @Override
    public GlobalEdgeSupervisor getGlobalEdgeSupervisor() {
        return this.globalEdgeSupervisor;
    }

    @Override
    public SelfLoopSupervisor getSelfLoopSupervisor() {
        return this.selfLoopSupervisor;
    }

    @Override
    public DirectedEdgeSupervisor getUniEdgeSupervisor() {
        return this.uniEdgeSupervisor;
    }

    @Override
    public DirectedEdgeSupervisor getBiEdgeSupervisor() {
        return this.biEdgeSupervisor;
    }

    @Override
    public UndirectedEdgeSupervisor getUndirectedEdgeSupervisor() {
        return this.undirectedEdgeSupervisor;
    }

    public boolean isUpdateFlag() {
        return this.updateFlag;
    }

    public void setUpdateFlag(boolean updateFlag) {
        this.updateFlag = updateFlag;
    }

    @Override
    public float getVisibilityRatio() {
        return this.visibilityRatio;
    }

    public void setVisibilityRatio(float visibilityRatio) {
        this.visibilityRatio = visibilityRatio;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public PreviewPreset getCurrentPreset() {
        return this.currentPreset;
    }

    public void setCurrentPreset(PreviewPreset currentPreset) {
        this.currentPreset = currentPreset;
    }

    public PreviewPreset wrapPreset(String name) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (Node.Property p : this.getPropertiesMap().values()) {
            try {
                Object propertyValue = p.getValue();
                if (propertyValue == null) continue;
                PropertyEditor editor = p.getPropertyEditor();
                if (editor == null) {
                    editor = PropertyEditorManager.findEditor(p.getValueType());
                }
                if (editor == null) continue;
                editor.setValue(propertyValue);
                String val = editor.getAsText();
                if (val.isEmpty()) continue;
                propertiesMap.put(p.getName(), val);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new PreviewPreset(name, propertiesMap);
    }

    public void applyPreset(PreviewPreset preset) {
        Map<String, String> propertiesMap = preset.getProperties();
        for (Node.Property p : this.getPropertiesMap().values()) {
            try {
                String valueStr;
                PropertyEditor editor = p.getPropertyEditor();
                if (editor == null) {
                    editor = PropertyEditorManager.findEditor(p.getValueType());
                }
                if (editor == null || (valueStr = propertiesMap.get(p.getName())) == null || valueStr.isEmpty()) continue;
                if (p.getValueType().equals(Font.class)) {
                    p.setValue((Object)Font.decode(valueStr));
                    continue;
                }
                editor.setAsText(valueStr);
                Object value = editor.getValue();
                if (value == null) continue;
                p.setValue(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Element writeXML(Document document) {
        Element previewModelE = document.createElement("previewmodel");
        Element visibilityRatioE = document.createElement("ratio");
        visibilityRatioE.setTextContent(String.valueOf(this.visibilityRatio));
        previewModelE.appendChild(visibilityRatioE);
        Element colorE = document.createElement("backgroundcolor");
        colorE.setTextContent("" + this.backgroundColor.getRGB());
        previewModelE.appendChild(colorE);
        this.writeProperties(document, previewModelE, this.nodeSupervisor);
        this.writeProperties(document, previewModelE, this.globalEdgeSupervisor);
        this.writeProperties(document, previewModelE, this.selfLoopSupervisor);
        this.writeProperties(document, previewModelE, this.uniEdgeSupervisor);
        this.writeProperties(document, previewModelE, this.biEdgeSupervisor);
        this.writeProperties(document, previewModelE, this.undirectedEdgeSupervisor);
        return previewModelE;
    }

    private void writeProperties(Document document, Element parent, Supervisor supervisor) {
        for (SupervisorPropery p : supervisor.getProperties()) {
            String propertyName = p.getProperty().getName();
            try {
                Object propertyValue = p.getProperty().getValue();
                if (propertyValue == null) continue;
                PropertyEditor editor = p.getProperty().getPropertyEditor();
                if (editor == null) {
                    editor = PropertyEditorManager.findEditor(p.getProperty().getValueType());
                }
                if (editor == null) continue;
                Element propertyE = document.createElement("previewproperty");
                propertyE.setAttribute("name", propertyName);
                editor.setValue(propertyValue);
                propertyE.setTextContent(editor.getAsText());
                parent.appendChild(propertyE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void readXML(Element previewModelE) {
        Map<String, Node.Property> propertiesMap = this.getPropertiesMap();
        NodeList childList = previewModelE.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            String name;
            Node.Property p;
            Node n = childList.item(i);
            if (n.getNodeType() != 1) continue;
            Element childE = (Element)n;
            if (childE.getNodeName().equals("ratio")) {
                this.visibilityRatio = Float.parseFloat(childE.getTextContent());
                continue;
            }
            if (childE.getNodeName().equals("backgroundcolor")) {
                this.backgroundColor = new Color(Integer.parseInt(childE.getTextContent()));
                continue;
            }
            if (!childE.getNodeName().equals("previewproperty") || (p = propertiesMap.get(name = childE.getAttribute("name"))) == null) continue;
            PropertyEditor editor = p.getPropertyEditor();
            if (editor == null) {
                editor = PropertyEditorManager.findEditor(p.getValueType());
            }
            if (editor == null) continue;
            editor.setAsText(childE.getTextContent());
            if (editor.getValue() == null) continue;
            try {
                p.setValue(editor.getValue());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Map<String, Node.Property> getPropertiesMap() {
        Supervisor[] supervisors;
        HashMap<String, Node.Property> propertiesMap = new HashMap<String, Node.Property>();
        for (Supervisor s : supervisors = new Supervisor[]{this.nodeSupervisor, this.globalEdgeSupervisor, this.selfLoopSupervisor, this.uniEdgeSupervisor, this.biEdgeSupervisor, this.undirectedEdgeSupervisor}) {
            for (SupervisorPropery p : s.getProperties()) {
                String propertyName = p.getProperty().getName();
                propertiesMap.put(propertyName, p.getProperty());
            }
        }
        return propertiesMap;
    }
}

