/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview;

import java.awt.Color;
import org.gephi.graph.api.Edge;
import org.gephi.preview.AbstractEdge;
import org.gephi.preview.CubicBezierCurveImpl;
import org.gephi.preview.GraphImpl;
import org.gephi.preview.NodeImpl;
import org.gephi.preview.PointImpl;
import org.gephi.preview.api.CubicBezierCurve;
import org.gephi.preview.api.SelfLoop;
import org.gephi.preview.supervisors.SelfLoopSupervisorImpl;
import org.gephi.preview.util.Vector;

public class SelfLoopImpl
extends AbstractEdge
implements SelfLoop {
    private final NodeImpl node;
    private CubicBezierCurveImpl curve;
    protected final Color originalColor;

    public SelfLoopImpl(GraphImpl parent, Edge edge, float thickness, NodeImpl node) {
        super(parent, thickness);
        this.node = node;
        this.originalColor = edge.getEdgeData().r() != -1.0f ? new Color(edge.getEdgeData().r(), edge.getEdgeData().g(), edge.getEdgeData().b(), edge.getEdgeData().alpha()) : null;
        this.genCurve();
        this.getSelfLoopSupervisor().addSelfLoop(this);
    }

    private void genCurve() {
        Vector v1 = new Vector(this.node.getPosition());
        v1.add(this.node.getDiameter().floatValue(), -this.node.getDiameter().floatValue(), 0.0f);
        Vector v2 = new Vector(this.node.getPosition());
        v2.add(this.node.getDiameter().floatValue(), this.node.getDiameter().floatValue(), 0.0f);
        this.curve = new CubicBezierCurveImpl(this.node.getPosition(), new PointImpl(v1), new PointImpl(v2), this.node.getPosition());
    }

    public NodeImpl getNode() {
        return this.node;
    }

    public NodeImpl getNode1() {
        return this.getNode();
    }

    public NodeImpl getNode2() {
        return this.getNode();
    }

    public CubicBezierCurve getCurve() {
        return this.curve;
    }

    public Color getOriginalColor() {
        return this.originalColor;
    }

    public SelfLoopSupervisorImpl getSelfLoopSupervisor() {
        return (SelfLoopSupervisorImpl)this.parent.getModel().getSelfLoopSupervisor();
    }

    public Float getScale() {
        return this.getSelfLoopSupervisor().getEdgeScale();
    }
}

