/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gephi.preview.api.Colorizer;
import org.gephi.preview.api.ColorizerFactory;
import org.openide.util.Lookup;

public abstract class AbstractColorizerPropertyEditor
extends PropertyEditorSupport {
    private final ColorizerFactory colorizerFactory = (ColorizerFactory)Lookup.getDefault().lookup(ColorizerFactory.class);

    public String getAsText() {
        Colorizer c = (Colorizer)this.getValue();
        return ((Object)c).toString();
    }

    public void setAsText(String s) {
        if (this.supportsCustomColorMode() && this.colorizerFactory.matchCustomColorMode(s)) {
            Pattern p = Pattern.compile("\\w+\\s*\\[\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*\\]");
            Matcher m = p.matcher(s);
            if (m.lookingAt()) {
                int r = Integer.valueOf(m.group(1));
                int g = Integer.valueOf(m.group(2));
                int b = Integer.valueOf(m.group(3));
                this.setValue(this.colorizerFactory.createCustomColorMode(r, g, b));
            }
        } else if (this.supportsNodeOriginalColorMode() && this.colorizerFactory.matchNodeOriginalColorMode(s)) {
            this.setValue(this.colorizerFactory.createNodeOriginalColorMode());
        } else if (this.supportsParentColorMode() && this.colorizerFactory.matchParentColorMode(s)) {
            this.setValue(this.colorizerFactory.createParentColorMode());
        } else if (this.supportsEdgeB1ColorMode() && this.colorizerFactory.matchEdgeB1ColorMode(s)) {
            this.setValue(this.colorizerFactory.createEdgeB1ColorMode());
        } else if (this.supportsEdgeB2ColorMode() && this.colorizerFactory.matchEdgeB2ColorMode(s)) {
            this.setValue(this.colorizerFactory.createEdgeB2ColorMode());
        } else if (this.supportsEdgeBothBColorMode() && this.colorizerFactory.matchEdgeBothBColorMode(s)) {
            this.setValue(this.colorizerFactory.createEdgeBothBColorMode());
        } else if (this.supportEdgeOriginalColorMode() && this.colorizerFactory.matchEdgeOriginalColorMode(s)) {
            this.setValue(this.colorizerFactory.createEdgeOriginalColorMode());
        }
    }

    public boolean supportsCustomColorMode() {
        return false;
    }

    public boolean supportsNodeOriginalColorMode() {
        return false;
    }

    public boolean supportsParentColorMode() {
        return false;
    }

    public boolean supportsEdgeB1ColorMode() {
        return false;
    }

    public boolean supportsEdgeB2ColorMode() {
        return false;
    }

    public boolean supportsEdgeBothBColorMode() {
        return false;
    }

    public boolean supportEdgeOriginalColorMode() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public ColorizerFactory getColorizerFactory() {
        return this.colorizerFactory;
    }
}

