/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.propertyeditors;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.GroupLayout;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.gephi.preview.api.Colorizer;
import org.gephi.preview.api.ColorizerFactory;
import org.gephi.preview.propertyeditors.AbstractColorizerPropertyEditor;
import org.gephi.preview.propertyeditors.ColorModePanel;

abstract class ColorModePanelDecorator
extends ColorModePanel {
    protected final ColorModePanel decoratedPanel;
    protected final ColorizerFactory factory;

    public ColorModePanelDecorator(AbstractColorizerPropertyEditor propertyEditor, ColorModePanel decoratedPanel) {
        super(propertyEditor);
        this.decoratedPanel = decoratedPanel;
        this.factory = propertyEditor.getColorizerFactory();
        this.setPanelContent();
    }

    public void addRadioButton(JRadioButton radioButton) {
        this.decoratedPanel.addRadioButton(radioButton);
    }

    protected void setPanelContent() {
        JRadioButton radioButton = new JRadioButton();
        radioButton.setText(this.getRadioButtonLabel());
        this.addRadioButton(radioButton);
        radioButton.setSelected(this.isSelectedRadioButton());
        radioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ColorModePanelDecorator.this.propertyEditor.setValue(ColorModePanelDecorator.this.createColorizer());
                }
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(radioButton).addComponent(this.decoratedPanel)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(radioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decoratedPanel));
    }

    protected abstract String getRadioButtonLabel();

    protected abstract boolean isSelectedRadioButton();

    protected abstract Colorizer createColorizer();
}

