/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.propertyeditors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.gephi.preview.api.Colorizer;
import org.gephi.preview.api.GenericColorizer;
import org.gephi.preview.propertyeditors.AbstractColorizerPropertyEditor;
import org.gephi.preview.propertyeditors.ColorModePanel;
import org.gephi.preview.propertyeditors.ColorModePanelDecorator;

class CustomColorModePanelDecorator
extends ColorModePanelDecorator {
    private JButton customColorButton;

    public CustomColorModePanelDecorator(AbstractColorizerPropertyEditor propertyEditor, ColorModePanel decoratedPanel) {
        super(propertyEditor, decoratedPanel);
    }

    protected void setPanelContent() {
        JRadioButton radioButton = new JRadioButton();
        radioButton.setText(this.getRadioButtonLabel());
        this.addRadioButton(radioButton);
        this.customColorButton = this.factory.isCustomColorMode((Colorizer)this.propertyEditor.getValue()) ? new JColorButton(((GenericColorizer)this.propertyEditor.getValue()).getAwtColor(), this.customColorButton) : new JColorButton(Color.BLACK, this.customColorButton);
        radioButton.setSelected(this.isSelectedRadioButton());
        this.customColorButton.setEnabled(this.isSelectedRadioButton());
        radioButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                CustomColorModePanelDecorator.this.customColorButton.setEnabled(e.getStateChange() == 1);
                CustomColorModePanelDecorator.this.propertyEditor.setValue(CustomColorModePanelDecorator.this.createColorizer());
            }
        });
        this.customColorButton.addPropertyChangeListener(JColorButton.EVENT_COLOR, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Color newColor = (Color)evt.getNewValue();
                CustomColorModePanelDecorator.this.propertyEditor.setValue(CustomColorModePanelDecorator.this.factory.createCustomColorMode(newColor));
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(radioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customColorButton)).addComponent(this.decoratedPanel)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(radioButton).addComponent(this.customColorButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decoratedPanel));
    }

    protected String getRadioButtonLabel() {
        return "Custom";
    }

    protected boolean isSelectedRadioButton() {
        return this.factory.isCustomColorMode((Colorizer)this.propertyEditor.getValue());
    }

    protected Colorizer createColorizer() {
        return this.factory.createCustomColorMode(0, 0, 0);
    }

    private static class JColorButton
    extends JButton {
        public static String EVENT_COLOR = "color";
        private Color color;
        private Component parent;
        private static final int ICON_WIDTH = 16;
        private static final int ICON_HEIGHT = 16;
        private static final Color DISABLED_BORDER = new Color(200, 200, 200);
        private static final Color DISABLED_FILL = new Color(220, 220, 220);

        public JColorButton(Color originalColor, Component parent) {
            this.parent = parent;
            this.color = originalColor;
            this.setIcon(new Icon(){

                public int getIconWidth() {
                    return 16;
                }

                public int getIconHeight() {
                    return 16;
                }

                public void paintIcon(Component c, Graphics g, int x, int y) {
                    if (c.isEnabled()) {
                        g.setColor(Color.BLACK);
                        g.drawRect(x + 2, y + 2, 11, 11);
                        if (JColorButton.this.color != null) {
                            g.setColor(JColorButton.this.color);
                            g.fillRect(x + 3, y + 3, 10, 10);
                        }
                    } else {
                        g.setColor(DISABLED_BORDER);
                        g.drawRect(x + 2, y + 2, 11, 11);
                        g.setColor(DISABLED_FILL);
                        g.fillRect(x + 3, y + 3, 10, 10);
                    }
                }
            });
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Color newColor = JColorChooser.showDialog(JColorButton.this.parent, "Choose Color", JColorButton.this.color);
                    if (newColor != null) {
                        JColorButton.this.setColor(newColor);
                    }
                }
            });
        }

        public void setColor(Color color) {
            if (color != this.color || color != null && !color.equals(this.color)) {
                Color oldColor = this.color;
                this.color = color;
                this.firePropertyChange(EVENT_COLOR, oldColor, color);
                this.repaint();
            }
        }

        public Color getColor() {
            return this.color;
        }

        public float[] getColorArray() {
            return new float[]{(float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f, (float)this.color.getAlpha() / 255.0f};
        }
    }
}

