/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.supervisors;

import java.awt.Font;
import java.util.HashSet;
import java.util.Set;
import org.gephi.preview.DirectedEdgeImpl;
import org.gephi.preview.EdgeArrowImpl;
import org.gephi.preview.EdgeMiniLabelImpl;
import org.gephi.preview.api.EdgeArrow;
import org.gephi.preview.api.EdgeChildColorizer;
import org.gephi.preview.api.EdgeColorizer;
import org.gephi.preview.api.EdgeMiniLabel;
import org.gephi.preview.api.SupervisorPropery;
import org.gephi.preview.api.supervisors.DirectedEdgeSupervisor;
import org.gephi.preview.propertyeditors.EdgeChildColorizerPropertyEditor;
import org.gephi.preview.propertyeditors.EdgeColorizerPropertyEditor;
import org.gephi.preview.supervisors.EdgeSupervisorImpl;
import org.gephi.preview.updaters.LabelShortener;

public abstract class DirectedEdgeSupervisorImpl
extends EdgeSupervisorImpl
implements DirectedEdgeSupervisor {
    protected Boolean showMiniLabelsFlag;
    protected Boolean shortenMiniLabelsFlag;
    protected Integer miniLabelMaxChar;
    protected Font miniLabelFont;
    protected Float miniLabelAddedRadius;
    protected EdgeChildColorizer miniLabelColorizer;
    protected Boolean showArrowsFlag;
    protected Float arrowAddedRadius;
    protected Float arrowSize;
    protected EdgeChildColorizer arrowColorizer;
    protected Set<DirectedEdgeImpl> supervisedEdges = new HashSet<DirectedEdgeImpl>();

    public void addEdge(DirectedEdgeImpl edge) {
        super.addEdge(edge);
        this.positionEdgeMiniLabels(edge);
        this.colorEdgeMiniLabels(edge);
        this.updateEdgeMiniLabelValues(edge);
        this.positionEdgeArrows(edge);
        this.colorEdgeArrows(edge);
    }

    public Boolean getShowMiniLabelsFlag() {
        return this.showMiniLabelsFlag;
    }

    public void setShowMiniLabelsFlag(Boolean value) {
        this.showMiniLabelsFlag = value;
    }

    public Font getMiniLabelFont() {
        return this.miniLabelFont;
    }

    public void setMiniLabelFont(Font value) {
        this.miniLabelFont = value;
    }

    public Integer getMiniLabelMaxChar() {
        return this.miniLabelMaxChar;
    }

    public void setMiniLabelMaxChar(Integer value) {
        this.miniLabelMaxChar = value;
        this.updateEdgeMiniLabelValues();
    }

    public Boolean getShortenMiniLabelsFlag() {
        return this.shortenMiniLabelsFlag;
    }

    public void setShortenMiniLabelsFlag(Boolean value) {
        this.shortenMiniLabelsFlag = value;
        this.updateEdgeMiniLabelValues();
    }

    public Float getMiniLabelAddedRadius() {
        return this.miniLabelAddedRadius;
    }

    public void setMiniLabelAddedRadius(Float value) {
        this.miniLabelAddedRadius = value;
        this.positionEdgeMiniLabels();
    }

    public EdgeChildColorizer getMiniLabelColorizer() {
        return this.miniLabelColorizer;
    }

    public void setMiniLabelColorizer(EdgeChildColorizer value) {
        this.miniLabelColorizer = value;
        this.colorEdgeMiniLabels();
    }

    public Boolean getShowArrowsFlag() {
        return this.showArrowsFlag;
    }

    public void setShowArrowsFlag(Boolean value) {
        this.showArrowsFlag = value;
    }

    public Float getArrowAddedRadius() {
        return this.arrowAddedRadius;
    }

    public void setArrowAddedRadius(Float value) {
        this.arrowAddedRadius = value;
        this.positionEdgeArrows();
    }

    public Float getArrowSize() {
        return this.arrowSize;
    }

    public void setArrowSize(Float value) {
        this.arrowSize = value;
        this.positionEdgeArrows();
    }

    public EdgeChildColorizer getArrowColorizer() {
        return this.arrowColorizer;
    }

    public void setArrowColorizer(EdgeChildColorizer value) {
        this.arrowColorizer = value;
        this.colorEdgeArrows();
    }

    protected Set getSupervisedEdges() {
        return this.supervisedEdges;
    }

    private void positionEdgeMiniLabel(EdgeMiniLabelImpl edgeMiniLabel) {
        edgeMiniLabel.genPosition();
    }

    private void positionEdgeMiniLabels(DirectedEdgeImpl edge) {
        for (EdgeMiniLabel ml : edge.getMiniLabels()) {
            this.positionEdgeMiniLabel((EdgeMiniLabelImpl)ml);
        }
    }

    private void positionEdgeMiniLabels() {
        for (DirectedEdgeImpl e : this.supervisedEdges) {
            this.positionEdgeMiniLabels(e);
        }
    }

    private void colorEdgeMiniLabel(EdgeMiniLabelImpl edgeMiniLabel) {
        this.miniLabelColorizer.color(edgeMiniLabel);
    }

    private void colorEdgeMiniLabels(DirectedEdgeImpl edge) {
        for (EdgeMiniLabel ml : edge.getMiniLabels()) {
            this.colorEdgeMiniLabel((EdgeMiniLabelImpl)ml);
        }
    }

    private void colorEdgeMiniLabels() {
        for (DirectedEdgeImpl e : this.supervisedEdges) {
            this.colorEdgeMiniLabels(e);
        }
    }

    private void updateEdgeMiniLabelValues(DirectedEdgeImpl edge) {
        if (this.shortenMiniLabelsFlag.booleanValue()) {
            this.shortenEdgeMiniLabels(edge);
        } else {
            this.revertEdgeMiniLabels(edge);
        }
    }

    private void updateEdgeMiniLabelValues() {
        if (this.shortenMiniLabelsFlag.booleanValue()) {
            this.shortenEdgeMiniLabels();
        } else {
            this.revertEdgeMiniLabels();
        }
    }

    private void shortenEdgeMiniLabel(EdgeMiniLabelImpl edgeMiniLabel) {
        LabelShortener.shortenLabel(edgeMiniLabel, this.miniLabelMaxChar);
    }

    private void shortenEdgeMiniLabels(DirectedEdgeImpl edge) {
        for (EdgeMiniLabel ml : edge.getMiniLabels()) {
            this.shortenEdgeMiniLabel((EdgeMiniLabelImpl)ml);
        }
    }

    private void shortenEdgeMiniLabels() {
        for (DirectedEdgeImpl e : this.supervisedEdges) {
            this.shortenEdgeMiniLabels(e);
        }
    }

    private void revertEdgeMiniLabel(EdgeMiniLabelImpl edgeMiniLabel) {
        LabelShortener.revertLabel(edgeMiniLabel);
    }

    private void revertEdgeMiniLabels(DirectedEdgeImpl edge) {
        for (EdgeMiniLabel ml : edge.getMiniLabels()) {
            this.revertEdgeMiniLabel((EdgeMiniLabelImpl)ml);
        }
    }

    private void revertEdgeMiniLabels() {
        for (DirectedEdgeImpl e : this.supervisedEdges) {
            this.revertEdgeMiniLabels(e);
        }
    }

    private void positionEdgeArrow(EdgeArrowImpl edgeArrow) {
        edgeArrow.genPosition();
    }

    private void positionEdgeArrows(DirectedEdgeImpl edge) {
        for (EdgeArrow a : edge.getArrows()) {
            this.positionEdgeArrow((EdgeArrowImpl)a);
        }
    }

    private void positionEdgeArrows() {
        for (DirectedEdgeImpl e : this.supervisedEdges) {
            this.positionEdgeArrows(e);
        }
    }

    private void colorEdgeArrow(EdgeArrowImpl edgeArrow) {
        this.arrowColorizer.color(edgeArrow);
    }

    private void colorEdgeArrows(DirectedEdgeImpl edge) {
        for (EdgeArrow a : edge.getArrows()) {
            this.colorEdgeArrow((EdgeArrowImpl)a);
        }
    }

    private void colorEdgeArrows() {
        for (DirectedEdgeImpl e : this.supervisedEdges) {
            this.colorEdgeArrows(e);
        }
    }

    public SupervisorPropery[] getProperties() {
        String CATEGORY = "Directed";
        try {
            return new SupervisorPropery[]{SupervisorPropery.createProperty(this, Boolean.class, "Directed_curvedFlag", "Directed", "Curved", "getCurvedFlag", "setCurvedFlag"), SupervisorPropery.createProperty(this, Float.class, "Directed_edgeScale", "Directed", "Thickness", "getEdgeScale", "setEdgeScale"), SupervisorPropery.createProperty(this, Boolean.class, "Directed_rescaleWeight", "Directed", "Rescale Weight", "getRescaleWeight", "setRescaleWeight"), SupervisorPropery.createProperty(this, EdgeColorizer.class, "Directed_colorizer", "Directed", "Color", "getColorizer", "setColorizer", EdgeColorizerPropertyEditor.class), SupervisorPropery.createProperty(this, Boolean.class, "Directed_showLabelsFlag", "Directed", "Labels", "getShowLabelsFlag", "setShowLabelsFlag"), SupervisorPropery.createProperty(this, Boolean.class, "Directed_shortenLabelsFlag", "Directed", "Shorten labels", "getShortenLabelsFlag", "setShortenLabelsFlag"), SupervisorPropery.createProperty(this, Integer.class, "Directed_labelMaxChar", "Directed", "Shorten limit", "getLabelMaxChar", "setLabelMaxChar"), SupervisorPropery.createProperty(this, Font.class, "Directed_baseLabelFont", "Directed", "Font", "getBaseLabelFont", "setBaseLabelFont"), SupervisorPropery.createProperty(this, EdgeChildColorizer.class, "Directed_labelColorizer", "Directed", "Label color", "getLabelColorizer", "setLabelColorizer", EdgeChildColorizerPropertyEditor.class), SupervisorPropery.createProperty(this, Boolean.class, "Directed_showMiniLabelsFlag", "Directed", "Mini-Labels", "getShowMiniLabelsFlag", "setShowMiniLabelsFlag"), SupervisorPropery.createProperty(this, Float.class, "Directed_miniLabelAddedRadius", "Directed", "Mini-Label radius", "getMiniLabelAddedRadius", "setMiniLabelAddedRadius"), SupervisorPropery.createProperty(this, Boolean.class, "Directed_shortenMiniLabelsFlag", "Directed", "Shorten Mini-Labels", "getShortenMiniLabelsFlag", "setShortenMiniLabelsFlag"), SupervisorPropery.createProperty(this, Integer.class, "Directed_miniLabelMaxChar", "Directed", "Mini-Label limit", "getMiniLabelMaxChar", "setMiniLabelMaxChar"), SupervisorPropery.createProperty(this, Font.class, "Directed_miniLabelFont", "Directed", "Mini-Label font", "getMiniLabelFont", "setMiniLabelFont"), SupervisorPropery.createProperty(this, EdgeChildColorizer.class, "Directed_miniLabelColorizer", "Directed", "Mini-Label color", "getMiniLabelColorizer", "setMiniLabelColorizer", EdgeChildColorizerPropertyEditor.class), SupervisorPropery.createProperty(this, Boolean.class, "Directed_showArrowsFlag", "Directed", "Arrows", "getShowArrowsFlag", "setShowArrowsFlag"), SupervisorPropery.createProperty(this, Float.class, "Directed_arrowAddedRadius", "Directed", "Arrow added radius", "getArrowAddedRadius", "setArrowAddedRadius"), SupervisorPropery.createProperty(this, Float.class, "Directed_arrowSize", "Directed", "Arrow size", "getArrowSize", "setArrowSize"), SupervisorPropery.createProperty(this, EdgeChildColorizer.class, "Directed_arrowColorizer", "Directed", "Arrow color", "getArrowColorizer", "setArrowColorizer", EdgeChildColorizerPropertyEditor.class)};
        }
        catch (Exception e) {
            e.printStackTrace();
            return new SupervisorPropery[0];
        }
    }
}

