/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.supervisors;

import java.awt.Font;
import java.util.Set;
import org.gephi.preview.EdgeImpl;
import org.gephi.preview.EdgeLabelImpl;
import org.gephi.preview.api.EdgeChildColorizer;
import org.gephi.preview.api.EdgeColorizer;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.supervisors.EdgeSupervisor;
import org.gephi.preview.api.supervisors.GlobalEdgeSupervisor;
import org.gephi.preview.updaters.LabelFontAdjuster;
import org.gephi.preview.updaters.LabelShortener;
import org.gephi.visualization.api.VisualizationController;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EdgeSupervisorImpl
implements EdgeSupervisor {
    protected Boolean curvedFlag;
    protected EdgeColorizer colorizer;
    protected Boolean showLabelsFlag;
    protected Boolean shortenLabelsFlag;
    protected Integer labelMaxChar;
    protected Font baseLabelFont;
    protected EdgeChildColorizer labelColorizer;
    protected Float edgeScale;
    protected Boolean rescaleWeight;
    protected VisualizationController visualizationController;

    public void addEdge(EdgeImpl edge) {
        float max;
        this.getSupervisedEdges().add(edge);
        this.colorEdge(edge);
        this.colorEdgeLabel(edge);
        this.updateEdgeLabelValue(edge);
        this.adjustEdgeLabelFont(edge);
        if (this.visualizationController == null) {
            this.visualizationController = (VisualizationController)Lookup.getDefault().lookup(VisualizationController.class);
        }
        float weight = edge.getThickness().floatValue();
        float min = edge.getMetaEdge() != false ? edge.getGraph().getMinMetaWeight() : edge.getGraph().getMinWeight();
        float f = max = edge.getMetaEdge() != false ? edge.getGraph().getMaxMetaWeight() : edge.getGraph().getMaxWeight();
        if (this.rescaleWeight.booleanValue()) {
            if (!Double.isInfinite(min) && !Double.isInfinite(max) && max != min) {
                float ratio = 7.6f / (max - min);
                weight = (weight - min) * ratio + 0.4f;
            }
        } else if (min <= 0.0f) {
            weight += Math.abs(min) + 1.0f;
        }
        if (edge.getMetaEdge().booleanValue() && this.visualizationController != null) {
            weight *= this.visualizationController.getMetaEdgeScale();
        }
        edge.setThickness(Float.valueOf(weight));
    }

    @Override
    public void clearSupervised() {
        this.getSupervisedEdges().clear();
    }

    public GlobalEdgeSupervisor getGlobalEdgeSupervisor() {
        PreviewController controller = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
        return controller.getModel().getGlobalEdgeSupervisor();
    }

    @Override
    public Float getEdgeScale() {
        return this.edgeScale;
    }

    @Override
    public void setEdgeScale(Float scale) {
        this.edgeScale = scale;
    }

    @Override
    public Boolean getShowFlag() {
        return this.getGlobalEdgeSupervisor().getShowFlag();
    }

    @Override
    public Boolean getCurvedFlag() {
        return this.curvedFlag;
    }

    @Override
    public void setCurvedFlag(Boolean value) {
        this.curvedFlag = value;
    }

    @Override
    public EdgeColorizer getColorizer() {
        return this.colorizer;
    }

    @Override
    public void setColorizer(EdgeColorizer value) {
        this.colorizer = value;
        this.colorEdges();
    }

    @Override
    public Boolean getShowLabelsFlag() {
        return this.showLabelsFlag;
    }

    @Override
    public void setShowLabelsFlag(Boolean value) {
        this.showLabelsFlag = value;
    }

    @Override
    public Font getBaseLabelFont() {
        return this.baseLabelFont;
    }

    @Override
    public void setBaseLabelFont(Font value) {
        this.baseLabelFont = value;
        this.adjustEdgeLabelFonts();
    }

    @Override
    public Integer getLabelMaxChar() {
        return this.labelMaxChar;
    }

    @Override
    public void setLabelMaxChar(Integer value) {
        this.labelMaxChar = value;
        this.updateEdgeLabelValues();
    }

    @Override
    public Boolean getShortenLabelsFlag() {
        return this.shortenLabelsFlag;
    }

    @Override
    public void setShortenLabelsFlag(Boolean value) {
        this.shortenLabelsFlag = value;
        this.updateEdgeLabelValues();
    }

    @Override
    public EdgeChildColorizer getLabelColorizer() {
        return this.labelColorizer;
    }

    @Override
    public void setLabelColorizer(EdgeChildColorizer value) {
        this.labelColorizer = value;
        this.colorEdgeLabels();
    }

    @Override
    public Boolean getRescaleWeight() {
        return this.rescaleWeight;
    }

    @Override
    public void setRescaleWeight(Boolean rescaleWeight) {
        this.rescaleWeight = rescaleWeight;
    }

    protected abstract Set<EdgeImpl> getSupervisedEdges();

    private void colorEdge(EdgeImpl edge) {
        this.colorizer.color(edge);
    }

    private void colorEdges() {
        for (EdgeImpl e : this.getSupervisedEdges()) {
            this.colorEdge(e);
        }
    }

    private void colorEdgeLabel(EdgeLabelImpl edgeLabel) {
        this.labelColorizer.color(edgeLabel);
    }

    private void colorEdgeLabel(EdgeImpl edge) {
        if (edge.hasLabel()) {
            this.colorEdgeLabel(edge.getLabel());
        }
    }

    private void colorEdgeLabels() {
        for (EdgeImpl e : this.getSupervisedEdges()) {
            this.colorEdgeLabel(e);
        }
    }

    private void updateEdgeLabelValue(EdgeImpl edge) {
        if (this.shortenLabelsFlag.booleanValue()) {
            this.shortenEdgeLabel(edge);
        } else {
            this.revertEdgeLabel(edge);
        }
    }

    private void updateEdgeLabelValues() {
        if (this.shortenLabelsFlag.booleanValue()) {
            this.shortenEdgeLabels();
        } else {
            this.revertEdgeLabels();
        }
    }

    private void shortenEdgeLabel(EdgeLabelImpl edgeLabel) {
        LabelShortener.shortenLabel(edgeLabel, this.labelMaxChar);
    }

    private void shortenEdgeLabel(EdgeImpl edge) {
        if (edge.hasLabel()) {
            this.shortenEdgeLabel(edge.getLabel());
        }
    }

    private void shortenEdgeLabels() {
        for (EdgeImpl e : this.getSupervisedEdges()) {
            this.shortenEdgeLabel(e);
        }
    }

    private void revertEdgeLabel(EdgeLabelImpl edgeLabel) {
        LabelShortener.revertLabel(edgeLabel);
    }

    private void revertEdgeLabel(EdgeImpl edge) {
        if (edge.hasLabel()) {
            this.revertEdgeLabel(edge.getLabel());
        }
    }

    private void revertEdgeLabels() {
        for (EdgeImpl e : this.getSupervisedEdges()) {
            this.revertEdgeLabel(e);
        }
    }

    private void adjustEdgeLabelFont(EdgeLabelImpl label) {
        LabelFontAdjuster.adjustFont(label);
    }

    private void adjustEdgeLabelFont(EdgeImpl edge) {
        if (edge.hasLabel()) {
            this.adjustEdgeLabelFont(edge.getLabel());
        }
    }

    private void adjustEdgeLabelFonts() {
        for (EdgeImpl e : this.getSupervisedEdges()) {
            this.adjustEdgeLabelFont(e);
        }
    }
}

