/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.supervisors;

import java.awt.Font;
import java.util.HashSet;
import java.util.Set;
import org.gephi.preview.NodeImpl;
import org.gephi.preview.NodeLabelBorderImpl;
import org.gephi.preview.NodeLabelImpl;
import org.gephi.preview.api.GenericColorizer;
import org.gephi.preview.api.NodeChildColorizer;
import org.gephi.preview.api.NodeColorizer;
import org.gephi.preview.api.SupervisorPropery;
import org.gephi.preview.api.supervisors.NodeSupervisor;
import org.gephi.preview.propertyeditors.GenericColorizerPropertyEditor;
import org.gephi.preview.propertyeditors.NodeChildColorizerPropertyEditor;
import org.gephi.preview.propertyeditors.NodeColorizerPropertyEditor;
import org.gephi.preview.updaters.CustomColorMode;
import org.gephi.preview.updaters.LabelFontAdjuster;
import org.gephi.preview.updaters.LabelShortener;
import org.gephi.preview.updaters.NodeOriginalColorMode;

public class NodeSupervisorImpl
implements NodeSupervisor {
    private Boolean showNodes;
    private Float nodeBorderWidth;
    private NodeColorizer nodeColorizer;
    private GenericColorizer nodeBorderColorizer;
    private Boolean showNodeLabels;
    private Font baseNodeLabelfont;
    private Boolean shortenLabelsFlag;
    private Integer nodeLabelMaxChar;
    private NodeChildColorizer nodeLabelColorizer;
    private Boolean showNodeLabelBorders;
    private NodeChildColorizer nodeLabelBorderColorizer;
    private Boolean proportionalLabelSize;
    private final Set<NodeImpl> supervisedNodes = new HashSet<NodeImpl>();

    public NodeSupervisorImpl() {
        this.defaultValues();
    }

    public void defaultValues() {
        this.showNodes = true;
        this.nodeBorderWidth = Float.valueOf(1.0f);
        this.nodeColorizer = new NodeOriginalColorMode();
        this.nodeBorderColorizer = new CustomColorMode(0, 0, 0);
        this.showNodeLabels = false;
        this.baseNodeLabelfont = new Font("SansSerif", 0, 14);
        this.shortenLabelsFlag = false;
        this.nodeLabelMaxChar = 10;
        this.nodeLabelColorizer = new CustomColorMode(0, 0, 0);
        this.showNodeLabelBorders = false;
        this.nodeLabelBorderColorizer = new CustomColorMode(255, 255, 255);
        this.proportionalLabelSize = true;
    }

    public void addNode(NodeImpl node) {
        this.supervisedNodes.add(node);
        this.colorNode(node);
        this.colorNodeLabel(node.getLabel());
        this.colorNodeLabelBorder(node.getLabelBorder());
        this.updateLabelValue(node.getLabel());
        this.adjustNodeLabelFont(node);
    }

    public void clearSupervised() {
        this.supervisedNodes.clear();
    }

    public Boolean getShowNodes() {
        return this.showNodes;
    }

    public void setShowNodes(Boolean value) {
        this.showNodes = value;
    }

    public Float getNodeBorderWidth() {
        return this.nodeBorderWidth;
    }

    public void setNodeBorderWidth(Float value) {
        this.nodeBorderWidth = value;
    }

    public NodeColorizer getNodeColorizer() {
        return this.nodeColorizer;
    }

    public void setNodeColorizer(NodeColorizer value) {
        this.nodeColorizer = value;
        this.colorNodes();
    }

    public GenericColorizer getNodeBorderColorizer() {
        return this.nodeBorderColorizer;
    }

    public void setNodeBorderColorizer(GenericColorizer value) {
        this.nodeBorderColorizer = value;
    }

    public Boolean getShowNodeLabels() {
        return this.showNodeLabels;
    }

    public void setShowNodeLabels(Boolean value) {
        this.showNodeLabels = value;
    }

    public Font getBaseNodeLabelFont() {
        return this.baseNodeLabelfont;
    }

    public void setBaseNodeLabelFont(Font value) {
        this.baseNodeLabelfont = value;
        this.adjustNodeLabelFonts();
    }

    public Integer getNodeLabelMaxChar() {
        return this.nodeLabelMaxChar;
    }

    public void setNodeLabelMaxChar(Integer value) {
        this.nodeLabelMaxChar = value;
        this.updateLabelValues();
    }

    public Boolean getShortenLabelsFlag() {
        return this.shortenLabelsFlag;
    }

    public void setShortenLabelsFlag(Boolean value) {
        this.shortenLabelsFlag = value;
        this.updateLabelValues();
    }

    public NodeChildColorizer getNodeLabelColorizer() {
        return this.nodeLabelColorizer;
    }

    public void setNodeLabelColorizer(NodeChildColorizer value) {
        this.nodeLabelColorizer = value;
        this.colorNodeLabels();
    }

    public Boolean getShowNodeLabelBorders() {
        return this.showNodeLabelBorders;
    }

    public void setShowNodeLabelBorders(Boolean value) {
        this.showNodeLabelBorders = value;
    }

    public NodeChildColorizer getNodeLabelBorderColorizer() {
        return this.nodeLabelBorderColorizer;
    }

    public void setNodeLabelBorderColorizer(NodeChildColorizer value) {
        this.nodeLabelBorderColorizer = value;
        this.colorNodeLabelBorders();
    }

    public Boolean getProportionalLabelSize() {
        return this.proportionalLabelSize;
    }

    public void setProportionalLabelSize(Boolean proportionnalLabelSize) {
        this.proportionalLabelSize = proportionnalLabelSize;
    }

    private void colorNode(NodeImpl node) {
        this.nodeColorizer.color(node);
    }

    private void colorNodes() {
        for (NodeImpl n : this.supervisedNodes) {
            this.colorNode(n);
        }
    }

    private void updateLabelValue(NodeLabelImpl nodeLabel) {
        if (nodeLabel != null) {
            if (this.shortenLabelsFlag.booleanValue()) {
                this.shortenNodeLabel(nodeLabel);
            } else {
                this.revertLabel(nodeLabel);
            }
        }
    }

    private void updateLabelValues() {
        if (this.shortenLabelsFlag.booleanValue()) {
            this.shortenNodeLabels();
        } else {
            this.revertLabels();
        }
    }

    private void shortenNodeLabel(NodeLabelImpl nodeLabel) {
        LabelShortener.shortenLabel(nodeLabel, this.nodeLabelMaxChar);
    }

    private void shortenNodeLabels() {
        for (NodeImpl n : this.supervisedNodes) {
            if (!n.hasLabel()) continue;
            this.shortenNodeLabel(n.getLabel());
        }
    }

    private void revertLabel(NodeLabelImpl nodeLabel) {
        LabelShortener.revertLabel(nodeLabel);
    }

    private void revertLabels() {
        for (NodeImpl n : this.supervisedNodes) {
            if (!n.hasLabel()) continue;
            this.revertLabel(n.getLabel());
        }
    }

    private void colorNodeLabel(NodeLabelImpl nodeLabel) {
        if (nodeLabel != null) {
            this.nodeLabelColorizer.color(nodeLabel);
        }
    }

    private void colorNodeLabels() {
        for (NodeImpl n : this.supervisedNodes) {
            if (!n.hasLabel()) continue;
            this.colorNodeLabel(n.getLabel());
        }
    }

    private void colorNodeLabelBorder(NodeLabelBorderImpl nodeLabelBorder) {
        if (nodeLabelBorder != null) {
            this.nodeLabelBorderColorizer.color(nodeLabelBorder);
        }
    }

    private void colorNodeLabelBorders() {
        for (NodeImpl n : this.supervisedNodes) {
            this.colorNodeLabelBorder(n.getLabelBorder());
        }
    }

    private void adjustNodeLabelFont(NodeLabelImpl label) {
        LabelFontAdjuster.adjustFont(label);
    }

    private void adjustNodeLabelFont(NodeImpl node) {
        if (node.hasLabel()) {
            this.adjustNodeLabelFont(node.getLabel());
        }
    }

    private void adjustNodeLabelFonts() {
        for (NodeImpl n : this.supervisedNodes) {
            this.adjustNodeLabelFont(n);
        }
    }

    public SupervisorPropery[] getProperties() {
        String CATEGORY = "Node";
        try {
            return new SupervisorPropery[]{SupervisorPropery.createProperty(this, Boolean.class, "showNodes", "Node", "Show"), SupervisorPropery.createProperty(this, Float.class, "nodeBorderWidth", "Node", "Border width"), SupervisorPropery.createProperty(this, NodeColorizer.class, "nodeColorizer", "Node", "Color", NodeColorizerPropertyEditor.class), SupervisorPropery.createProperty(this, GenericColorizer.class, "nodeBorderColorizer", "Node", "Border color", GenericColorizerPropertyEditor.class), SupervisorPropery.createProperty(this, Boolean.class, "showNodeLabels", "Node", "Show labels"), SupervisorPropery.createProperty(this, Boolean.class, "proportionalLabelSize", "Node", "Proportional label size"), SupervisorPropery.createProperty(this, Font.class, "baseNodeLabelFont", "Node", "Label font"), SupervisorPropery.createProperty(this, Boolean.class, "shortenLabelsFlag", "Node", "Shorten labels"), SupervisorPropery.createProperty(this, Integer.class, "nodeLabelMaxChar", "Node", "Shorten limit"), SupervisorPropery.createProperty(this, NodeChildColorizer.class, "nodeLabelColorizer", "Node", "Label color", NodeChildColorizerPropertyEditor.class), SupervisorPropery.createProperty(this, Boolean.class, "showNodeLabelBorders", "Node", "Label border"), SupervisorPropery.createProperty(this, NodeChildColorizer.class, "nodeLabelBorderColorizer", "Node", "Label Border Color", NodeChildColorizerPropertyEditor.class)};
        }
        catch (Exception e) {
            e.printStackTrace();
            return new SupervisorPropery[0];
        }
    }
}

