/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.supervisors;

import java.util.HashSet;
import java.util.Set;
import org.gephi.preview.SelfLoopImpl;
import org.gephi.preview.api.EdgeColorizer;
import org.gephi.preview.api.SupervisorPropery;
import org.gephi.preview.api.supervisors.SelfLoopSupervisor;
import org.gephi.preview.propertyeditors.EdgeColorizerPropertyEditor;
import org.gephi.preview.updaters.CustomColorMode;

public class SelfLoopSupervisorImpl
implements SelfLoopSupervisor {
    private Boolean show;
    private EdgeColorizer colorizer;
    private Float edgeScale;
    protected Boolean rescaleWeight;
    private final Set<SelfLoopImpl> supervisedSelfLoops = new HashSet<SelfLoopImpl>();

    public SelfLoopSupervisorImpl() {
        this.defaultValues();
    }

    public Boolean getRescaleWeight() {
        return this.rescaleWeight;
    }

    public void setRescaleWeight(Boolean rescaleWeight) {
        this.rescaleWeight = rescaleWeight;
    }

    public void defaultValues() {
        this.show = true;
        this.colorizer = new CustomColorMode(0, 0, 0);
        this.edgeScale = new Float(1.0f);
        this.rescaleWeight = Boolean.FALSE;
    }

    public Float getEdgeScale() {
        return this.edgeScale;
    }

    public void setEdgeScale(Float edgeScale) {
        this.edgeScale = edgeScale;
    }

    public void addSelfLoop(SelfLoopImpl edge) {
        this.supervisedSelfLoops.add(edge);
        float weight = edge.getThickness().floatValue();
        float min = edge.getGraph().getMinWeight();
        float max = edge.getGraph().getMaxWeight();
        if (this.rescaleWeight.booleanValue()) {
            if (!Double.isInfinite(min) && !Double.isInfinite(max) && max != min) {
                float ratio = 7.6f / (max - min);
                weight = (weight - min) * ratio + 0.4f;
            }
        } else if (min <= 0.0f) {
            weight += Math.abs(min) + 1.0f;
        }
        edge.setThickness(Float.valueOf(weight));
        this.colorSelfLoops();
    }

    public void clearSupervised() {
        this.supervisedSelfLoops.clear();
    }

    public Boolean getShowFlag() {
        return this.show;
    }

    public void setShowFlag(Boolean value) {
        this.show = value;
    }

    public EdgeColorizer getColorizer() {
        return this.colorizer;
    }

    public void setColorizer(EdgeColorizer value) {
        this.colorizer = value;
        this.colorSelfLoops();
    }

    private void colorSelfLoop(SelfLoopImpl selfLoop) {
        this.colorizer.color(selfLoop);
    }

    private void colorSelfLoops() {
        for (SelfLoopImpl sl : this.supervisedSelfLoops) {
            this.colorSelfLoop(sl);
        }
    }

    public SupervisorPropery[] getProperties() {
        String CATEGORY = "Self-Loop";
        try {
            return new SupervisorPropery[]{SupervisorPropery.createProperty(this, Boolean.class, "SelfLoop_showFlag", "Self-Loop", "Show", "getShowFlag", "setShowFlag"), SupervisorPropery.createProperty(this, Float.class, "SelfLoop_edgeScale", "Self-Loop", "Thickness", "getEdgeScale", "setEdgeScale"), SupervisorPropery.createProperty(this, Boolean.class, "SelfLoop_rescaleWeight", "Self-Loop", "Rescale Weight", "getRescaleWeight", "setRescaleWeight"), SupervisorPropery.createProperty(this, EdgeColorizer.class, "SelfLoop_colorizer", "Self-Loop", "Color", "getColorizer", "setColorizer", EdgeColorizerPropertyEditor.class)};
        }
        catch (Exception e) {
            e.printStackTrace();
            return new SupervisorPropery[0];
        }
    }
}

