/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.util.color;

import org.gephi.preview.api.Color;
import org.gephi.preview.api.util.Holder;
import org.gephi.preview.util.color.SimpleColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixedColor
implements Color {
    private final Holder<Color> colorHolder1;
    private final Holder<Color> colorHolder2;

    public MixedColor(Holder<Color> colorHolder1, Holder<Color> colorHolder2) {
        this.colorHolder1 = colorHolder1;
        this.colorHolder2 = colorHolder2;
    }

    @Override
    public Integer getRed() {
        Color c1 = this.colorHolder1.getComponent();
        Color c2 = this.colorHolder2.getComponent();
        return (c1.getRed() + c2.getRed()) / 2;
    }

    @Override
    public Integer getGreen() {
        Color c1 = this.colorHolder1.getComponent();
        Color c2 = this.colorHolder2.getComponent();
        return (c1.getGreen() + c2.getGreen()) / 2;
    }

    @Override
    public Integer getBlue() {
        Color c1 = this.colorHolder1.getComponent();
        Color c2 = this.colorHolder2.getComponent();
        return (c1.getBlue() + c2.getBlue()) / 2;
    }

    @Override
    public String toHexString() {
        SimpleColor c = new SimpleColor(this.getRed(), this.getGreen(), this.getBlue());
        return c.toHexString();
    }
}

