/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Projects;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceInformation;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.project.api.WorkspaceProvider;
import org.gephi.project.impl.ProjectImpl;
import org.gephi.project.impl.ProjectInformationImpl;
import org.gephi.project.impl.ProjectsImpl;
import org.gephi.project.impl.WorkspaceProviderImpl;
import org.gephi.project.io.LoadTask;
import org.gephi.project.io.SaveTask;
import org.gephi.project.spi.WorkspaceDuplicateProvider;
import org.gephi.workspace.impl.WorkspaceImpl;
import org.gephi.workspace.impl.WorkspaceInformationImpl;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class ProjectControllerImpl
implements ProjectController {
    private final ProjectsImpl projects = new ProjectsImpl();
    private final List<WorkspaceListener> listeners = new ArrayList<WorkspaceListener>();

    public ProjectControllerImpl() {
        this.listeners.addAll(Lookup.getDefault().lookupAll(WorkspaceListener.class));
    }

    public void startup() {
        String OPEN_LAST_PROJECT_ON_STARTUP = "Open_Last_Project_On_Startup";
        String NEW_PROJECT_ON_STARTUP = "New_Project_On_Startup";
        boolean openLastProject = NbPreferences.forModule(ProjectControllerImpl.class).getBoolean("Open_Last_Project_On_Startup", false);
        boolean newProjectStartup = NbPreferences.forModule(ProjectControllerImpl.class).getBoolean("New_Project_On_Startup", false);
        if (!openLastProject && newProjectStartup) {
            this.newProject();
        }
    }

    public void newProject() {
        this.closeCurrentProject();
        ProjectImpl project = new ProjectImpl();
        this.projects.addProject(project);
        this.openProject(project);
    }

    public Runnable openProject(File file) {
        return new LoadTask(file);
    }

    public Runnable saveProject(Project project) {
        if (((ProjectInformationImpl)project.getLookup().lookup(ProjectInformationImpl.class)).hasFile()) {
            File file = ((ProjectInformationImpl)project.getLookup().lookup(ProjectInformationImpl.class)).getFile();
            return this.saveProject(project, file);
        }
        return null;
    }

    public Runnable saveProject(Project project, File file) {
        ((ProjectInformationImpl)project.getLookup().lookup(ProjectInformationImpl.class)).setFile(file);
        SaveTask saveTask = new SaveTask(project, file);
        return saveTask;
    }

    public void closeCurrentProject() {
        if (this.projects.hasCurrentProject()) {
            ProjectImpl currentProject = this.projects.getCurrentProject();
            if (((WorkspaceProvider)currentProject.getLookup().lookup(WorkspaceProvider.class)).hasCurrentWorkspace()) {
                this.fireWorkspaceEvent(EventType.UNSELECT, ((WorkspaceProvider)currentProject.getLookup().lookup(WorkspaceProvider.class)).getCurrentWorkspace());
            }
            for (Workspace ws : ((WorkspaceProviderImpl)currentProject.getLookup().lookup(WorkspaceProviderImpl.class)).getWorkspaces()) {
                this.fireWorkspaceEvent(EventType.CLOSE, ws);
            }
            ((ProjectInformationImpl)currentProject.getLookup().lookup(ProjectInformationImpl.class)).close();
            this.projects.closeCurrentProject();
            this.fireWorkspaceEvent(EventType.DISABLE, null);
        }
    }

    public void removeProject(Project project) {
        if (this.projects.getCurrentProject() == project) {
            this.closeCurrentProject();
        }
        this.projects.removeProject(project);
    }

    public Projects getProjects() {
        return this.projects;
    }

    public void setProjects(Projects projects) {
        String OPEN_LAST_PROJECT_ON_STARTUP = "Open_Last_Project_On_Startup";
        boolean openLastProject = NbPreferences.forModule(ProjectControllerImpl.class).getBoolean("Open_Last_Project_On_Startup", false);
        Project lastOpenProject = null;
        for (Project p : ((ProjectsImpl)projects).getProjects()) {
            if (!((ProjectInformationImpl)p.getLookup().lookup(ProjectInformationImpl.class)).hasFile()) continue;
            ProjectImpl pImpl = (ProjectImpl)p;
            pImpl.init();
            this.projects.addProject(p);
            ((ProjectInformationImpl)pImpl.getLookup().lookup(ProjectInformationImpl.class)).close();
            if (p != projects.getCurrentProject()) continue;
            lastOpenProject = p;
        }
        if (openLastProject && lastOpenProject != null && !((ProjectInformationImpl)lastOpenProject.getLookup().lookup(ProjectInformationImpl.class)).isInvalid() && ((ProjectInformationImpl)lastOpenProject.getLookup().lookup(ProjectInformationImpl.class)).hasFile()) {
            this.openProject(lastOpenProject);
        }
    }

    public Workspace newWorkspace(Project project) {
        WorkspaceImpl workspace = ((WorkspaceProviderImpl)project.getLookup().lookup(WorkspaceProviderImpl.class)).newWorkspace();
        this.fireWorkspaceEvent(EventType.INITIALIZE, workspace);
        return workspace;
    }

    public void deleteWorkspace(Workspace workspace) {
        WorkspaceInformation wi = (WorkspaceInformation)workspace.getLookup().lookup(WorkspaceInformation.class);
        WorkspaceProviderImpl workspaceProvider = (WorkspaceProviderImpl)wi.getProject().getLookup().lookup(WorkspaceProviderImpl.class);
        Workspace toSelectWorkspace = null;
        if (this.getCurrentWorkspace() == workspace) {
            toSelectWorkspace = workspaceProvider.getPrecedingWorkspace(workspace);
        }
        workspaceProvider.removeWorkspace(workspace);
        this.fireWorkspaceEvent(EventType.CLOSE, workspace);
        if (this.getCurrentWorkspace() == workspace) {
            if (toSelectWorkspace == null) {
                this.closeCurrentProject();
            } else {
                this.openWorkspace(toSelectWorkspace);
            }
        }
    }

    public void openProject(Project project) {
        ProjectImpl projectImpl = (ProjectImpl)project;
        ProjectInformationImpl projectInformationImpl = (ProjectInformationImpl)projectImpl.getLookup().lookup(ProjectInformationImpl.class);
        WorkspaceProviderImpl workspaceProviderImpl = (WorkspaceProviderImpl)project.getLookup().lookup(WorkspaceProviderImpl.class);
        if (this.projects.hasCurrentProject()) {
            this.closeCurrentProject();
        }
        this.projects.addProject(projectImpl);
        this.projects.setCurrentProject(projectImpl);
        projectInformationImpl.open();
        if (!workspaceProviderImpl.hasCurrentWorkspace()) {
            if (workspaceProviderImpl.getWorkspaces().length == 0) {
                Workspace workspace = this.newWorkspace(project);
                this.openWorkspace(workspace);
            } else {
                Workspace workspace = workspaceProviderImpl.getWorkspaces()[0];
                this.openWorkspace(workspace);
            }
        } else {
            this.fireWorkspaceEvent(EventType.SELECT, workspaceProviderImpl.getCurrentWorkspace());
        }
    }

    public ProjectImpl getCurrentProject() {
        return this.projects.getCurrentProject();
    }

    public WorkspaceImpl getCurrentWorkspace() {
        if (this.projects.hasCurrentProject()) {
            return ((WorkspaceProviderImpl)this.getCurrentProject().getLookup().lookup(WorkspaceProviderImpl.class)).getCurrentWorkspace();
        }
        return null;
    }

    public void closeCurrentWorkspace() {
        WorkspaceImpl workspace = this.getCurrentWorkspace();
        if (workspace != null) {
            ((WorkspaceInformationImpl)workspace.getLookup().lookup(WorkspaceInformationImpl.class)).close();
            this.fireWorkspaceEvent(EventType.UNSELECT, workspace);
        }
    }

    public void openWorkspace(Workspace workspace) {
        this.closeCurrentWorkspace();
        ((WorkspaceProviderImpl)this.getCurrentProject().getLookup().lookup(WorkspaceProviderImpl.class)).setCurrentWorkspace(workspace);
        ((WorkspaceInformationImpl)workspace.getLookup().lookup(WorkspaceInformationImpl.class)).open();
        this.fireWorkspaceEvent(EventType.SELECT, workspace);
    }

    public void cleanWorkspace(Workspace workspace) {
    }

    public Workspace duplicateWorkspace(Workspace workspace) {
        if (this.projects.hasCurrentProject()) {
            Workspace duplicate = this.newWorkspace(this.projects.getCurrentProject());
            for (WorkspaceDuplicateProvider dp : Lookup.getDefault().lookupAll(WorkspaceDuplicateProvider.class)) {
                dp.duplicate(workspace, duplicate);
            }
            this.openWorkspace(duplicate);
            return duplicate;
        }
        return null;
    }

    public void renameProject(Project project, String name) {
        ((ProjectInformationImpl)project.getLookup().lookup(ProjectInformationImpl.class)).setName(name);
    }

    public void renameWorkspace(Workspace workspace, String name) {
        ((WorkspaceInformationImpl)workspace.getLookup().lookup(WorkspaceInformationImpl.class)).setName(name);
    }

    public void setSource(Workspace workspace, String source) {
        ((WorkspaceInformationImpl)workspace.getLookup().lookup(WorkspaceInformationImpl.class)).setSource(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkspaceListener(WorkspaceListener workspaceListener) {
        List<WorkspaceListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(workspaceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWorkspaceListener(WorkspaceListener workspaceListener) {
        List<WorkspaceListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(workspaceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWorkspaceEvent(EventType event, Workspace workspace) {
        WorkspaceListener[] listenersArray;
        List<WorkspaceListener> list = this.listeners;
        synchronized (list) {
            listenersArray = this.listeners.toArray(new WorkspaceListener[0]);
        }
        block10: for (WorkspaceListener wl : listenersArray) {
            switch (event) {
                case INITIALIZE: {
                    wl.initialize(workspace);
                    continue block10;
                }
                case SELECT: {
                    wl.select(workspace);
                    continue block10;
                }
                case UNSELECT: {
                    wl.unselect(workspace);
                    continue block10;
                }
                case CLOSE: {
                    wl.close(workspace);
                    continue block10;
                }
                case DISABLE: {
                    wl.disable();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EventType {
        INITIALIZE,
        SELECT,
        UNSELECT,
        CLOSE,
        DISABLE;

    }
}

