/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectInformation;

public class ProjectInformationImpl
implements ProjectInformation {
    private static int count = 0;
    private String name;
    private Status status = Status.CLOSED;
    private File file;
    private Project project;
    private transient List<ChangeListener> listeners;

    public ProjectInformationImpl(Project project) {
        this.project = project;
        this.name = "Project " + count++;
        this.init();
    }

    public void init() {
        this.listeners = new ArrayList<ChangeListener>();
        this.status = Status.CLOSED;
        if (this.file != null) {
            // empty if block
        }
    }

    public void open() {
        this.status = Status.OPEN;
        this.fireChangeEvent();
    }

    public void close() {
        this.status = Status.CLOSED;
        this.fireChangeEvent();
    }

    public Project getProject() {
        return this.project;
    }

    public boolean isOpen() {
        return this.status == Status.OPEN;
    }

    public boolean isClosed() {
        return this.status == Status.CLOSED;
    }

    public boolean isInvalid() {
        return this.status == Status.INVALID;
    }

    public boolean hasFile() {
        return this.file != null;
    }

    public String getFileName() {
        if (this.file == null) {
            return "";
        }
        return this.file.getName();
    }

    public void setName(String name) {
        this.name = name;
        this.fireChangeEvent();
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.fireChangeEvent();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NEW,
        OPEN,
        CLOSED,
        INVALID;

    }
}

