/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.io;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.gephi.project.api.Project;
import org.gephi.project.api.Workspace;
import org.gephi.project.impl.ProjectImpl;
import org.gephi.project.impl.ProjectInformationImpl;
import org.gephi.project.impl.WorkspaceProviderImpl;
import org.gephi.project.spi.WorkspacePersistenceProvider;
import org.gephi.workspace.impl.WorkspaceImpl;
import org.gephi.workspace.impl.WorkspaceInformationImpl;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GephiReader
implements Cancellable {
    private ProjectImpl project;
    private boolean cancel = false;
    private Map<String, WorkspacePersistenceProvider> providers = new LinkedHashMap<String, WorkspacePersistenceProvider>();

    public GephiReader() {
        for (WorkspacePersistenceProvider w : Lookup.getDefault().lookupAll(WorkspacePersistenceProvider.class)) {
            try {
                String id = w.getIdentifier();
                if (id == null || id.isEmpty()) continue;
                this.providers.put(w.getIdentifier(), w);
            }
            catch (Exception exception) {}
        }
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public Project readAll(Element root, Project project) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        this.readCore(xpath, root);
        this.project = (ProjectImpl)project;
        XPathExpression exp = xpath.compile("./project");
        Element projectE = (Element)exp.evaluate(root, XPathConstants.NODE);
        this.readProject(xpath, projectE);
        return project;
    }

    public void readCore(XPath xpath, Element root) throws Exception {
        XPathExpression exp = xpath.compile("./core");
        Element coreE = (Element)exp.evaluate(root, XPathConstants.NODE);
        int max = Integer.parseInt(coreE.getAttribute("tasks"));
    }

    public void readProject(XPath xpath, Element projectE) throws Exception {
        ProjectInformationImpl info = (ProjectInformationImpl)this.project.getLookup().lookup(ProjectInformationImpl.class);
        WorkspaceProviderImpl workspaces = (WorkspaceProviderImpl)this.project.getLookup().lookup(WorkspaceProviderImpl.class);
        info.setName(projectE.getAttribute("name"));
        XPathExpression exp = xpath.compile("./workspaces/workspace");
        NodeList workSpaceList = (NodeList)exp.evaluate(projectE, XPathConstants.NODESET);
        for (int i = 0; i < workSpaceList.getLength() && !this.cancel; ++i) {
            Element workspaceE = (Element)workSpaceList.item(i);
            Workspace workspace = this.readWorkspace(xpath, workspaceE);
            if (!((WorkspaceInformationImpl)workspace.getLookup().lookup(WorkspaceInformationImpl.class)).isOpen()) continue;
            workspaces.setCurrentWorkspace(workspace);
        }
    }

    public Workspace readWorkspace(XPath xpath, Element workspaceE) throws Exception {
        WorkspaceImpl workspace = ((WorkspaceProviderImpl)this.project.getLookup().lookup(WorkspaceProviderImpl.class)).newWorkspace();
        WorkspaceInformationImpl info = (WorkspaceInformationImpl)workspace.getLookup().lookup(WorkspaceInformationImpl.class);
        info.setName(workspaceE.getAttribute("name"));
        String workspaceStatus = workspaceE.getAttribute("status");
        if (workspaceStatus.equals("open")) {
            info.open();
        } else if (workspaceStatus.equals("closed")) {
            info.close();
        } else {
            info.invalid();
        }
        this.readWorkspaceChildren(workspace, workspaceE);
        return workspace;
    }

    public void readWorkspaceChildren(Workspace workspace, Element workspaceE) throws Exception {
        NodeList children = workspaceE.getChildNodes();
        for (int i = 0; i < children.getLength() && !this.cancel; ++i) {
            Element childE;
            WorkspacePersistenceProvider pp;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || (pp = this.providers.get((childE = (Element)child).getTagName())) == null) continue;
            try {
                pp.readXML(childE, workspace);
                continue;
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
    }
}

