/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.io;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectInformation;
import org.gephi.project.api.ProjectMetaData;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceInformation;
import org.gephi.project.impl.WorkspaceProviderImpl;
import org.gephi.project.spi.WorkspacePersistenceProvider;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GephiWriter
implements Cancellable {
    private int tasks = 0;
    private Document doc;
    private Map<String, WorkspacePersistenceProvider> providers = new LinkedHashMap<String, WorkspacePersistenceProvider>();

    public GephiWriter() {
        for (WorkspacePersistenceProvider w : Lookup.getDefault().lookupAll(WorkspacePersistenceProvider.class)) {
            try {
                String id = w.getIdentifier();
                if (id == null || id.isEmpty()) continue;
                this.providers.put(w.getIdentifier(), w);
            }
            catch (Exception exception) {}
        }
    }

    private Document createDocument() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        document.setXmlVersion("1.0");
        document.setXmlStandalone(true);
        return document;
    }

    public Document writeAll(Project project) throws Exception {
        this.doc = this.createDocument();
        Element root = this.writeCore();
        Element projectE = this.writeProject(project);
        root.appendChild(projectE);
        this.doc.appendChild(root);
        return this.doc;
    }

    public Element writeCore() throws Exception {
        Element root = this.doc.createElement("gephiFile");
        root.setAttribute("version", "0.7");
        root.appendChild(this.doc.createComment("File saved from Gephi 0.7"));
        Element core = this.doc.createElement("core");
        core.setAttribute("tasks", String.valueOf(this.tasks));
        Element lastModifiedDate = this.doc.createElement("lastModifiedDate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        lastModifiedDate.setTextContent(sdf.format(cal.getTime()));
        lastModifiedDate.appendChild(this.doc.createComment("yyyy-MM-dd HH:mm:ss"));
        core.appendChild(lastModifiedDate);
        root.appendChild(core);
        return root;
    }

    public Element writeProject(Project project) throws Exception {
        ProjectInformation info = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        ProjectMetaData metaData = (ProjectMetaData)project.getLookup().lookup(ProjectMetaData.class);
        WorkspaceProviderImpl workspaces = (WorkspaceProviderImpl)project.getLookup().lookup(WorkspaceProviderImpl.class);
        Element projectE = this.doc.createElement("project");
        projectE.setAttribute("name", info.getName());
        Element projectMetaDataE = this.doc.createElement("metadata");
        Element titleE = this.doc.createElement("title");
        titleE.setTextContent(metaData.getTitle());
        Element keywordsE = this.doc.createElement("keywords");
        keywordsE.setTextContent(metaData.getKeywords());
        Element descriptionE = this.doc.createElement("description");
        descriptionE.setTextContent(metaData.getDescription());
        Element authorE = this.doc.createElement("author");
        authorE.setTextContent(metaData.getAuthor());
        projectMetaDataE.appendChild(titleE);
        projectMetaDataE.appendChild(authorE);
        projectMetaDataE.appendChild(keywordsE);
        projectMetaDataE.appendChild(descriptionE);
        projectE.appendChild(projectMetaDataE);
        Element workspacesE = this.doc.createElement("workspaces");
        for (Workspace ws : workspaces.getWorkspaces()) {
            workspacesE.appendChild(this.writeWorkspace(ws));
        }
        projectE.appendChild(workspacesE);
        return projectE;
    }

    public Element writeWorkspace(Workspace workspace) throws Exception {
        WorkspaceInformation info = (WorkspaceInformation)workspace.getLookup().lookup(WorkspaceInformation.class);
        Element workspaceE = this.doc.createElement("workspace");
        workspaceE.setAttribute("name", info.getName());
        if (info.isOpen()) {
            workspaceE.setAttribute("status", "open");
        } else if (info.isClosed()) {
            workspaceE.setAttribute("status", "closed");
        } else {
            workspaceE.setAttribute("status", "invalid");
        }
        this.writeWorkspaceChildren(workspace, workspaceE);
        return workspaceE;
    }

    public void writeWorkspaceChildren(Workspace workspace, Element workspaceE) {
        for (WorkspacePersistenceProvider pp : this.providers.values()) {
            Element childE = null;
            try {
                childE = pp.writeXML(this.doc, workspace);
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            if (childE == null) continue;
            workspaceE.appendChild(this.doc.createComment("Persistence from " + pp.getClass().getName()));
            workspaceE.appendChild(childE);
        }
    }

    public boolean cancel() {
        return true;
    }
}

