/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.io;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gephi.project.api.Project;
import org.gephi.project.impl.ProjectControllerImpl;
import org.gephi.project.impl.ProjectImpl;
import org.gephi.project.impl.ProjectInformationImpl;
import org.gephi.project.io.GephiFormatException;
import org.gephi.project.io.GephiReader;
import org.gephi.project.io.SaveTask;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;

public class LoadTask
implements LongTask,
Runnable {
    private File file;
    private GephiReader gephiReader;
    private boolean cancel = false;
    private ProgressTicket progressTicket;

    public LoadTask(File file) {
        this.file = file;
    }

    public void run() {
        try {
            Progress.start(this.progressTicket);
            Progress.setDisplayName(this.progressTicket, NbBundle.getMessage(SaveTask.class, (String)"LoadTask.name"));
            FileObject fileObject = FileUtil.toFileObject((File)this.file);
            if (FileUtil.isArchiveFile((FileObject)fileObject)) {
                fileObject = FileUtil.getArchiveRoot((FileObject)fileObject).getChildren()[0];
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(fileObject.getInputStream());
            if (!this.cancel) {
                Project project = new ProjectImpl();
                ((ProjectInformationImpl)project.getLookup().lookup(ProjectInformationImpl.class)).setFile(this.file);
                String version = doc.getDocumentElement().getAttribute("version");
                if (version == null || version.isEmpty() || Double.parseDouble(version) != 0.7) {
                    throw new GephiFormatException("Gephi project file version must be at least 0.7");
                }
                this.gephiReader = new GephiReader();
                project = this.gephiReader.readAll(doc.getDocumentElement(), project);
                if (!this.cancel) {
                    ProjectControllerImpl pc = (ProjectControllerImpl)Lookup.getDefault().lookup(ProjectControllerImpl.class);
                    pc.openProject(project);
                }
            }
            Progress.finish(this.progressTicket);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (ex instanceof GephiFormatException) {
                throw (GephiFormatException)ex;
            }
            throw new GephiFormatException(GephiReader.class, (Throwable)ex);
        }
    }

    public boolean cancel() {
        this.cancel = true;
        if (this.gephiReader != null) {
            this.gephiReader.cancel();
        }
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }
}

