/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gephi.project.api.Project;
import org.gephi.project.io.GephiFormatException;
import org.gephi.project.io.GephiWriter;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.w3c.dom.Document;

public class SaveTask
implements LongTask,
Runnable {
    private static final String ZIP_LEVEL_PREFERENCE = "ProjectIO_Save_ZipLevel_0_TO_9";
    private File file;
    private Project project;
    private GephiWriter gephiWriter;
    private boolean cancel = false;
    private ProgressTicket progressTicket;

    public SaveTask(Project project, File file) {
        this.project = project;
        this.file = file;
    }

    public void run() {
        ZipOutputStream zipOut = null;
        boolean useTempFile = false;
        File writeFile = null;
        try {
            Progress.start(this.progressTicket);
            Progress.setDisplayName(this.progressTicket, NbBundle.getMessage(SaveTask.class, (String)"SaveTask.name"));
            FileObject fileObject = FileUtil.toFileObject((File)this.file);
            writeFile = this.file;
            if (writeFile.exists()) {
                useTempFile = true;
                String tempFileName = writeFile.getName() + "_temp";
                writeFile = new File(writeFile.getParent(), tempFileName);
            }
            int zipLevel = NbPreferences.forModule(SaveTask.class).getInt(ZIP_LEVEL_PREFERENCE, 9);
            FileOutputStream outputStream = new FileOutputStream(writeFile);
            zipOut = new ZipOutputStream(outputStream);
            zipOut.setLevel(zipLevel);
            zipOut.putNextEntry(new ZipEntry("Project"));
            this.gephiWriter = new GephiWriter();
            Document document = this.gephiWriter.writeAll(this.project);
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(zipOut);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, result);
            zipOut.closeEntry();
            zipOut.finish();
            zipOut.close();
            if (useTempFile && !this.cancel) {
                String name = fileObject.getName();
                String ext = fileObject.getExt();
                fileObject.delete();
                FileObject tempFileObject = FileUtil.toFileObject((File)writeFile);
                FileLock lock = tempFileObject.lock();
                tempFileObject.rename(lock, name, ext);
                lock.releaseLock();
            } else if (this.cancel) {
                FileObject tempFileObject = FileUtil.toFileObject((File)writeFile);
                tempFileObject.delete();
            }
            Progress.finish(this.progressTicket);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (zipOut != null) {
                try {
                    zipOut.close();
                }
                catch (IOException ex1) {
                    // empty catch block
                }
            }
            if (useTempFile && writeFile != null) {
                writeFile.delete();
            }
            throw new GephiFormatException(GephiWriter.class, (Throwable)ex);
        }
    }

    public boolean cancel() {
        if (this.gephiWriter != null) {
            this.gephiWriter.cancel();
        }
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }
}

