/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ranking.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.gephi.ranking.api.Transformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RankingUIModel {
    public static final int NODE_RANKING = 1;
    public static final int EDGE_RANKING = 2;
    protected int ranking = 1;
    protected boolean barChartVisible = false;
    protected boolean listVisible = false;
    protected Class nodeTransformer;
    protected Class edgeTransformer;
    protected List<Transformer> nodeTransformers;
    protected List<Transformer> edgeTransformers;
    protected String selectedNodeRanking;
    protected String selectedEdgeRanking;
    protected List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    public RankingUIModel() {
        this.nodeTransformers = new ArrayList<Transformer>();
        this.edgeTransformers = new ArrayList<Transformer>();
    }

    public Class getNodeTransformer() {
        return this.nodeTransformer;
    }

    public Class getEdgeTransformer() {
        return this.edgeTransformer;
    }

    public String getSelectedEdgeRanking() {
        return this.selectedEdgeRanking;
    }

    public String getSelectedNodeRanking() {
        return this.selectedNodeRanking;
    }

    public void setNodeTransformer(Class nodeTransformer) {
        if (this.nodeTransformer != null && this.nodeTransformer.equals(nodeTransformer)) {
            return;
        }
        Class oldValue = this.nodeTransformer;
        this.nodeTransformer = nodeTransformer;
        this.firePropertyChangeEvent("nodeTransformer", oldValue, nodeTransformer);
    }

    public void setEdgeTransformer(Class edgeTransformer) {
        if (this.edgeTransformer != null && this.edgeTransformer.equals(edgeTransformer)) {
            return;
        }
        Class oldValue = this.edgeTransformer;
        this.edgeTransformer = edgeTransformer;
        this.firePropertyChangeEvent("edgeTransformer", oldValue, edgeTransformer);
    }

    public void setSelectedEdgeRanking(String selectedEdgeRanking) {
        if (this.selectedEdgeRanking != null && this.selectedEdgeRanking.equals(selectedEdgeRanking)) {
            return;
        }
        if (this.selectedEdgeRanking == null && selectedEdgeRanking == null) {
            return;
        }
        String oldValue = this.selectedEdgeRanking;
        this.selectedEdgeRanking = selectedEdgeRanking;
        this.firePropertyChangeEvent("selectedEdgeRanking", oldValue, selectedEdgeRanking);
    }

    public void setSelectedNodeRanking(String selectedNodeRanking) {
        if (this.selectedNodeRanking != null && this.selectedNodeRanking.equals(selectedNodeRanking)) {
            return;
        }
        if (this.selectedNodeRanking == null && selectedNodeRanking == null) {
            return;
        }
        String oldValue = this.selectedNodeRanking;
        this.selectedNodeRanking = selectedNodeRanking;
        this.firePropertyChangeEvent("selectedNodeRanking", oldValue, selectedNodeRanking);
    }

    public Transformer getSelectedNodeTransformer() {
        if (this.nodeTransformer != null) {
            for (Transformer t : this.nodeTransformers) {
                if (!this.nodeTransformer.isAssignableFrom(t.getClass())) continue;
                return t;
            }
        }
        return null;
    }

    public Transformer getSelectedEdgeTransformer() {
        if (this.edgeTransformer != null) {
            for (Transformer t : this.edgeTransformers) {
                if (!this.edgeTransformer.isAssignableFrom(t.getClass())) continue;
                return t;
            }
        }
        return null;
    }

    public void addNodeTransformer(Transformer transformer) {
        this.nodeTransformers.add(transformer);
    }

    public void addEdgeTransformer(Transformer transformer) {
        this.edgeTransformers.add(transformer);
    }

    public void resetNodeTransformers() {
        this.nodeTransformers.clear();
    }

    public void resetEdgeTransformers() {
        this.edgeTransformers.clear();
    }

    public int getRanking() {
        return this.ranking;
    }

    public boolean isBarChartVisible() {
        return this.barChartVisible;
    }

    public boolean isListVisible() {
        return this.listVisible;
    }

    public RankingUIModel saveModel() {
        RankingUIModel save = new RankingUIModel();
        save.barChartVisible = this.barChartVisible;
        save.edgeTransformer = this.edgeTransformer;
        save.listVisible = this.listVisible;
        save.nodeTransformer = this.nodeTransformer;
        save.ranking = this.ranking;
        save.selectedNodeRanking = this.selectedNodeRanking;
        save.selectedEdgeRanking = this.selectedEdgeRanking;
        save.nodeTransformers.addAll(this.nodeTransformers);
        save.edgeTransformers.addAll(this.edgeTransformers);
        return save;
    }

    public void loadModel(RankingUIModel model) {
        this.nodeTransformers.clear();
        this.edgeTransformers.clear();
        this.nodeTransformers.addAll(model.nodeTransformers);
        this.edgeTransformers.addAll(model.edgeTransformers);
        this.setBarChartVisible(model.barChartVisible);
        this.setListVisible(model.listVisible);
        this.setNodeTransformer(model.nodeTransformer);
        this.setEdgeTransformer(model.edgeTransformer);
        this.setRanking(model.ranking);
        this.setSelectedEdgeRanking(model.selectedEdgeRanking);
        this.setSelectedNodeRanking(model.selectedNodeRanking);
    }

    public void setListVisible(boolean listVisible) {
        if (this.listVisible == listVisible) {
            return;
        }
        boolean oldValue = this.listVisible;
        this.listVisible = listVisible;
        this.firePropertyChangeEvent("listVisible", oldValue, listVisible);
    }

    public void setBarChartVisible(boolean barChartVisible) {
        if (this.barChartVisible == barChartVisible) {
            return;
        }
        boolean oldValue = this.barChartVisible;
        this.barChartVisible = barChartVisible;
        this.firePropertyChangeEvent("barChartVisible", oldValue, barChartVisible);
    }

    public void setRanking(int ranking) {
        if (ranking != 1 && ranking != 2) {
            throw new IllegalArgumentException("Ranking must be NODE_RANKING or EDGE_RANKING");
        }
        if (this.ranking == ranking) {
            return;
        }
        int oldValue = this.ranking;
        this.ranking = ranking;
        this.firePropertyChangeEvent("ranking", oldValue, ranking);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void firePropertyChangeEvent(String propertyName, Object beforeValue, Object afterValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, beforeValue, afterValue);
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(event);
        }
    }

    public void readXML(Element modelElement) {
        Element rankingE = (Element)modelElement.getElementsByTagName("ranking").item(0);
        this.ranking = Integer.parseInt(rankingE.getTextContent());
        Element barchartvisibleE = (Element)modelElement.getElementsByTagName("barchartvisible").item(0);
        this.barChartVisible = Boolean.parseBoolean(barchartvisibleE.getTextContent());
        Element listvisibleE = (Element)modelElement.getElementsByTagName("listvisible").item(0);
        this.listVisible = Boolean.parseBoolean(listvisibleE.getTextContent());
    }

    public Element writeXML(Document document) {
        Element rankingModelE = document.createElement("rankinguimodel");
        Element rankingE = document.createElement("ranking");
        rankingE.setTextContent(String.valueOf(this.ranking));
        rankingModelE.appendChild(rankingE);
        Element barChartE = document.createElement("barchartvisible");
        barChartE.setTextContent(String.valueOf(this.barChartVisible));
        rankingModelE.appendChild(barChartE);
        Element listE = document.createElement("listvisible");
        listE.setTextContent(String.valueOf(this.listVisible));
        rankingModelE.appendChild(barChartE);
        return rankingModelE;
    }
}

