/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ranking.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.Node;
import org.gephi.ranking.api.ColorTransformer;
import org.gephi.ranking.api.NodeRanking;
import org.gephi.ranking.api.Ranking;
import org.gephi.ranking.api.RankingController;
import org.gephi.ranking.api.RankingModel;
import org.gephi.ranking.api.RankingResult;
import org.gephi.ranking.api.SizeTransformer;
import org.gephi.ranking.api.Transformer;
import org.gephi.ranking.impl.AbstractRanking;
import org.gephi.ranking.impl.AbstractTransformer;
import org.gephi.ranking.impl.RankingEventBus;
import org.gephi.ranking.impl.RankingFactory;
import org.gephi.ranking.impl.RankingModelImpl;
import org.gephi.ranking.impl.TransformerFactory;
import org.openide.util.Lookup;

public class RankingControllerImpl
implements RankingController {
    private RankingModelImpl rankingModelImpl = new RankingModelImpl();
    private RankingEventBus rankingEventBus = new RankingEventBus();

    public RankingModel getRankingModel() {
        return this.rankingModelImpl;
    }

    public void transform(Transformer transformer) {
        AbstractTransformer abstractTransformer = (AbstractTransformer)transformer;
        Ranking ranking = abstractTransformer.getRanking();
        RankingResultImpl rankingResult = new RankingResultImpl();
        rankingResult.transformer = transformer;
        rankingResult.ranking = ranking;
        Graph graph = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().getGraphVisible();
        DynamicModel dynamicModel = this.rankingModelImpl.getDynamicModel();
        boolean refreshed = RankingFactory.refreshRanking((AbstractRanking)ranking, graph, dynamicModel != null ? dynamicModel.getVisibleInterval() : null);
        if (ranking instanceof NodeRanking) {
            ((AbstractRanking)ranking).setGraph(graph);
            for (Node node : graph.getNodes().toArray()) {
                float normalizedValue;
                Object rank = ranking.getValue(node);
                Object result = null;
                if (rank != null && transformer.isInBounds(normalizedValue = ranking.normalize(rank))) {
                    result = transformer.transform(node, normalizedValue);
                }
                rankingResult.addResult(node, rank, result);
            }
        } else {
            ((AbstractRanking)ranking).setGraph(graph);
            for (Edge edge : graph.getEdges().toArray()) {
                float normalizedValue;
                Object rank = ranking.getValue(edge);
                Object result = null;
                if (rank != null && transformer.isInBounds(normalizedValue = ranking.normalize(rank))) {
                    result = transformer.transform(edge, normalizedValue);
                }
                rankingResult.addResult(edge, rank, result);
            }
        }
        this.rankingEventBus.publishResults(rankingResult);
        if (refreshed) {
            this.rankingModelImpl.fireChangeEvent();
        }
    }

    public ColorTransformer getObjectColorTransformer(Ranking ranking) {
        ColorTransformer colorTransformer = TransformerFactory.getObjectColorTransformer(ranking);
        return colorTransformer;
    }

    public SizeTransformer getObjectSizeTransformer(Ranking ranking) {
        SizeTransformer sizeTransformer = TransformerFactory.getObjectSizeTransformer(ranking);
        return sizeTransformer;
    }

    public ColorTransformer getLabelColorTransformer(Ranking ranking) {
        ColorTransformer colorTransformer = TransformerFactory.getLabelColorTransformer(ranking);
        return colorTransformer;
    }

    public SizeTransformer getLabelSizeTransformer(Ranking ranking) {
        SizeTransformer sizeTransformer = TransformerFactory.getLabelSizeTransformer(ranking);
        return sizeTransformer;
    }

    public Lookup getEventBus() {
        return this.rankingEventBus.getLookup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RankingResultImpl
    implements RankingResult {
        private Transformer transformer;
        private Ranking ranking;
        private List<RankingResult.RankingResultLine> lines = new ArrayList<RankingResult.RankingResultLine>();

        private RankingResultImpl() {
        }

        @Override
        public Transformer getTransformer() {
            return this.transformer;
        }

        @Override
        public Ranking getRanking() {
            return this.ranking;
        }

        public void addResult(Object target, Object rank, Object result) {
            if (target == null || rank == null || result == null) {
                return;
            }
            this.lines.add(new RankingResultLineImpl(target, rank, result));
        }

        @Override
        public List<RankingResult.RankingResultLine> getResultLines() {
            Collections.sort(this.lines, new Comparator(){

                public int compare(Object o1, Object o2) {
                    RankingResultLineImpl r1 = (RankingResultLineImpl)o1;
                    RankingResultLineImpl r2 = (RankingResultLineImpl)o2;
                    return ((Comparable)r1.rank).compareTo(r2.rank);
                }
            });
            return this.lines;
        }

        private static class RankingResultLineImpl
        implements RankingResult.RankingResultLine {
            private Object target;
            private Object rank;
            private Object result;

            public RankingResultLineImpl(Object target, Object rank, Object result) {
                this.target = target;
                this.rank = rank;
                this.result = result;
            }

            public Object getTarget() {
                return this.target;
            }

            public Object getResult() {
                return this.result;
            }

            public Object getRank() {
                return this.rank;
            }
        }
    }
}

