/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ranking.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.data.attributes.api.AttributeUtils;
import org.gephi.data.attributes.api.Estimator;
import org.gephi.data.attributes.type.DynamicType;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.ranking.api.EdgeRanking;
import org.gephi.ranking.api.NodeRanking;
import org.gephi.ranking.impl.AbstractRanking;

public class RankingFactory {
    public static NodeRanking getNodeAttributeRanking(AttributeColumn column, Graph graph) {
        NodeAttributeRanking nodeRanking = new NodeAttributeRanking(column);
        RankingFactory.setMinMax(nodeRanking, graph);
        return nodeRanking;
    }

    public static EdgeRanking getEdgeAttributeRanking(AttributeColumn column, Graph graph) {
        EdgeAttributeRanking edgeRanking = new EdgeAttributeRanking(column);
        RankingFactory.setMinMax(edgeRanking, graph);
        return edgeRanking;
    }

    public static NodeRanking getNodeDynamicAttributeRanking(AttributeColumn column, Graph graph, TimeInterval timeInterval, Estimator estimator) {
        DynamicNodeAttributeRanking nodeRanking = new DynamicNodeAttributeRanking(column, timeInterval, estimator);
        RankingFactory.setMinMax(nodeRanking, graph);
        return nodeRanking;
    }

    public static EdgeRanking getEdgeDynamicAttributeRanking(AttributeColumn column, Graph graph, TimeInterval timeInterval, Estimator estimator) {
        DynamicEdgeAttributeRanking edgeRanking = new DynamicEdgeAttributeRanking(column, timeInterval, estimator);
        RankingFactory.setMinMax(edgeRanking, graph);
        return edgeRanking;
    }

    public static NodeRanking getNodeDegreeRanking(Graph graph) {
        NodeDegreeRanking nodeRanking = new NodeDegreeRanking(graph);
        RankingFactory.setMinMax(nodeRanking, graph);
        return nodeRanking;
    }

    public static NodeRanking getNodeInDegreeRanking(DirectedGraph graph) {
        NodeInDegreeRanking nodeRanking = new NodeInDegreeRanking(graph);
        RankingFactory.setMinMax(nodeRanking, graph);
        return nodeRanking;
    }

    public static NodeRanking getNodeOutDegreeRanking(DirectedGraph graph) {
        NodeOutDegreeRanking nodeRanking = new NodeOutDegreeRanking(graph);
        RankingFactory.setMinMax(nodeRanking, graph);
        return nodeRanking;
    }

    public static NodeRanking getNodeChildrenCountRanking(HierarchicalGraph graph) {
        NodeChildrenCountRanking nodeRanking = new NodeChildrenCountRanking(graph);
        RankingFactory.setMinMax(nodeRanking, graph);
        return nodeRanking;
    }

    public static boolean refreshRanking(AbstractRanking ranking, Graph graph, TimeInterval timeInterval) {
        if (ranking instanceof DynamicNodeAttributeRanking) {
            ((DynamicNodeAttributeRanking)ranking).timeInterval = timeInterval;
        } else if (ranking instanceof DynamicEdgeAttributeRanking) {
            ((DynamicEdgeAttributeRanking)ranking).timeInterval = timeInterval;
        }
        double hash = ranking.hash;
        ranking.setGraph(graph);
        RankingFactory.setMinMax(ranking, graph);
        return ranking.hash != hash;
    }

    public static boolean isNumberColumn(AttributeColumn column) {
        AttributeType type = column.getType();
        return type == AttributeType.DOUBLE || type == AttributeType.FLOAT || type == AttributeType.INT || type == AttributeType.LONG || type == AttributeType.BYTE || type == AttributeType.BIGDECIMAL || type == AttributeType.BIGINTEGER || type == AttributeType.SHORT;
    }

    public static boolean isDynamicNumberColumn(AttributeColumn column) {
        AttributeType type = column.getType();
        AttributeUtils.getDefault().isDynamicNumberColumn(column);
        return type == AttributeType.DYNAMIC_BIGDECIMAL || type == AttributeType.DYNAMIC_BIGINTEGER || type == AttributeType.DYNAMIC_BYTE || type == AttributeType.DYNAMIC_DOUBLE || type == AttributeType.DYNAMIC_FLOAT || type == AttributeType.DYNAMIC_INT || type == AttributeType.DYNAMIC_LONG || type == AttributeType.DYNAMIC_SHORT;
    }

    protected static void setMinMax(AbstractRanking ranking, Graph graph) {
        if (ranking instanceof NodeRanking) {
            ArrayList<Comparable> objects = new ArrayList<Comparable>();
            for (Node node : graph.getNodes().toArray()) {
                Comparable value = (Comparable)ranking.getValue(node);
                if (value == null) continue;
                objects.add(value);
            }
            ranking.hash = ((Object)objects).hashCode();
            ranking.setMinimumValue((Number)RankingFactory.getMin(objects.toArray(new Comparable[0])));
            ranking.setMaximumValue((Number)RankingFactory.getMax(objects.toArray(new Comparable[0])));
        } else if (ranking instanceof EdgeRanking) {
            ArrayList<Comparable> objects = new ArrayList<Comparable>();
            for (Edge edge : graph.getEdges().toArray()) {
                Comparable value = (Comparable)ranking.getValue(edge);
                if (value == null) continue;
                objects.add(value);
            }
            ranking.hash = ((Object)objects).hashCode();
            ranking.setMinimumValue((Number)RankingFactory.getMin(objects.toArray(new Comparable[0])));
            ranking.setMaximumValue((Number)RankingFactory.getMax(objects.toArray(new Comparable[0])));
        }
    }

    private static Object getMin(Comparable[] values) {
        switch (values.length) {
            case 0: {
                return null;
            }
            case 1: {
                return values[0];
            }
        }
        Comparable min = values[0];
        for (int index = 1; index < values.length; ++index) {
            Comparable o = values[index];
            if (o.compareTo(min) >= 0) continue;
            min = o;
        }
        return min;
    }

    private static Object getMax(Comparable[] values) {
        switch (values.length) {
            case 0: {
                return null;
            }
            case 1: {
                return values[0];
            }
        }
        Comparable max = values[0];
        for (int index = 1; index < values.length; ++index) {
            Comparable o = values[index];
            if (o.compareTo(max) <= 0) continue;
            max = o;
        }
        return max;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DynamicEdgeAttributeRanking<Type extends Number>
    extends AttributeRanking<Edge, Type>
    implements EdgeRanking<Type> {
        private TimeInterval timeInterval;
        private Estimator estimator;

        public DynamicEdgeAttributeRanking(AttributeColumn column, TimeInterval timeInterval, Estimator estimator) {
            super(column);
            this.timeInterval = timeInterval;
            this.estimator = estimator;
        }

        @Override
        public Type getValue(Edge edge) {
            DynamicType dynamicType = (DynamicType)edge.getEdgeData().getAttributes().getValue(this.column.getIndex());
            if (dynamicType != null) {
                return (Type)((Number)dynamicType.getValue(this.timeInterval == null ? Double.NEGATIVE_INFINITY : this.timeInterval.getLow(), this.timeInterval == null ? Double.POSITIVE_INFINITY : this.timeInterval.getHigh(), this.estimator));
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DynamicNodeAttributeRanking<Type extends Number>
    extends AttributeRanking<Node, Type>
    implements NodeRanking<Type> {
        private TimeInterval timeInterval;
        private Estimator estimator;

        public DynamicNodeAttributeRanking(AttributeColumn column, TimeInterval timeInterval, Estimator estimator) {
            super(column);
            this.timeInterval = timeInterval;
            this.estimator = estimator;
        }

        @Override
        public Type getValue(Node node) {
            DynamicType dynamicType = (DynamicType)node.getNodeData().getAttributes().getValue(this.column.getIndex());
            if (dynamicType != null) {
                return (Type)((Number)dynamicType.getValue(this.timeInterval == null ? Double.NEGATIVE_INFINITY : this.timeInterval.getLow(), this.timeInterval == null ? Double.POSITIVE_INFINITY : this.timeInterval.getHigh(), this.estimator));
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EdgeAttributeRanking<Type extends Number>
    extends AttributeRanking<Edge, Type>
    implements EdgeRanking<Type> {
        public EdgeAttributeRanking(AttributeColumn column) {
            super(column);
        }

        @Override
        public Type getValue(Edge edge) {
            return (Type)((Number)edge.getEdgeData().getAttributes().getValue(this.column.getIndex()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeAttributeRanking<Type extends Number>
    extends AttributeRanking<Node, Type>
    implements NodeRanking<Type> {
        public NodeAttributeRanking(AttributeColumn column) {
            super(column);
        }

        @Override
        public Type getValue(Node node) {
            return (Type)((Number)node.getNodeData().getAttributes().getValue(this.column.getIndex()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AttributeRanking<Element, Type extends Number>
    extends AbstractRanking<Element, Type> {
        protected AttributeColumn column;

        public AttributeRanking(AttributeColumn attributeColumn) {
            this.column = attributeColumn;
        }

        @Override
        public String getName() {
            return this.column.getTitle();
        }

        @Override
        public String toString() {
            return this.getName();
        }

        @Override
        public Class getType() {
            return this.column.getType().getType();
        }

        @Override
        public float normalize(Type value) {
            return (((Number)value).floatValue() - this.minimum.floatValue()) / (this.maximum.floatValue() - this.minimum.floatValue());
        }

        @Override
        public Type unNormalize(float normalizedValue) {
            double val = (double)normalizedValue * (this.maximum.doubleValue() - this.minimum.doubleValue()) + this.minimum.doubleValue();
            switch (this.column.getType()) {
                case BIGDECIMAL: {
                    return (Type)new BigDecimal(val);
                }
                case BIGINTEGER: {
                    return (Type)new BigInteger("" + val);
                }
                case DOUBLE: {
                    return (Type)new Double(val);
                }
                case FLOAT: {
                    return (Type)new Float(val);
                }
                case INT: {
                    return (Type)new Integer((int)val);
                }
                case LONG: {
                    return (Type)new Long((long)val);
                }
                case SHORT: {
                    return (Type)new Short((short)val);
                }
            }
            return (Type)new Double(val);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeChildrenCountRanking
    extends AbstractRanking<Node, Integer>
    implements NodeRanking<Integer> {
        public NodeChildrenCountRanking(HierarchicalGraph graph) {
            this.graph = graph;
        }

        @Override
        public Integer getValue(Node element) {
            return ((HierarchicalGraph)this.graph).getChildrenCount(element);
        }

        @Override
        public float normalize(Integer value) {
            return (float)(value - (Integer)this.minimum) / (float)((Integer)this.maximum - (Integer)this.minimum);
        }

        @Override
        public Integer unNormalize(float normalizedValue) {
            return (int)(normalizedValue * (float)((Integer)this.maximum - (Integer)this.minimum)) + (Integer)this.minimum;
        }

        @Override
        public String getName() {
            return "Children count";
        }

        @Override
        public String toString() {
            return this.getName();
        }

        @Override
        public Class getType() {
            return Integer.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeOutDegreeRanking
    extends AbstractRanking<Node, Integer>
    implements NodeRanking<Integer> {
        public NodeOutDegreeRanking(DirectedGraph graph) {
            this.graph = graph;
        }

        @Override
        public Integer getValue(Node element) {
            return ((DirectedGraph)this.graph).getOutDegree(element);
        }

        @Override
        public float normalize(Integer value) {
            return (float)(value - (Integer)this.minimum) / (float)((Integer)this.maximum - (Integer)this.minimum);
        }

        @Override
        public Integer unNormalize(float normalizedValue) {
            return (int)(normalizedValue * (float)((Integer)this.maximum - (Integer)this.minimum)) + (Integer)this.minimum;
        }

        @Override
        public String getName() {
            return "OutDegree";
        }

        @Override
        public String toString() {
            return this.getName();
        }

        @Override
        public Class getType() {
            return Integer.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeInDegreeRanking
    extends AbstractRanking<Node, Integer>
    implements NodeRanking<Integer> {
        public NodeInDegreeRanking(DirectedGraph graph) {
            this.graph = graph;
        }

        @Override
        public Integer getValue(Node element) {
            return ((DirectedGraph)this.graph).getInDegree(element);
        }

        @Override
        public float normalize(Integer value) {
            return (float)(value - (Integer)this.minimum) / (float)((Integer)this.maximum - (Integer)this.minimum);
        }

        @Override
        public Integer unNormalize(float normalizedValue) {
            return (int)(normalizedValue * (float)((Integer)this.maximum - (Integer)this.minimum)) + (Integer)this.minimum;
        }

        @Override
        public String getName() {
            return "InDegree";
        }

        @Override
        public String toString() {
            return this.getName();
        }

        @Override
        public Class getType() {
            return Integer.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeDegreeRanking
    extends AbstractRanking<Node, Integer>
    implements NodeRanking<Integer> {
        public NodeDegreeRanking(Graph graph) {
            this.graph = graph;
        }

        @Override
        public Integer getValue(Node element) {
            return this.graph.getDegree(element);
        }

        @Override
        public float normalize(Integer value) {
            return (float)(value - (Integer)this.minimum) / (float)((Integer)this.maximum - (Integer)this.minimum);
        }

        @Override
        public Integer unNormalize(float normalizedValue) {
            return (int)(normalizedValue * (float)((Integer)this.maximum - (Integer)this.minimum)) + (Integer)this.minimum;
        }

        @Override
        public String getName() {
            return "Degree";
        }

        @Override
        public String toString() {
            return this.getName();
        }

        @Override
        public Class getType() {
            return Integer.class;
        }
    }
}

