/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ranking.impl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeEvent;
import org.gephi.data.attributes.api.AttributeListener;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.type.TimeInterval;
import org.gephi.dynamic.api.DynamicController;
import org.gephi.dynamic.api.DynamicModel;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.ranking.api.EdgeRanking;
import org.gephi.ranking.api.NodeRanking;
import org.gephi.ranking.api.RankingModel;
import org.gephi.ranking.impl.RankingFactory;
import org.openide.util.Lookup;

public class RankingModelImpl
implements RankingModel,
AttributeListener {
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private DynamicModel dynamicModel;
    private Timer refreshTimer;

    public RankingModelImpl() {
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        AttributeController ac = (AttributeController)Lookup.getDefault().lookup(AttributeController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
            }

            public void select(Workspace workspace) {
                AttributeModel attributeModel = (AttributeModel)workspace.getLookup().lookup(AttributeModel.class);
                attributeModel.addAttributeListener(RankingModelImpl.this);
            }

            public void unselect(Workspace workspace) {
                AttributeModel attributeModel = (AttributeModel)workspace.getLookup().lookup(AttributeModel.class);
                attributeModel.removeAttributeListener(RankingModelImpl.this);
                RankingModelImpl.this.dynamicModel = null;
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                RankingModelImpl.this.dynamicModel = null;
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            AttributeModel attributeModel = (AttributeModel)pc.getCurrentWorkspace().getLookup().lookup(AttributeModel.class);
            attributeModel.addAttributeListener(this);
        }
    }

    public void attributesChanged(AttributeEvent event) {
        if (event.getEventType().equals((Object)AttributeEvent.EventType.ADD_COLUMN) || event.getEventType().equals((Object)AttributeEvent.EventType.REMOVE_COLUMN)) {
            if (this.refreshTimer != null) {
                this.refreshTimer.restart();
            } else {
                this.refreshTimer = new Timer(1000, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        RankingModelImpl.this.fireChangeEvent();
                    }
                });
                this.refreshTimer.setRepeats(false);
                this.refreshTimer.start();
            }
        }
    }

    public NodeRanking getDegreeRanking() {
        GraphModel model = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
        Graph graph = model.getGraphVisible();
        NodeRanking degreeRanking = RankingFactory.getNodeDegreeRanking(graph);
        if (degreeRanking.getMinimumValue() != null && degreeRanking.getMaximumValue() != null && !degreeRanking.getMinimumValue().equals(degreeRanking.getMaximumValue())) {
            return degreeRanking;
        }
        return null;
    }

    public NodeRanking getInDegreeRanking() {
        GraphModel model = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
        DirectedGraph graph = model.getDirectedGraphVisible();
        NodeRanking degreeRanking = RankingFactory.getNodeInDegreeRanking(graph);
        if (degreeRanking.getMinimumValue() != null && degreeRanking.getMaximumValue() != null && !degreeRanking.getMinimumValue().equals(degreeRanking.getMaximumValue())) {
            return degreeRanking;
        }
        return null;
    }

    public NodeRanking getOutDegreeRanking() {
        GraphModel model = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
        DirectedGraph graph = model.getDirectedGraphVisible();
        NodeRanking degreeRanking = RankingFactory.getNodeOutDegreeRanking(graph);
        if (degreeRanking.getMinimumValue() != null && degreeRanking.getMaximumValue() != null && !degreeRanking.getMinimumValue().equals(degreeRanking.getMaximumValue())) {
            return degreeRanking;
        }
        return null;
    }

    public NodeRanking getNodeAttributeRanking(AttributeColumn column) {
        TimeInterval visibleInterval;
        NodeRanking r;
        GraphModel model = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
        Graph graph = model.getGraphVisible();
        if (RankingFactory.isNumberColumn(column)) {
            NodeRanking r2 = RankingFactory.getNodeAttributeRanking(column, graph);
            if (r2.getMinimumValue() != null && r2.getMaximumValue() != null && !r2.getMinimumValue().equals(r2.getMaximumValue())) {
                return r2;
            }
        } else if (RankingFactory.isDynamicNumberColumn(column) && this.getDynamicModel() != null && (r = RankingFactory.getNodeDynamicAttributeRanking(column, graph, visibleInterval = this.dynamicModel.getVisibleInterval(), this.dynamicModel.getNumberEstimator())).getMinimumValue() != null && r.getMaximumValue() != null && !r.getMinimumValue().equals(r.getMaximumValue())) {
            return r;
        }
        return null;
    }

    public EdgeRanking getEdgeAttributeRanking(AttributeColumn column) {
        TimeInterval visibleInterval;
        EdgeRanking r;
        GraphModel model = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
        Graph graph = model.getGraphVisible();
        if (RankingFactory.isNumberColumn(column)) {
            EdgeRanking r2 = RankingFactory.getEdgeAttributeRanking(column, graph);
            if (r2.getMinimumValue() != null && r2.getMaximumValue() != null && !r2.getMinimumValue().equals(r2.getMaximumValue())) {
                return r2;
            }
        } else if (RankingFactory.isDynamicNumberColumn(column) && this.getDynamicModel() != null && (r = RankingFactory.getEdgeDynamicAttributeRanking(column, graph, visibleInterval = this.dynamicModel.getVisibleInterval(), this.dynamicModel.getNumberEstimator())).getMinimumValue() != null && r.getMaximumValue() != null && !r.getMinimumValue().equals(r.getMaximumValue())) {
            return r;
        }
        return null;
    }

    public NodeRanking[] getNodeRanking() {
        HierarchicalGraph hierarchicalGraph;
        NodeRanking childrenRanking;
        AttributeController attributeController = (AttributeController)Lookup.getDefault().lookup(AttributeController.class);
        ArrayList<NodeRanking> rankingList = new ArrayList<NodeRanking>();
        GraphModel model = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel();
        Graph graph = model.getGraphVisible();
        NodeRanking degreeRanking = RankingFactory.getNodeDegreeRanking(graph);
        if (degreeRanking.getMinimumValue() != null && degreeRanking.getMaximumValue() != null && !degreeRanking.getMinimumValue().equals(degreeRanking.getMaximumValue())) {
            rankingList.add(degreeRanking);
        }
        if (model.isDirected()) {
            NodeRanking outDegreeRanking;
            DirectedGraph directedGraph = model.getDirectedGraphVisible();
            NodeRanking inDegreeRanking = RankingFactory.getNodeInDegreeRanking(directedGraph);
            if (inDegreeRanking.getMinimumValue() != null && inDegreeRanking.getMaximumValue() != null && !inDegreeRanking.getMinimumValue().equals(inDegreeRanking.getMaximumValue())) {
                rankingList.add(inDegreeRanking);
            }
            if ((outDegreeRanking = RankingFactory.getNodeOutDegreeRanking(directedGraph)).getMinimumValue() != null && outDegreeRanking.getMaximumValue() != null && !outDegreeRanking.getMinimumValue().equals(outDegreeRanking.getMaximumValue())) {
                rankingList.add(outDegreeRanking);
            }
        }
        if (model.isHierarchical() && (childrenRanking = RankingFactory.getNodeChildrenCountRanking(hierarchicalGraph = model.getHierarchicalGraphVisible())).getMinimumValue() != null && childrenRanking.getMaximumValue() != null && !childrenRanking.getMinimumValue().equals(childrenRanking.getMaximumValue())) {
            rankingList.add(childrenRanking);
        }
        int nativeCount = rankingList.size();
        for (AttributeColumn column : attributeController.getModel().getNodeTable().getColumns()) {
            TimeInterval visibleInterval;
            NodeRanking r;
            if (RankingFactory.isNumberColumn(column)) {
                NodeRanking r2 = RankingFactory.getNodeAttributeRanking(column, graph);
                if (r2.getMinimumValue() == null || r2.getMaximumValue() == null || r2.getMinimumValue().equals(r2.getMaximumValue())) continue;
                rankingList.add(r2);
                continue;
            }
            if (!RankingFactory.isDynamicNumberColumn(column) || this.getDynamicModel() == null || (r = RankingFactory.getNodeDynamicAttributeRanking(column, graph, visibleInterval = this.dynamicModel.getVisibleInterval(), this.dynamicModel.getNumberEstimator())).getMinimumValue() == null || r.getMaximumValue() == null || r.getMinimumValue().equals(r.getMaximumValue())) continue;
            rankingList.add(r);
        }
        NodeRanking[] rankingArray = rankingList.toArray(new NodeRanking[0]);
        Arrays.sort(rankingArray, nativeCount, rankingArray.length, new Comparator<NodeRanking>(){

            @Override
            public int compare(NodeRanking a, NodeRanking b) {
                return a.toString().compareTo(b.toString());
            }
        });
        return rankingArray;
    }

    public EdgeRanking[] getEdgeRanking() {
        AttributeController attributeController = (AttributeController)Lookup.getDefault().lookup(AttributeController.class);
        Graph graph = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getModel().getGraphVisible();
        ArrayList<EdgeRanking> rankingList = new ArrayList<EdgeRanking>();
        for (AttributeColumn column : attributeController.getModel().getEdgeTable().getColumns()) {
            TimeInterval visibleInterval;
            EdgeRanking r;
            if (RankingFactory.isNumberColumn(column)) {
                EdgeRanking r2 = RankingFactory.getEdgeAttributeRanking(column, graph);
                if (r2.getMinimumValue() == null || r2.getMaximumValue() == null || r2.getMinimumValue().equals(r2.getMaximumValue())) continue;
                rankingList.add(r2);
                continue;
            }
            if (!RankingFactory.isDynamicNumberColumn(column) || this.getDynamicModel() == null || (r = RankingFactory.getEdgeDynamicAttributeRanking(column, graph, visibleInterval = this.dynamicModel.getVisibleInterval(), this.dynamicModel.getNumberEstimator())).getMinimumValue() == null || r.getMaximumValue() == null || r.getMinimumValue().equals(r.getMaximumValue())) continue;
            rankingList.add(r);
        }
        return rankingList.toArray(new EdgeRanking[0]);
    }

    public DynamicModel getDynamicModel() {
        DynamicController dynamicController;
        if (this.dynamicModel == null && (dynamicController = (DynamicController)Lookup.getDefault().lookup(DynamicController.class)) != null) {
            this.dynamicModel = dynamicController.getModel();
        }
        return this.dynamicModel;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.add(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

