/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ranking.impl;

import java.awt.Color;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;
import org.gephi.ranking.api.ColorTransformer;
import org.gephi.ranking.api.LabelColorTransformer;
import org.gephi.ranking.api.LabelSizeTransformer;
import org.gephi.ranking.api.NodeRanking;
import org.gephi.ranking.api.ObjectColorTransformer;
import org.gephi.ranking.api.ObjectSizeTransformer;
import org.gephi.ranking.api.Ranking;
import org.gephi.ranking.api.SizeTransformer;
import org.gephi.ranking.impl.AbstractColorTransformer;
import org.gephi.ranking.impl.AbstractSizeTransformer;

public class TransformerFactory {
    public static ColorTransformer getObjectColorTransformer(Ranking ranking) {
        AbstractColorTransformer colorTransformer = null;
        colorTransformer = ranking instanceof NodeRanking ? new NodeColorTransformer() : new EdgeColorTransformer();
        colorTransformer.setRanking(ranking);
        return colorTransformer;
    }

    public static SizeTransformer getObjectSizeTransformer(Ranking ranking) {
        AbstractSizeTransformer sizeTransformer = null;
        sizeTransformer = ranking instanceof NodeRanking ? new NodeSizeTransformer() : new EdgeWeightTransformer();
        sizeTransformer.setRanking(ranking);
        return sizeTransformer;
    }

    public static ColorTransformer getLabelColorTransformer(Ranking ranking) {
        AbstractColorTransformer colorTransformer = null;
        colorTransformer = ranking instanceof NodeRanking ? new NodeLabelColorTransformer() : new EdgeLabelColorTransformer();
        colorTransformer.setRanking(ranking);
        return colorTransformer;
    }

    public static SizeTransformer getLabelSizeTransformer(Ranking ranking) {
        AbstractSizeTransformer sizeTransformer = new NodeSizeTransformer();
        sizeTransformer = ranking instanceof NodeRanking ? new NodeLabelSizeTransformer() : new EdgeLabelSizeTransformer();
        sizeTransformer.setRanking(ranking);
        return sizeTransformer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EdgeLabelSizeTransformer
    extends AbstractSizeTransformer<Edge>
    implements LabelSizeTransformer<Edge> {
        private EdgeLabelSizeTransformer() {
        }

        @Override
        public Object transform(Edge target, float normalizedValue) {
            float size = this.getSize(normalizedValue);
            target.getEdgeData().getTextData().setSize(size);
            return Float.valueOf(size);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeLabelSizeTransformer
    extends AbstractSizeTransformer<Node>
    implements LabelSizeTransformer<Node> {
        private NodeLabelSizeTransformer() {
        }

        @Override
        public Object transform(Node target, float normalizedValue) {
            float size = this.getSize(normalizedValue);
            target.getNodeData().getTextData().setSize(size);
            return Float.valueOf(size);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EdgeLabelColorTransformer
    extends AbstractColorTransformer<Edge>
    implements LabelColorTransformer<Edge> {
        private EdgeLabelColorTransformer() {
        }

        @Override
        public Object transform(Edge target, float normalizedValue) {
            Color color = this.getColor(normalizedValue);
            target.getEdgeData().getTextData().setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
            return color;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeLabelColorTransformer
    extends AbstractColorTransformer<Node>
    implements LabelColorTransformer<Node> {
        private NodeLabelColorTransformer() {
        }

        @Override
        public Object transform(Node target, float normalizedValue) {
            Color color = this.getColor(normalizedValue);
            target.getNodeData().getTextData().setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
            return color;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EdgeWeightTransformer
    extends AbstractSizeTransformer<Edge>
    implements ObjectSizeTransformer<Edge> {
        private EdgeWeightTransformer() {
        }

        @Override
        public Object transform(Edge target, float normalizedValue) {
            float size = this.getSize(normalizedValue);
            target.setWeight(size);
            return Float.valueOf(size);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeSizeTransformer
    extends AbstractSizeTransformer<Node>
    implements ObjectSizeTransformer<Node> {
        private NodeSizeTransformer() {
        }

        @Override
        public Object transform(Node target, float normalizedValue) {
            float size = this.getSize(normalizedValue);
            target.getNodeData().setSize(size);
            return Float.valueOf(size);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EdgeColorTransformer
    extends AbstractColorTransformer<Edge>
    implements ObjectColorTransformer<Edge> {
        private EdgeColorTransformer() {
        }

        @Override
        public Object transform(Edge target, float normalizedValue) {
            Color color = this.getColor(normalizedValue);
            target.getEdgeData().setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            return color;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeColorTransformer
    extends AbstractColorTransformer<Node>
    implements ObjectColorTransformer<Node> {
        private NodeColorTransformer() {
        }

        @Override
        public Object transform(Node target, float normalizedValue) {
            Color color = this.getColor(normalizedValue);
            target.getNodeData().setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            return color;
        }
    }
}

