/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics;

import java.util.ArrayList;
import org.gephi.data.attributes.api.AttributeController;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.statistics.StatisticsModelImpl;
import org.gephi.statistics.api.StatisticsController;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsBuilder;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.utils.longtask.api.LongTaskExecutor;
import org.gephi.utils.longtask.api.LongTaskListener;
import org.gephi.utils.longtask.spi.LongTask;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsControllerImpl
implements StatisticsController {
    private StatisticsBuilder[] statisticsBuilders = Lookup.getDefault().lookupAll(StatisticsBuilder.class).toArray(new StatisticsBuilder[0]);
    private StatisticsModelImpl model;

    public StatisticsControllerImpl() {
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
                workspace.add(new StatisticsModelImpl());
            }

            public void select(Workspace workspace) {
                StatisticsControllerImpl.this.model = (StatisticsModelImpl)workspace.getLookup().lookup(StatisticsModelImpl.class);
                if (StatisticsControllerImpl.this.model == null) {
                    StatisticsControllerImpl.this.model = new StatisticsModelImpl();
                    workspace.add(StatisticsControllerImpl.this.model);
                }
            }

            public void unselect(Workspace workspace) {
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                StatisticsControllerImpl.this.model = null;
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            this.model = (StatisticsModelImpl)pc.getCurrentWorkspace().getLookup().lookup(StatisticsModelImpl.class);
            if (this.model == null) {
                this.model = new StatisticsModelImpl();
                pc.getCurrentWorkspace().add(this.model);
            }
        }
    }

    @Override
    public void execute(final Statistics pStatistics, LongTaskListener listener) {
        StatisticsUI[] uis;
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        final GraphModel graphModel = graphController.getModel();
        final AttributeModel attributeModel = ((AttributeController)Lookup.getDefault().lookup(AttributeController.class)).getModel();
        StatisticsBuilder builder = this.getBuilder(pStatistics.getClass());
        for (StatisticsUI s : uis = this.getUI(pStatistics)) {
            s.setup(pStatistics);
        }
        this.model.setRunning(pStatistics, true);
        if (pStatistics instanceof LongTask) {
            LongTaskExecutor executor = new LongTaskExecutor(true, builder.getName(), 10);
            if (listener != null) {
                executor.setLongTaskListener(listener);
            }
            executor.execute((LongTask)((Object)pStatistics), new Runnable(){

                public void run() {
                    pStatistics.execute(graphModel, attributeModel);
                    StatisticsControllerImpl.this.model.setRunning(pStatistics, false);
                    for (StatisticsUI s : uis) {
                        StatisticsControllerImpl.this.model.addResult(s);
                        s.unsetup();
                    }
                    StatisticsControllerImpl.this.model.addReport(pStatistics);
                }
            }, builder.getName(), null);
        } else {
            pStatistics.execute(graphModel, attributeModel);
            this.model.setRunning(pStatistics, false);
            for (StatisticsUI s : uis) {
                this.model.addResult(s);
                s.unsetup();
            }
            this.model.addReport(pStatistics);
            if (listener != null) {
                listener.taskFinished(null);
            }
        }
    }

    public StatisticsUI[] getUI(Statistics statistics) {
        ArrayList<StatisticsUI> list = new ArrayList<StatisticsUI>();
        for (StatisticsUI sui : Lookup.getDefault().lookupAll(StatisticsUI.class)) {
            if (!sui.getStatisticsClass().equals(statistics.getClass())) continue;
            list.add(sui);
        }
        return list.toArray(new StatisticsUI[0]);
    }

    @Override
    public StatisticsBuilder getBuilder(Class<? extends Statistics> statisticsClass) {
        for (StatisticsBuilder b : this.statisticsBuilders) {
            if (!b.getStatisticsClass().equals(statisticsClass)) continue;
            return b;
        }
        return null;
    }

    @Override
    public void setStatisticsUIVisible(StatisticsUI ui, boolean visible) {
        this.model.setVisible(ui, visible);
    }

    @Override
    public StatisticsModelImpl getModel() {
        return this.model;
    }
}

