/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.codec.binary.Base64;
import org.gephi.statistics.api.StatisticsModel;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsBuilder;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.utils.TempDirUtils;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsModelImpl
implements StatisticsModel {
    private final List<StatisticsUI> invisibleList = new ArrayList<StatisticsUI>();
    private final List<Statistics> runningList = Collections.synchronizedList(new ArrayList());
    private final Map<StatisticsUI, String> resultMap;
    private final Map<Class, String> reportMap;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public StatisticsModelImpl() {
        this.resultMap = new HashMap<StatisticsUI, String>();
        this.reportMap = new HashMap<Class, String>();
    }

    public void addReport(Statistics statistics) {
        this.reportMap.put(statistics.getClass(), statistics.getReport());
        this.fireChangeEvent();
    }

    public void addResult(StatisticsUI ui) {
        if (this.resultMap.containsKey(ui) && ui.getValue() == null) {
            this.resultMap.remove(ui);
        } else {
            this.resultMap.put(ui, ui.getValue());
        }
        this.fireChangeEvent();
    }

    @Override
    public String getReport(Class<? extends Statistics> statisticsClass) {
        return this.reportMap.get(statisticsClass);
    }

    @Override
    public String getResult(StatisticsUI statisticsUI) {
        return this.resultMap.get(statisticsUI);
    }

    @Override
    public boolean isStatisticsUIVisible(StatisticsUI statisticsUI) {
        return !this.invisibleList.contains(statisticsUI);
    }

    @Override
    public boolean isRunning(StatisticsUI statisticsUI) {
        for (Statistics s : this.runningList.toArray(new Statistics[0])) {
            if (!statisticsUI.getStatisticsClass().equals(s.getClass())) continue;
            return true;
        }
        return false;
    }

    public void setRunning(Statistics statistics, boolean running) {
        if (!running) {
            if (this.runningList.remove(statistics)) {
                this.fireChangeEvent();
            }
        } else if (!this.runningList.contains(statistics)) {
            this.runningList.add(statistics);
            this.fireChangeEvent();
        }
    }

    @Override
    public Statistics getRunning(StatisticsUI statisticsUI) {
        for (Statistics s : this.runningList.toArray(new Statistics[0])) {
            if (!statisticsUI.getStatisticsClass().equals(s)) continue;
            return s;
        }
        return null;
    }

    public void setVisible(StatisticsUI statisticsUI, boolean visible) {
        if (visible) {
            if (this.invisibleList.remove(statisticsUI)) {
                this.fireChangeEvent();
            }
        } else if (!this.invisibleList.contains(statisticsUI)) {
            this.invisibleList.add(statisticsUI);
            this.fireChangeEvent();
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (!this.listeners.contains(changeListener)) {
            this.listeners.add(changeListener);
        }
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void fireChangeEvent() {
        ChangeEvent evt = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(evt);
        }
    }

    public Element writeXML(Document document) {
        Element modelE = document.createElement("statisticsmodel");
        Element resultsE = document.createElement("results");
        for (Map.Entry<StatisticsUI, String> entry : this.resultMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            Element resultE = document.createElement("result");
            resultE.setAttribute("class", entry.getKey().getClass().getName());
            resultE.setAttribute("value", entry.getValue());
            resultsE.appendChild(resultE);
        }
        modelE.appendChild(resultsE);
        Element reportsE = document.createElement("reports");
        for (Map.Entry<Class, String> entry : this.reportMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            Element reportE = document.createElement("report");
            String report = entry.getValue();
            report = this.embedImages(report);
            reportE.setAttribute("class", entry.getKey().getName());
            reportE.setAttribute("value", report);
            reportsE.appendChild(reportE);
        }
        modelE.appendChild(reportsE);
        return modelE;
    }

    public void readXML(Element modelE) {
        Element reportsE;
        Element resultsE = this.getNextElementByTagName(modelE, "results");
        if (resultsE != null) {
            Collection uis = Lookup.getDefault().lookupAll(StatisticsUI.class);
            for (Element resultE : this.getElementsByTagName(resultsE, "result")) {
                String classStr = resultE.getAttribute("class");
                StatisticsUI resultUI = null;
                for (StatisticsUI ui : uis) {
                    if (!ui.getClass().getName().equals(classStr)) continue;
                    resultUI = ui;
                }
                if (resultUI == null) continue;
                String value = resultE.getAttribute("value");
                this.resultMap.put(resultUI, value);
            }
        }
        if ((reportsE = this.getNextElementByTagName(modelE, "reports")) != null) {
            Collection builders = Lookup.getDefault().lookupAll(StatisticsBuilder.class);
            for (Element reportE : this.getElementsByTagName(reportsE, "report")) {
                String classStr = reportE.getAttribute("class");
                Class<? extends Statistics> reportClass = null;
                for (StatisticsBuilder builder : builders) {
                    if (!builder.getStatisticsClass().getName().equals(classStr)) continue;
                    reportClass = builder.getStatisticsClass();
                }
                if (reportClass == null) continue;
                String report = reportE.getAttribute("value");
                report = this.unembedImages(report);
                this.reportMap.put(reportClass, report);
            }
        }
    }

    private Element getNextElementByTagName(Element node, String name) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equalsIgnoreCase(name)) continue;
            return (Element)n;
        }
        return null;
    }

    private Element[] getElementsByTagName(Element node, String name) {
        NodeList list = node.getElementsByTagName(name);
        Element[] res = new Element[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1) continue;
            res[i] = (Element)n;
        }
        return res;
    }

    private String unembedImages(String report) {
        StringBuilder builder = new StringBuilder();
        String[] result = report.split("data:image/png;base64");
        if (result.length == 0) {
            return report;
        }
        try {
            TempDirUtils.TempDir tempDir = TempDirUtils.createTempDir();
            for (int i = 0; i < result.length; ++i) {
                if (result[i].contains("</IMG>")) {
                    String next = result[i];
                    int endIndex = next.indexOf(34);
                    String pngStr = next.substring(0, endIndex);
                    byte[] imageBytes = Base64.decodeBase64((String)pngStr);
                    String fileName = "image" + i + ".png";
                    File file = tempDir.createFile(fileName);
                    FileOutputStream fos = new FileOutputStream(file);
                    fos.write(imageBytes);
                    String path = "file:" + file.getAbsolutePath();
                    builder.append(path);
                    builder.append(next.substring(endIndex, next.length()));
                    continue;
                }
                builder.append(result[i]);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return builder.toString();
    }

    private String embedImages(String report) {
        StringBuilder builder = new StringBuilder();
        String[] result = report.split("file:");
        boolean first = true;
        for (int i = 0; i < result.length; ++i) {
            if (result[i].contains("</IMG>")) {
                String next = result[i];
                String[] elements = next.split("\"");
                String filename = elements[0];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                File file = new File(filename);
                try {
                    BufferedImage image = ImageIO.read(file);
                    ImageIO.write((RenderedImage)image, "PNG", out);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                byte[] imageBytes = out.toByteArray();
                String base64String = Base64.encodeBase64String((byte[])imageBytes);
                if (!first) {
                    builder.append("\"");
                }
                first = false;
                builder.append("data:image/png;base64,");
                builder.append(base64String);
                for (int j = 1; j < elements.length; ++j) {
                    builder.append("\"");
                    builder.append(elements[j]);
                }
                continue;
            }
            builder.append(result[i]);
        }
        return builder.toString();
    }
}

