/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalDirectedGraph;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.Node;
import org.gephi.statistics.plugin.ArrayWrapper;
import org.gephi.statistics.plugin.EdgeWrapper;
import org.gephi.statistics.plugin.Renumbering;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.TempDirUtils;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.Lookup;

public class ClusteringCoefficient
implements Statistics,
LongTask {
    public static final String CLUSTERING_COEFF = "clustering";
    private double avgClusteringCoeff;
    private boolean isDirected;
    private boolean isCanceled;
    private ProgressTicket progress;
    private int[] triangles;
    private ArrayWrapper[] network;
    private int K;
    private int N;
    private double[] nodeClustering;
    private int totalTriangles;

    public ClusteringCoefficient() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getModel() != null) {
            this.isDirected = graphController.getModel().isDirected();
        }
    }

    public double getAverageClusteringCoefficient() {
        return this.avgClusteringCoeff;
    }

    public void execute(GraphModel graphModel, AttributeModel attributeModel) {
        HierarchicalGraph hgraph = null;
        hgraph = !this.isDirected ? graphModel.getHierarchicalUndirectedGraphVisible() : graphModel.getHierarchicalDirectedGraphVisible();
        this.execute(hgraph, attributeModel);
    }

    public void execute(HierarchicalGraph hgraph, AttributeModel attributeModel) {
        this.isCanceled = false;
        this.triangles(hgraph, attributeModel);
    }

    private int closest_in_array(int v) {
        int right = this.network[v].length() - 1;
        if (right < 0) {
            return -1;
        }
        if (this.network[v].get(0) >= v) {
            return -1;
        }
        if (this.network[v].get(right) < v) {
            return right;
        }
        if (this.network[v].get(right) == v) {
            return right - 1;
        }
        int left = 0;
        while (right > left) {
            int mid = (left + right) / 2;
            if (v < this.network[v].get(mid)) {
                right = mid - 1;
                continue;
            }
            if (v > this.network[v].get(mid)) {
                left = mid + 1;
                continue;
            }
            return mid - 1;
        }
        if (v > this.network[v].get(right)) {
            return right;
        }
        return right - 1;
    }

    private void newVertex(int v) {
        int neighbor;
        int i;
        int[] A = new int[this.N];
        for (i = this.network[v].length() - 1; i >= 0 && this.network[v].get(i) > v; --i) {
            neighbor = this.network[v].get(i);
            A[neighbor] = this.network[v].getCount(i);
        }
        for (i = this.network[v].length() - 1; i >= 0; --i) {
            neighbor = this.network[v].get(i);
            for (int j = this.closest_in_array(neighbor); j >= 0; --j) {
                int next = this.network[neighbor].get(j);
                if (A[next] <= 0) continue;
                int n = next;
                this.triangles[n] = this.triangles[n] + this.network[v].getCount(i);
                int n2 = v;
                this.triangles[n2] = this.triangles[n2] + this.network[v].getCount(i);
                int n3 = neighbor;
                this.triangles[n3] = this.triangles[n3] + A[next];
            }
        }
    }

    private void tr_link_nohigh(int u, int v, int count) {
        int iu = 0;
        int iv = 0;
        while (iu < this.network[u].length() && iv < this.network[v].length()) {
            if (this.network[u].get(iu) < this.network[v].get(iv)) {
                ++iu;
                continue;
            }
            if (this.network[u].get(iu) > this.network[v].get(iv)) {
                ++iv;
                continue;
            }
            int w = this.network[u].get(iu);
            if (w >= this.K) {
                int n = w;
                this.triangles[n] = this.triangles[n] + count;
            }
            ++iu;
            ++iv;
        }
    }

    private void triangles(HierarchicalGraph hgraph, AttributeModel attributeModel) {
        int v;
        int j;
        int ProgressCount = 0;
        Progress.start(this.progress, 7 * hgraph.getNodeCount());
        hgraph.readLock();
        this.N = hgraph.getNodeCount();
        this.nodeClustering = new double[this.N];
        this.network = new ArrayWrapper[this.N];
        HashMap<Node, Integer> indicies = new HashMap<Node, Integer>();
        int index = 0;
        for (Node s : hgraph.getNodes()) {
            indicies.put(s, index);
            this.network[index] = new ArrayWrapper();
            ++index;
            Progress.progress(this.progress, ++ProgressCount);
        }
        index = 0;
        for (Node node : hgraph.getNodes()) {
            HashMap<Node, EdgeWrapper> neighborTable = new HashMap<Node, EdgeWrapper>();
            if (!this.isDirected) {
                for (Node neighbor : hgraph.getNeighbors(node)) {
                    neighborTable.put(neighbor, new EdgeWrapper(1, this.network[(Integer)indicies.get(neighbor)]));
                }
            } else {
                Node neighbor;
                for (Edge in : ((HierarchicalDirectedGraph)hgraph).getInEdgesAndMetaInEdges(node)) {
                    neighbor = in.getSource();
                    neighborTable.put(neighbor, new EdgeWrapper(1, this.network[(Integer)indicies.get(neighbor)]));
                }
                for (Edge out : ((HierarchicalDirectedGraph)hgraph).getOutEdgesAndMetaOutEdges(node)) {
                    neighbor = out.getTarget();
                    EdgeWrapper ew = (EdgeWrapper)neighborTable.get(neighbor);
                    if (ew == null) {
                        neighborTable.put(neighbor, new EdgeWrapper(1, this.network[(Integer)indicies.get(neighbor)]));
                        continue;
                    }
                    ++ew.count;
                }
            }
            EdgeWrapper[] edges = new EdgeWrapper[neighborTable.size()];
            int i = 0;
            Iterator i$ = neighborTable.values().iterator();
            while (i$.hasNext()) {
                EdgeWrapper e;
                edges[i] = e = (EdgeWrapper)i$.next();
                ++i;
            }
            this.network[index].node = node;
            this.network[index].setArray(edges);
            ++index;
            Progress.progress(this.progress, ++ProgressCount);
            if (!this.isCanceled) continue;
            hgraph.readUnlockAll();
            return;
        }
        Arrays.sort(this.network);
        for (j = 0; j < this.N; ++j) {
            this.network[j].setID(j);
            Progress.progress(this.progress, ++ProgressCount);
        }
        for (j = 0; j < this.N; ++j) {
            Arrays.sort(this.network[j].getArray(), new Renumbering());
            Progress.progress(this.progress, ++ProgressCount);
        }
        this.triangles = new int[this.N];
        this.K = (int)Math.sqrt(this.N);
        for (v = 0; v < this.K && v < this.N; ++v) {
            this.newVertex(v);
            Progress.progress(this.progress, ++ProgressCount);
        }
        for (v = this.N - 1; v >= 0 && v >= this.K; --v) {
            for (int i = this.closest_in_array(v); i >= 0; --i) {
                int u = this.network[v].get(i);
                if (u < this.K) continue;
                this.tr_link_nohigh(u, v, this.network[v].getCount(i));
            }
            Progress.progress(this.progress, ++ProgressCount);
            if (!this.isCanceled) continue;
            hgraph.readUnlockAll();
            return;
        }
        this.avgClusteringCoeff = 0.0;
        AttributeTable nodeTable = attributeModel.getNodeTable();
        AttributeColumn clusteringCol = nodeTable.getColumn(CLUSTERING_COEFF);
        if (clusteringCol == null) {
            clusteringCol = nodeTable.addColumn(CLUSTERING_COEFF, "Clustering Coefficient", AttributeType.DOUBLE, AttributeOrigin.COMPUTED, (Object)new Double(0.0));
        }
        for (Node s : hgraph.getNodes()) {
            int v2 = (Integer)indicies.get(s);
            if (this.network[v2].length() > 1) {
                double cc = this.triangles[v2];
                this.totalTriangles += this.triangles[v2];
                cc /= (double)(this.network[v2].length() * (this.network[v2].length() - 1));
                if (!this.isDirected) {
                    cc *= 2.0;
                }
                this.nodeClustering[v2] = cc;
                AttributeRow row = (AttributeRow)s.getNodeData().getAttributes();
                row.setValue(clusteringCol, (Object)cc);
                this.avgClusteringCoeff += cc;
            }
            Progress.progress(this.progress, ++ProgressCount);
            if (!this.isCanceled) continue;
            hgraph.readUnlockAll();
            return;
        }
        this.totalTriangles /= 3;
        this.avgClusteringCoeff /= (double)this.N;
        hgraph.readUnlock();
    }

    public String getReport() {
        XYSeries series1 = new XYSeries((Comparable)((Object)"Clustering Coefficient"));
        for (int i = 0; i < this.N; ++i) {
            series1.add((double)i, this.nodeClustering[i]);
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Clustering Coefficient Distribution", (String)"Node", (String)"Clustering Ceofficient", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, true);
        renderer.setSeriesShapesVisible(0, false);
        renderer.setSeriesLinesVisible(1, false);
        renderer.setSeriesShapesVisible(1, true);
        renderer.setSeriesShape(1, (Shape)new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0));
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.GRAY);
        plot.setRangeGridlinePaint((Paint)Color.GRAY);
        plot.setRenderer((XYItemRenderer)renderer);
        String imageFile = "";
        try {
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            TempDirUtils.TempDir tempDir = TempDirUtils.createTempDir();
            String fileName = "coefficients.png";
            File file1 = tempDir.createFile("coefficients.png");
            imageFile = "<IMG SRC=\"file:" + file1.getAbsolutePath() + "\" " + "WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\"></IMG>";
            ChartUtilities.saveChartAsPNG((File)file1, (JFreeChart)chart, (int)600, (int)400, (ChartRenderingInfo)info);
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        return "<HTML> <BODY> <h1> Clustering Coefficient Metric Report </h1> <hr><br><h2> Parameters: </h2>Network Interpretation:  " + (this.isDirected ? "directed" : "undirected") + "<br>" + "Average Clustering Coefficient: " + this.avgClusteringCoeff + "<br>" + "Total triangles: " + this.totalTriangles + "<br>" + imageFile + "<br>" + "</BODY> </HTML>";
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket ProgressTicket2) {
        this.progress = ProgressTicket2;
    }
}

