/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.gephi.data.attributes.api.AttributeColumn;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.data.attributes.api.AttributeOrigin;
import org.gephi.data.attributes.api.AttributeRow;
import org.gephi.data.attributes.api.AttributeTable;
import org.gephi.data.attributes.api.AttributeType;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalDirectedGraph;
import org.gephi.graph.api.HierarchicalUndirectedGraph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectedComponents
implements Statistics,
LongTask {
    public static final String WEAKLY = "componentnumber";
    public static final String STRONG = "strongcompnum";
    private boolean isDirected;
    private ProgressTicket progress;
    private boolean isCanceled;
    private int componentCount;
    private int stronglyCount;
    private int[] componentsSize;
    int count;

    public ConnectedComponents() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getModel() != null) {
            this.isDirected = graphController.getModel().isDirected();
        }
    }

    @Override
    public void execute(GraphModel graphModel, AttributeModel attributeModel) {
        HierarchicalUndirectedGraph undirectedGraph = graphModel.getHierarchicalUndirectedGraphVisible();
        this.weaklyConnected(undirectedGraph, attributeModel);
        if (this.isDirected) {
            HierarchicalDirectedGraph directedGraph = graphModel.getHierarchicalDirectedGraphVisible();
            this.top_tarjans(directedGraph, attributeModel);
        }
    }

    public void weaklyConnected(HierarchicalUndirectedGraph hgraph, AttributeModel attributeModel) {
        this.isCanceled = false;
        this.componentCount = 0;
        AttributeTable nodeTable = attributeModel.getNodeTable();
        AttributeColumn componentCol = nodeTable.getColumn(WEAKLY);
        if (componentCol == null) {
            componentCol = nodeTable.addColumn(WEAKLY, "Component ID", AttributeType.INT, AttributeOrigin.COMPUTED, (Object)new Integer(0));
        }
        ArrayList<Integer> sizeList = new ArrayList<Integer>();
        hgraph.readLock();
        HashMap<Node, Integer> indicies = new HashMap<Node, Integer>();
        int index = 0;
        for (Node s : hgraph.getNodes()) {
            indicies.put(s, index);
            ++index;
        }
        int N = hgraph.getNodeCount();
        int[] color = new int[N];
        Progress.start(this.progress, hgraph.getNodeCount());
        int seenCount = 0;
        while (seenCount < N) {
            LinkedList<Node> Q = new LinkedList<Node>();
            LinkedList<Node> component = new LinkedList<Node>();
            NodeIterable iter = hgraph.getNodes();
            for (Node first : iter) {
                if (color[(Integer)indicies.get(first)] != 0) continue;
                Q.add(first);
                iter.doBreak();
                break;
            }
            while (!Q.isEmpty()) {
                if (this.isCanceled) {
                    hgraph.readUnlock();
                    return;
                }
                Node u = (Node)Q.removeFirst();
                component.add(u);
                EdgeIterable edgeIter = hgraph.getEdgesAndMetaEdges(u);
                for (Edge edge : edgeIter) {
                    Node reachable = hgraph.getOpposite(u, edge);
                    int id = (Integer)indicies.get(reachable);
                    if (color[id] != 0) continue;
                    color[id] = 1;
                    Q.addLast(reachable);
                    Progress.progress(this.progress, seenCount);
                }
                color[((Integer)indicies.get((Object)u)).intValue()] = 2;
                ++seenCount;
            }
            for (Node s : component) {
                AttributeRow row = (AttributeRow)s.getNodeData().getAttributes();
                row.setValue(componentCol, (Object)this.componentCount);
            }
            sizeList.add(component.size());
            ++this.componentCount;
        }
        hgraph.readUnlock();
        this.componentsSize = new int[sizeList.size()];
        for (int i = 0; i < sizeList.size(); ++i) {
            this.componentsSize[i] = (Integer)sizeList.get(i);
        }
    }

    public void top_tarjans(HierarchicalDirectedGraph hgraph, AttributeModel attributeModel) {
        this.count = 1;
        this.stronglyCount = 0;
        AttributeTable nodeTable = attributeModel.getNodeTable();
        AttributeColumn componentCol = nodeTable.getColumn(STRONG);
        if (componentCol == null) {
            componentCol = nodeTable.addColumn(STRONG, "Strongly-Connected ID", AttributeType.INT, AttributeOrigin.COMPUTED, (Object)new Integer(0));
        }
        hgraph.readLock();
        HashMap<Node, Integer> indicies = new HashMap<Node, Integer>();
        int v = 0;
        for (Node s : hgraph.getNodes()) {
            indicies.put(s, v);
            ++v;
        }
        int N = hgraph.getNodeCount();
        int[] index = new int[N];
        int[] low_index = new int[N];
        while (true) {
            LinkedList<Node> S = new LinkedList<Node>();
            Node first = null;
            NodeIterable iter = hgraph.getNodes();
            for (Node u : iter) {
                if (index[(Integer)indicies.get(u)] != 0) continue;
                first = u;
                iter.doBreak();
                break;
            }
            if (first == null) {
                hgraph.readUnlockAll();
                return;
            }
            this.tarjans(componentCol, S, hgraph, first, index, low_index, indicies);
        }
    }

    private void tarjans(AttributeColumn col, LinkedList<Node> S, HierarchicalDirectedGraph hgraph, Node f, int[] index, int[] low_index, HashMap<Node, Integer> indicies) {
        int id = indicies.get(f);
        index[id] = this.count;
        low_index[id] = this.count++;
        S.addFirst(f);
        EdgeIterable edgeIter = hgraph.getOutEdgesAndMetaOutEdges(f);
        for (Edge e : edgeIter) {
            Node u = hgraph.getOpposite(f, e);
            int x = indicies.get(u);
            if (index[x] == 0) {
                this.tarjans(col, S, hgraph, u, index, low_index, indicies);
                low_index[id] = Math.min(low_index[x], low_index[id]);
                continue;
            }
            if (!S.contains(u)) continue;
            low_index[id] = Math.min(low_index[id], index[x]);
        }
        if (low_index[id] == index[id]) {
            Node v = null;
            while (v != f) {
                v = S.removeFirst();
                AttributeRow row = (AttributeRow)v.getNodeData().getAttributes();
                row.setValue(col, (Object)this.stronglyCount);
            }
            ++this.stronglyCount;
        }
    }

    public int getConnectedComponentsCount() {
        return this.componentCount;
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    public int[] getComponentsSize() {
        return this.componentsSize;
    }

    public int getGiantComponent() {
        int[] sizes = this.getComponentsSize();
        int max = Integer.MIN_VALUE;
        int maxIndex = -1;
        for (int i = 0; i < sizes.length; ++i) {
            if (sizes[i] <= max) continue;
            max = sizes[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    @Override
    public String getReport() {
        String report = "<HTML> <BODY> <h1>Connected Components Report </h1> <hr><br><h2> Parameters: </h2>Network Interpretation:  " + (this.isDirected ? "directed" : "undirected") + "<br>" + "<br> <h2> Results: </h2>" + "Weakly Connected Components: " + this.componentCount + "<br>" + (this.isDirected ? "Stronlgy Connected Components: " + this.stronglyCount + "<br>" : "") + "</BODY></HTML>";
        return report;
    }

    @Override
    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    @Override
    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }
}

