/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.io.IOException;
import org.gephi.data.attributes.api.AttributeModel;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.HierarchicalDirectedGraph;
import org.gephi.graph.api.HierarchicalGraph;
import org.gephi.graph.api.HierarchicalUndirectedGraph;
import org.gephi.graph.api.Node;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.TempDirUtils;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class DegreeDistribution
implements Statistics,
LongTask {
    private double[][] combinedDistribution;
    private double[][] inDistribution;
    private double[][] outDistribution;
    private boolean isCanceled;
    private ProgressTicket progress;
    private boolean isDirected;
    private double combinedAlpha;
    private double inAlpha;
    private double outAlpha;
    private double combinedBeta;
    private double inBeta;
    private double outBeta;

    public DegreeDistribution() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getModel() != null) {
            this.isDirected = graphController.getModel().isDirected();
        }
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    public double getCombinedPowerLaw() {
        return this.combinedAlpha;
    }

    public double getInPowerLaw() {
        return this.inAlpha;
    }

    public double getOutPowerLaw() {
        return this.outAlpha;
    }

    public void execute(GraphModel graphModel, AttributeModel attributeModel) {
        HierarchicalGraph graph = this.isDirected ? graphModel.getHierarchicalDirectedGraphVisible() : graphModel.getHierarchicalUndirectedGraphVisible();
        this.execute(graph, attributeModel);
    }

    public void execute(HierarchicalGraph graph, AttributeModel attributeModel) {
        this.isCanceled = false;
        graph.readLock();
        Progress.start(this.progress, graph.getNodeCount());
        if (this.isDirected) {
            this.inDistribution = new double[2][2 * graph.getNodeCount()];
            this.outDistribution = new double[2][2 * graph.getNodeCount()];
        } else {
            this.combinedDistribution = new double[2][2 * graph.getNodeCount()];
        }
        int nodeCount = 0;
        for (Node node : graph.getNodes()) {
            if (this.isDirected) {
                int inDegree = ((HierarchicalDirectedGraph)graph).getTotalInDegree(node);
                int outDegree = ((HierarchicalDirectedGraph)graph).getTotalOutDegree(node);
                double[] dArray = this.inDistribution[1];
                int n = inDegree;
                dArray[n] = dArray[n] + 1.0;
                double[] dArray2 = this.outDistribution[1];
                int n2 = outDegree;
                dArray2[n2] = dArray2[n2] + 1.0;
                this.inDistribution[0][inDegree] = inDegree;
                this.outDistribution[0][outDegree] = outDegree;
            } else {
                int combinedDegree = ((HierarchicalUndirectedGraph)graph).getTotalDegree(node);
                double[] dArray = this.combinedDistribution[1];
                int n = combinedDegree;
                dArray[n] = dArray[n] + 1.0;
                this.combinedDistribution[0][combinedDegree] = combinedDegree;
            }
            Progress.progress(this.progress, nodeCount);
            ++nodeCount;
            if (!this.isCanceled) continue;
            graph.readUnlockAll();
            return;
        }
        graph.readUnlock();
        if (this.isDirected) {
            double[] inFit = new double[2];
            double[] outFit = new double[2];
            this.leastSquares(this.inDistribution[1], inFit);
            this.leastSquares(this.outDistribution[1], outFit);
            this.inAlpha = inFit[1];
            this.inBeta = inFit[0];
            this.outAlpha = outFit[1];
            this.outBeta = outFit[0];
        } else {
            double[] fit = new double[2];
            this.leastSquares(this.combinedDistribution[1], fit);
            this.combinedAlpha = fit[1];
            this.combinedBeta = fit[0];
        }
    }

    public void leastSquares(double[] dist, double[] res) {
        int i;
        double SSxx = 0.0;
        double SSxy = 0.0;
        double avgX = 0.0;
        double avgY = 0.0;
        double nonZero = 0.0;
        for (i = 1; i < dist.length; ++i) {
            if (dist[i] > 0.0) {
                avgX += Math.log(i);
                avgY += Math.log(dist[i]);
                nonZero += 1.0;
            }
            if (!this.isCanceled) continue;
            return;
        }
        avgX /= nonZero;
        avgY /= nonZero;
        for (i = 1; i < dist.length; ++i) {
            if (!(dist[i] > 0.0)) continue;
            SSxx += Math.pow(Math.log(i) - avgX, 2.0);
            SSxy += (Math.log(i) - avgX) * (Math.log(dist[i]) - avgY);
        }
        res[0] = SSxy / SSxx;
        res[1] = avgY - res[0] * avgX;
    }

    public String getReport() {
        return this.isDirected ? this.getDirectedReport() : this.getUndirectedReport();
    }

    private String getDirectedReport() {
        double inMax = 0.0;
        XYSeries inSeries2 = new XYSeries((Comparable)((Object)"Series 2"));
        for (int i = 1; i < this.inDistribution[1].length; ++i) {
            if (!(this.inDistribution[1][i] > 0.0)) continue;
            inSeries2.add(Math.log(this.inDistribution[0][i]) / Math.log(Math.E), Math.log(this.inDistribution[1][i]) / Math.log(Math.E));
            inMax = (float)Math.max(Math.log(this.inDistribution[0][i]) / Math.log(Math.E), inMax);
        }
        double inA = this.inAlpha;
        double inB = this.inBeta;
        String inImageFile = "";
        String outImageFile = "";
        try {
            XYSeries inSeries1 = new XYSeries((Comparable)((Object)(this.inAlpha + " ")));
            inSeries1.add(0.0, inA);
            inSeries1.add(inMax, inA + inB * inMax);
            XYSeriesCollection inDataset = new XYSeriesCollection();
            inDataset.addSeries(inSeries1);
            inDataset.addSeries(inSeries2);
            JFreeChart inChart = ChartFactory.createXYLineChart((String)"In-Degree Distribution", (String)"In-Degree", (String)"Occurrence", (XYDataset)inDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            XYPlot inPlot = (XYPlot)inChart.getPlot();
            XYLineAndShapeRenderer inRenderer = new XYLineAndShapeRenderer();
            inRenderer.setSeriesLinesVisible(0, true);
            inRenderer.setSeriesShapesVisible(0, false);
            inRenderer.setSeriesLinesVisible(1, false);
            inRenderer.setSeriesShapesVisible(1, true);
            inRenderer.setSeriesShape(1, (Shape)new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0));
            inPlot.setBackgroundPaint((Paint)Color.WHITE);
            inPlot.setDomainGridlinePaint((Paint)Color.GRAY);
            inPlot.setRangeGridlinePaint((Paint)Color.GRAY);
            inPlot.setRenderer((XYItemRenderer)inRenderer);
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            TempDirUtils.TempDir tempDir = TempDirUtils.createTempDir();
            String fileName = "inDistribution.png";
            File file1 = tempDir.createFile("inDistribution.png");
            inImageFile = "<IMG SRC=\"file:" + file1.getAbsolutePath() + "\" " + "WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\"></IMG>";
            ChartUtilities.saveChartAsPNG((File)file1, (JFreeChart)inChart, (int)600, (int)400, (ChartRenderingInfo)info);
            double outMax = 0.0;
            XYSeries outSeries2 = new XYSeries((Comparable)((Object)"Series 2"));
            for (int i = 1; i < this.outDistribution[1].length; ++i) {
                if (!(this.outDistribution[1][i] > 0.0)) continue;
                outSeries2.add(Math.log(this.outDistribution[0][i]) / Math.log(Math.E), Math.log(this.outDistribution[1][i]) / Math.log(Math.E));
                outMax = (float)Math.max(Math.log(this.outDistribution[0][i]) / Math.log(Math.E), outMax);
            }
            double outA = this.outAlpha;
            double outB = this.outBeta;
            XYSeries outSeries1 = new XYSeries((Comparable)((Object)(this.outAlpha + " ")));
            outSeries1.add(0.0, outA);
            outSeries1.add(outMax, outA + outB * outMax);
            XYSeriesCollection outDataset = new XYSeriesCollection();
            outDataset.addSeries(outSeries1);
            outDataset.addSeries(outSeries2);
            JFreeChart outchart = ChartFactory.createXYLineChart((String)"Out-Degree Distribution", (String)"Out-Degree", (String)"Occurrence", (XYDataset)outDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            XYPlot outPlot = (XYPlot)outchart.getPlot();
            XYLineAndShapeRenderer outRenderer = new XYLineAndShapeRenderer();
            outRenderer.setSeriesLinesVisible(0, true);
            outRenderer.setSeriesShapesVisible(0, false);
            outRenderer.setSeriesLinesVisible(1, false);
            outRenderer.setSeriesShapesVisible(1, true);
            outRenderer.setSeriesShape(1, (Shape)new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0));
            outPlot.setBackgroundPaint((Paint)Color.WHITE);
            outPlot.setDomainGridlinePaint((Paint)Color.GRAY);
            outPlot.setRangeGridlinePaint((Paint)Color.GRAY);
            outPlot.setRenderer((XYItemRenderer)outRenderer);
            ChartRenderingInfo info2 = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            String fileName2 = "outDistribution.png";
            File file2 = tempDir.createFile("outDistribution.png");
            outImageFile = "<IMG SRC=\"file:" + file2.getAbsolutePath() + "\" " + "WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\"></IMG>";
            ChartUtilities.saveChartAsPNG((File)file2, (JFreeChart)outchart, (int)600, (int)400, (ChartRenderingInfo)info2);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        String report = "<HTML> <BODY> <h1>Degree Distribution Metric Report </h1> <hr><br><h2> Parameters: </h2>Network Interpretation:  " + (this.isDirected ? "directed" : "undirected") + "<br>" + "<br> <h2> Results: </h2>" + "In-Degree Power Law: -" + this.inAlpha + "\n <BR>" + inImageFile + "<br>Out-Degree Power Law: -" + this.outAlpha + "\n <BR>" + outImageFile + "</BODY> </HTML>";
        return report;
    }

    private String getUndirectedReport() {
        double max = 0.0;
        XYSeries series2 = new XYSeries((Comparable)((Object)"Series 2"));
        for (int i = 1; i < this.combinedDistribution[1].length; ++i) {
            if (!(this.combinedDistribution[1][i] > 0.0)) continue;
            series2.add(Math.log(this.combinedDistribution[0][i]) / Math.log(Math.E), Math.log(this.combinedDistribution[1][i]) / Math.log(Math.E));
            max = (float)Math.max(Math.log(this.combinedDistribution[0][i]) / Math.log(Math.E), max);
        }
        double a = this.combinedAlpha;
        double b = this.combinedBeta;
        XYSeries series1 = new XYSeries((Comparable)((Object)(this.combinedAlpha + " ")));
        series1.add(0.0, a);
        series1.add(max, a + b * max);
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        dataset.addSeries(series2);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Degree Distribution", (String)"Degree", (String)"Occurrence", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, true);
        renderer.setSeriesShapesVisible(0, false);
        renderer.setSeriesLinesVisible(1, false);
        renderer.setSeriesShapesVisible(1, true);
        renderer.setSeriesShape(1, (Shape)new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0));
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.GRAY);
        plot.setRangeGridlinePaint((Paint)Color.GRAY);
        plot.setRenderer((XYItemRenderer)renderer);
        String imageFile = "";
        try {
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            TempDirUtils.TempDir tempDir = TempDirUtils.createTempDir();
            String fileName = "distribution.png";
            File file1 = tempDir.createFile("distribution.png");
            imageFile = "<IMG SRC=\"file:" + file1.getAbsolutePath() + "\" " + "WIDTH=\"600\" HEIGHT=\"400\" BORDER=\"0\" USEMAP=\"#chart\"></IMG>";
            ChartUtilities.saveChartAsPNG((File)file1, (JFreeChart)chart, (int)600, (int)400, (ChartRenderingInfo)info);
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        String report = "<HTML> <BODY> <h1>Degree Distribution Metric Report </h1> <hr><br><h2> Parameters: </h2>Network Interpretation:  " + (this.isDirected ? "directed" : "undirected") + "<br>" + "<br> <h2> Results: </h2>" + "Degree Power Law: -" + this.combinedAlpha + "\n <BR>" + imageFile + "</BODY> </HTML>";
        return report;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket pProgressTicket) {
        this.progress = pProgressTicket;
    }
}

